/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemanticEditorPosition {
    private final Editor myEditor;
    private final HighlighterIterator myIterator;
    private final CharSequence myChars;
    private final Function<? super IElementType, ? extends SyntaxElement> myTypeMapper;
    private final BiFunction<? super Editor, ? super Integer, ? extends HighlighterIterator> myCreateHighlighterIteratorAtOffset;

    private SemanticEditorPosition(@NotNull Editor editor, int offset, @NotNull BiFunction<? super Editor, ? super Integer, ? extends HighlighterIterator> createHighlighterIteratorAtOffset, @NotNull Function<? super IElementType, ? extends SyntaxElement> typeMapper) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(0);
        }
        if (createHighlighterIteratorAtOffset == null) {
            SemanticEditorPosition.$$$reportNull$$$0(1);
        }
        if (typeMapper == null) {
            SemanticEditorPosition.$$$reportNull$$$0(2);
        }
        this.myCreateHighlighterIteratorAtOffset = createHighlighterIteratorAtOffset;
        this.myEditor = editor;
        this.myChars = this.myEditor.getDocument().getCharsSequence();
        this.myIterator = createHighlighterIteratorAtOffset.apply((Editor)editor, (Integer)offset);
        this.myTypeMapper = typeMapper;
    }

    public void moveBeforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(3);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(4);
        }
        return this.copyAnd(position -> position.moveBeforeOptional(syntaxElement));
    }

    public void moveBeforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(5);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(6);
        }
        return this.copyAnd(position -> position.moveBeforeOptionalMix(elements));
    }

    public void moveAfterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(7);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(8);
        }
        return this.copyAnd(position -> position.moveAfterOptionalMix(elements));
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean hasLineBreaksAfter(int offset) {
        int offsetAfter;
        if (!this.myIterator.atEnd() && offset >= 0 && (offsetAfter = offset + 1) < this.myIterator.getEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)offsetAfter, (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean isAtMultiline(SyntaxElement ... elements) {
        return this.isAtAnyOf(elements) && CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
    }

    public void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition before() {
        return this.copyAnd(position -> position.moveBefore());
    }

    public void moveAfterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(9);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(10);
        }
        return this.copyAnd(position -> position.moveAfterOptional(syntaxElement));
    }

    public void moveAfter() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition after() {
        return this.copyAnd(position -> position.moveAfter());
    }

    public void moveBeforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(11);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(12);
        }
        this.skipParentheses(false, leftParenthesis, rightParenthesis);
    }

    public void moveAfterParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(13);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(14);
        }
        this.skipParentheses(true, leftParenthesis, rightParenthesis);
    }

    private void skipParentheses(boolean forward, @NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(15);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(16);
        }
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            if (forward) {
                this.myIterator.advance();
            } else {
                this.myIterator.retreat();
            }
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(17);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(18);
        }
        return this.copyAnd(position -> position.moveBeforeParentheses(leftParenthesis, rightParenthesis));
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(19);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(20);
        }
        this.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(leftParenthesis, rightParenthesis, any -> false);
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(21);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(22);
        }
        return this.copyAnd(position -> position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis));
    }

    public void moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Predicate<? super SemanticEditorPosition> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(23);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(24);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(25);
        }
        while (!this.myIterator.atEnd() && !terminationCondition.test(this)) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.moveBeforeParentheses(leftParenthesis, rightParenthesis);
                continue;
            }
            if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Predicate<? super SemanticEditorPosition> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(26);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(27);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(28);
        }
        return this.copyAnd(position -> position.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(leftParenthesis, rightParenthesis, terminationCondition));
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(29);
        }
        return this.elementAfterOnSameLine(syntaxElements) != null;
    }

    @Nullable
    public SyntaxElement elementAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(30);
        }
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element2 : syntaxElements) {
                if (!element2.equals(currElement)) continue;
                return element2;
            }
            this.myIterator.retreat();
        }
        return null;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(31);
        }
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(32);
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(33);
        }
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element2 : syntaxElements) {
                if (!element2.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element2) {
        if (element2 == null) {
            SemanticEditorPosition.$$$reportNull$$$0(34);
        }
        while (!this.myIterator.atEnd()) {
            if (element2.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i2 = offset + 1; i2 < this.myIterator.getEnd(); ++i2) {
            if (this.myChars.charAt(i2) != '\n') continue;
            return true;
        }
        return false;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        if (language != null && !this.myIterator.atEnd()) {
            return language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language);
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        if (rule == null) {
            SemanticEditorPosition.$$$reportNull$$$0(35);
        }
        return rule.check(this);
    }

    public SyntaxElement map(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(36);
        }
        return this.myTypeMapper.apply((IElementType)elementType);
    }

    public String toString() {
        return this.myIterator.atEnd() ? "atEnd" : this.myIterator.getTokenType().toString() + "=>" + this.getChars().subSequence(this.getStartOffset(), Integer.min(this.getStartOffset() + 255, this.getChars().length()));
    }

    public SemanticEditorPosition copy() {
        return SemanticEditorPosition.createEditorPosition(this.myEditor, this.isAtEnd() ? -1 : this.myIterator.getStart(), (editor, offset) -> !this.isAtEnd() ? this.myCreateHighlighterIteratorAtOffset.apply((Editor)editor, (Integer)offset) : new HighlighterIteratorWrapper(this.myIterator){

            @Override
            public void advance() {
            }

            @Override
            public void retreat() {
            }
        }, this.myTypeMapper);
    }

    public SemanticEditorPosition copyAnd(@NotNull Consumer<? super SemanticEditorPosition> modifier) {
        if (modifier == null) {
            SemanticEditorPosition.$$$reportNull$$$0(37);
        }
        SemanticEditorPosition position = this.copy();
        modifier.accept(position);
        return position;
    }

    @NotNull
    public static SemanticEditorPosition createEditorPosition(@NotNull Editor editor, int offset, @NotNull BiFunction<? super Editor, ? super Integer, ? extends HighlighterIterator> createHighlighterIteratorAtOffset, @NotNull Function<? super IElementType, ? extends SyntaxElement> typeMapper) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(38);
        }
        if (createHighlighterIteratorAtOffset == null) {
            SemanticEditorPosition.$$$reportNull$$$0(39);
        }
        if (typeMapper == null) {
            SemanticEditorPosition.$$$reportNull$$$0(40);
        }
        return new SemanticEditorPosition(editor, offset, createHighlighterIteratorAtOffset, typeMapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createHighlighterIteratorAtOffset";
                break;
            }
            case 2: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenthesis";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightParenthesis";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCondition";
                break;
            }
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeOptional";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeOptional";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeOptionalMix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeOptionalMix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfterOptionalMix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "afterOptionalMix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfterOptional";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "afterOptional";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeParentheses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfterParentheses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "skipParentheses";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeParentheses";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "findLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToLeftParenthesisBackwardsSkippingNestedWithPredicate";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "findLeftParenthesisBackwardsSkippingNestedWithPredicate";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterOnSameLine";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "elementAfterOnSameLine";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "isAt";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtAnyOf";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "findStartOf";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesRule";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "copyAnd";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditorPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }

    public static interface SyntaxElement {
    }
}

