/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeManipulator
extends AbstractElementManipulator<XmlAttribute> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeManipulator.class);

    public XmlAttribute handleContentChange(@NotNull XmlAttribute attribute, @NotNull TextRange range2, String newContent) throws IncorrectOperationException {
        if (attribute == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(1);
        }
        String attr = attribute.getText();
        ASTNode astNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
        assert (astNode != null);
        PsiElement namePsi = astNode.getPsi();
        int startOffsetInParent = namePsi.getStartOffsetInParent();
        TextRange nameRange = new TextRange(startOffsetInParent, startOffsetInParent + namePsi.getTextLength());
        if (nameRange.contains(range2)) {
            String content2 = attr.substring(0, range2.getStartOffset()) + newContent + attr.substring(range2.getEndOffset(), nameRange.getEndOffset());
            attribute.setName(content2);
        } else {
            XmlAttributeValue value2 = attribute.getValueElement();
            if (value2 == null) {
                assert (range2.getStartOffset() == 0 && range2.getEndOffset() == 0);
                attribute.setValue(newContent);
                return attribute;
            }
            StringBuilder replacement = new StringBuilder(value2.getText());
            int offset = value2.getTextRange().getStartOffset() - attribute.getTextRange().getStartOffset();
            replacement.replace(range2.getStartOffset() - offset, range2.getEndOffset() - offset, newContent);
            attribute.setValue(replacement.toString());
        }
        return attribute;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttribute attribute) {
        XmlAttributeValue value2;
        if (attribute == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(2);
        }
        if ((value2 = attribute.getValueElement()) == null) {
            TextRange textRange = TextRange.from((int)0, (int)0);
            if (textRange == null) {
                XmlAttributeManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange range2 = attribute.getValueTextRange();
        if (range2 == null) {
            LOG.error("Null range in " + attribute + " '" + attribute.getText() + "'");
        }
        TextRange textRange = range2.shiftRight(value2.getStartOffsetInParent());
        if (textRange == null) {
            XmlAttributeManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

