/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeOrElementOrAttributeReference
implements PsiReference {
    @NonNls
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private final PsiElement myElement;
    private TextRange myRange;
    private String nsPrefix;
    @Nullable
    private final ReferenceType myType;
    static final ResolveCache.Resolver RESOLVER = (ref, incompleteCode) -> ((TypeOrElementOrAttributeReference)ref).resolveInner();

    @Nullable
    public ReferenceType getType() {
        return this.myType;
    }

    public void setNamespacePrefix(String prefix2) {
        this.nsPrefix = prefix2;
    }

    protected TypeOrElementOrAttributeReference(PsiElement element2, TextRange range2, @Nullable ReferenceType type) {
        this.myElement = element2;
        this.myRange = range2;
        assert (this.myRange.getLength() >= 0);
        this.myType = type;
    }

    TypeOrElementOrAttributeReference(PsiElement element2, TextRange range2) {
        this(element2, range2, TypeOrElementOrAttributeReference.determineReferenceType(element2));
    }

    @Nullable
    private static ReferenceType determineReferenceType(PsiElement element2) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class);
        if (attribute == null) {
            return null;
        }
        XmlTag tag2 = attribute.getParent();
        String localName = tag2.getLocalName();
        String attributeLocalName = attribute.getLocalName();
        if ("ref".equals(attributeLocalName) || "substitutionGroup".equals(attributeLocalName)) {
            if (localName.equals("group")) {
                return ReferenceType.GroupReference;
            }
            if (localName.equals("attributeGroup")) {
                return ReferenceType.AttributeGroupReference;
            }
            if ("element".equals(localName)) {
                return ReferenceType.ElementReference;
            }
            if ("attribute".equals(localName)) {
                return ReferenceType.AttributeReference;
            }
        } else if ("type".equals(attributeLocalName) || "base".equals(attributeLocalName) || "memberTypes".equals(attributeLocalName) || "itemType".equals(attributeLocalName)) {
            return ReferenceType.TypeReference;
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return ResolveCache.getInstance(this.getElement().getProject()).resolveWithCaching(this, (ref, incompleteCode) -> ref.resolveInner(), false, false);
    }

    private PsiElement resolveInner() {
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myElement, XmlTag.class, (boolean)false);
        if (tag2 == null) {
            return null;
        }
        String canonicalText = this.getCanonicalText();
        boolean[] redefined = new boolean[1];
        XsdNsDescriptor nsDescriptor = this.getDescriptor(tag2, canonicalText, redefined);
        if (this.myType != null && nsDescriptor != null) {
            switch (this.myType) {
                case GroupReference: {
                    return nsDescriptor.findGroup(canonicalText);
                }
                case AttributeGroupReference: {
                    return nsDescriptor.findAttributeGroup(canonicalText);
                }
                case ElementReference: {
                    XmlElementDescriptor descriptor2 = nsDescriptor.getElementDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), TypeOrElementOrAttributeReference.getNamespace(tag2, canonicalText), new HashSet(), true);
                    return descriptor2 != null ? descriptor2.getDeclaration() : null;
                }
                case AttributeReference: {
                    String localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(canonicalText);
                    XmlAttributeDescriptor descriptor3 = nsDescriptor.getAttribute(localNameByQualifiedName, TypeOrElementOrAttributeReference.getNamespace(tag2, canonicalText), tag2);
                    if (descriptor3 != null) {
                        return descriptor3.getDeclaration();
                    }
                    return null;
                }
                case TypeReference: {
                    TypeDescriptor typeDescriptor;
                    TypeDescriptor typeDescriptor2 = typeDescriptor = redefined[0] ? nsDescriptor.findTypeDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), "") : nsDescriptor.getTypeDescriptor(canonicalText, tag2);
                    if (typeDescriptor instanceof ComplexTypeDescriptor) {
                        return typeDescriptor.getDeclaration();
                    }
                    if (typeDescriptor == null) break;
                    return this.myElement;
                }
            }
        }
        return null;
    }

    XsdNsDescriptor getDescriptor(XmlTag tag2, String text2, boolean[] redefined) {
        if (this.myType != ReferenceType.ElementReference && this.myType != ReferenceType.AttributeReference) {
            XmlNSDescriptorImpl redefinedDescriptor;
            PsiElement parentElement = this.myElement.getContext();
            PsiElement grandParentElement = parentElement != null ? parentElement.getParent() : null;
            boolean doRedefineCheck = false;
            if (parentElement instanceof XmlAttribute && grandParentElement instanceof XmlTag) {
                String attrName = ((XmlAttribute)parentElement).getName();
                String tagLocalName = ((XmlTag)grandParentElement).getLocalName();
                boolean bl = doRedefineCheck = "ref".equals(attrName) && ("group".equals(tagLocalName) || "attributeGroup".equals(tagLocalName)) || "base".equals(attrName) || "memberTypes".equals(attrName);
            }
            if (doRedefineCheck && (redefinedDescriptor = SchemaReferencesProvider.findRedefinedDescriptor(tag2, text2)) != null) {
                redefined[0] = true;
                return redefinedDescriptor;
            }
        }
        String namespace = TypeOrElementOrAttributeReference.getNamespace(tag2, text2);
        XmlNSDescriptor nsDescriptor = tag2.getNSDescriptor(namespace, true);
        PsiFile file2 = tag2.getContainingFile();
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file2).getDocument();
        if (nsDescriptor == null) {
            nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        if (nsDescriptor == null) {
            XmlNSDescriptor[] descrs = new XmlNSDescriptor[1];
            URLReference.processWsdlSchemas(document.getRootTag(), (Processor<? super XmlTag>)((Processor)xmlTag -> {
                if (namespace.equals(xmlTag.getAttributeValue(TARGET_NAMESPACE))) {
                    descrs[0] = (XmlNSDescriptor)xmlTag.getMetaData();
                    return false;
                }
                return true;
            }));
            if (descrs[0] instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)descrs[0];
            }
        }
        return nsDescriptor instanceof XsdNsDescriptor ? (XsdNsDescriptor)nsDescriptor : null;
    }

    @NotNull
    private static String getNamespace(@NotNull XmlTag tag2, String text2) {
        String targetNsPrefix;
        String targetNS;
        String namespacePrefix;
        String namespaceByPrefix;
        if (tag2 == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(2);
        }
        if (!(namespaceByPrefix = tag2.getNamespaceByPrefix(namespacePrefix = XmlUtil.findPrefixByQualifiedName(text2))).isEmpty()) {
            String string = namespaceByPrefix;
            if (string == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(3);
            }
            return string;
        }
        XmlTag rootTag = ((XmlFile)tag2.getContainingFile()).getRootTag();
        if (rootTag != null && "schema".equals(rootTag.getLocalName()) && XmlUtil.ourSchemaUrisList.contains(rootTag.getNamespace()) && (targetNS = rootTag.getAttributeValue(TARGET_NAMESPACE)) != null && (namespacePrefix.equals(targetNsPrefix = rootTag.getPrefixByNamespace(targetNS)) || targetNsPrefix == null)) {
            String string = targetNS;
            if (string == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = namespaceByPrefix;
        if (string == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        Object name;
        String text2 = this.myElement.getText();
        Object object = name = this.myRange.getEndOffset() <= text2.length() ? this.myRange.substring(text2) : "";
        if (!((String)name).isEmpty() && this.nsPrefix != null && !this.nsPrefix.isEmpty()) {
            name = this.nsPrefix + ":" + (String)name;
        }
        String string = name;
        if (string == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(7);
        }
        String canonicalText = this.getCanonicalText();
        PsiElement element2 = ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
        this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getEndOffset() - (canonicalText.length() - newElementName.length()));
        return element2;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(8);
        }
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(9);
        }
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element2);
    }

    public Object @NotNull [] getVariants() {
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myElement, XmlTag.class, (boolean)true);
        if (tag2 == null || this.myType == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(10);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = TypeOrElementOrAttributeReference.getVariants(tag2, this.myType, this.nsPrefix);
        if (objectArray == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    public static Object[] getVariants(XmlTag tag2, ReferenceType type, String prefix2) {
        String ourNamespace;
        String[] tagNames = null;
        switch (type) {
            case GroupReference: {
                tagNames = new String[]{"group"};
                break;
            }
            case AttributeGroupReference: {
                tagNames = new String[]{"attributeGroup"};
                break;
            }
            case AttributeReference: {
                tagNames = new String[]{"attribute"};
                break;
            }
            case ElementReference: {
                tagNames = new String[]{"element"};
                break;
            }
            case TypeReference: {
                tagNames = new String[]{"simpleType", "complexType"};
            }
        }
        XmlDocument document = ((XmlFile)tag2.getContainingFile()).getDocument();
        if (document == null) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        XmlTag rootTag = document.getRootTag();
        String string = ourNamespace = rootTag != null ? rootTag.getAttributeValue(TARGET_NAMESPACE) : "";
        if (ourNamespace == null) {
            ourNamespace = "";
        }
        CompletionProcessor processor2 = new CompletionProcessor(tag2, prefix2);
        for (String namespace : tag2.knownNamespaces()) {
            XmlNSDescriptor nsDescriptor;
            if (ourNamespace.equals(namespace) || !((nsDescriptor = tag2.getNSDescriptor(namespace, true)) instanceof XsdNsDescriptor)) continue;
            TypeOrElementOrAttributeReference.processNamespace(namespace, processor2, (XsdNsDescriptor)nsDescriptor, tagNames);
        }
        XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        if (nsDescriptor instanceof XmlNSDescriptorImpl) {
            TypeOrElementOrAttributeReference.processNamespace(ourNamespace, processor2, (XmlNSDescriptorImpl)nsDescriptor, tagNames);
        }
        return ArrayUtilRt.toStringArray(processor2.myElements);
    }

    private static void processNamespace(String namespace, CompletionProcessor processor2, XsdNsDescriptor nsDescriptor, String[] tagNames) {
        processor2.namespace = namespace;
        nsDescriptor.processTagsInNamespace(tagNames, processor2);
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompletionProcessor
    implements PsiElementProcessor<XmlTag> {
        final List<String> myElements = new ArrayList<String>(1);
        String namespace;
        final XmlTag tag;
        private final String prefix;

        CompletionProcessor(XmlTag tag2, String prefix2) {
            this.tag = tag2;
            this.prefix = prefix2;
        }

        public boolean execute(@NotNull XmlTag element2) {
            if (element2 == null) {
                CompletionProcessor.$$$reportNull$$$0(0);
            }
            Object name = element2.getAttributeValue("name");
            String prefixByNamespace = this.tag.getPrefixByNamespace(this.namespace);
            if (prefixByNamespace != null && !prefixByNamespace.isEmpty() && this.prefix == null) {
                name = prefixByNamespace + ":" + (String)name;
            }
            this.myElements.add((String)name);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference$CompletionProcessor", "execute"));
        }
    }

    public static enum ReferenceType {
        ElementReference,
        AttributeReference,
        GroupReference,
        AttributeGroupReference,
        TypeReference;

    }
}

