/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StubTreeLoaderImpl
extends StubTreeLoader {
    private static final Logger LOG = Logger.getInstance(StubTreeLoaderImpl.class);
    private static volatile boolean ourStubReloadingProhibited;

    StubTreeLoaderImpl() {
    }

    @Override
    @Nullable
    public ObjectStubTree<?> readOrBuild(@NotNull Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        ObjectStubTree<?> fromIndices;
        if (project == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(1);
        }
        if ((fromIndices = this.readFromVFile(project, vFile)) != null) {
            return fromIndices;
        }
        return this.build(project, vFile, psiFile);
    }

    @Override
    @Nullable
    public ObjectStubTree<?> build(@Nullable Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(2);
        }
        try {
            byte[] content2 = vFile.contentsToByteArray();
            return (ObjectStubTree)vFile.computeWithPreloadedContentHint(content2, () -> {
                ObjectStubTree tree;
                Stub element2;
                FileContentImpl fc = (FileContentImpl)FileContentImpl.createByContent(vFile, content2);
                if (project != null) {
                    LOG.assertTrue(!project.isDefault());
                    fc.setProject(project);
                }
                if (psiFile != null && !vFile.getFileType().isBinary()) {
                    fc.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, psiFile.getViewProvider().getContents());
                }
                if ((element2 = (Stub)RecursionManager.doPreventingRecursion((Object)vFile, (boolean)false, () -> StubTreeBuilder.buildStubTree((FileContent)fc))) instanceof PsiFileStub) {
                    tree = new StubTree((PsiFileStub)element2);
                } else {
                    ObjectStubTree objectStubTree = tree = element2 instanceof ObjectStubBase ? new ObjectStubTree((ObjectStubBase)element2, true) : null;
                }
                if (tree != null) {
                    tree.setDebugInfo("created from file content");
                    return tree;
                }
                return null;
            });
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            } else {
                LOG.info("Can't load file content for stub building: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    @Nullable
    public ObjectStubTree<?> readFromVFile(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(4);
        }
        if (DumbService.getInstance((Project)project).isDumb() || NoAccessDuringPsiEvents.isInsideEventProcessing()) {
            return null;
        }
        boolean wasIndexedAlready = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).isFileUpToDate(vFile);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        boolean saved = document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document);
        SerializedStubTree stubTree = (SerializedStubTree)FileBasedIndex.getInstance().getSingleEntryIndexData(StubUpdatingIndex.INDEX_ID, vFile, project);
        if (stubTree != null) {
            Stub stub;
            if (vFile instanceof VirtualFileWithId && !this.checkLengthMatch(project, vFile, wasIndexedAlready, document, saved)) {
                return null;
            }
            try {
                stub = stubTree.getStub();
            }
            catch (SerializerNotFoundException e) {
                return StubTreeLoaderImpl.processError(vFile, "No stub serializer: " + vFile.getPresentableUrl() + ": " + e.getMessage(), (Exception)((Object)e));
            }
            if (stub == SerializedStubTree.NO_STUB) {
                return null;
            }
            ObjectStubTree tree = stub instanceof PsiFileStub ? new StubTree((PsiFileStub)stub) : new ObjectStubTree((ObjectStubBase)stub, true);
            tree.setDebugInfo("created from index");
            StubTreeLoaderImpl.checkDeserializationCreatesNoPsi(tree);
            return tree;
        }
        return null;
    }

    private boolean checkLengthMatch(Project project, VirtualFile vFile, boolean wasIndexedAlready, Document document, boolean saved) {
        PsiFile cachedPsi = PsiManagerEx.getInstanceEx(project).getFileManager().getCachedPsiFile(vFile);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(vFile);
        if (indexingStampInfo != null && !indexingStampInfo.contentLengthMatches(vFile.getLength(), StubTreeLoaderImpl.getCurrentTextContentLength(project, vFile, document, cachedPsi))) {
            this.diagnoseLengthMismatch(vFile, wasIndexedAlready, document, saved, cachedPsi);
            return false;
        }
        return true;
    }

    private void diagnoseLengthMismatch(@NotNull VirtualFile vFile, boolean wasIndexedAlready, @Nullable Document document, boolean saved, @Nullable PsiFile cachedPsi) {
        Path nioPath;
        if (vFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(5);
        }
        String message2 = "Outdated stub in index: " + vFile + " " + this.getIndexingStampInfo(vFile) + ", doc=" + document + ", docSaved=" + saved + ", wasIndexedAlready=" + wasIndexedAlready + ", queried at " + vFile.getTimeStamp();
        message2 = message2 + "\ndoc length=" + (document == null ? -1 : document.getTextLength()) + "\nfile length=" + vFile.getLength();
        if (cachedPsi != null) {
            message2 = message2 + "\ncached PSI " + cachedPsi.getClass();
            if (cachedPsi instanceof PsiFileImpl && ((PsiFileImpl)cachedPsi).isContentsLoaded()) {
                message2 = message2 + "\nPSI length=" + cachedPsi.getTextLength();
            }
            List projects = ContainerUtil.findAll((Object[])ProjectManager.getInstance().getOpenProjects(), p -> PsiManagerEx.getInstanceEx(p).getFileManager().findCachedViewProvider(vFile) != null);
            message2 = message2 + "\nprojects with file: " + (Serializable)(LOG.isDebugEnabled() ? projects.toString() : Integer.valueOf(projects.size()));
        }
        if ((nioPath = vFile.getFileSystem().getNioPath(vFile)) != null) {
            message2 = message2 + StubTreeLoaderImpl.getPhysicalFileReport(nioPath);
        }
        StubTreeLoaderImpl.processError(vFile, message2, new Exception());
    }

    private static String getPhysicalFileReport(@NotNull Path file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(6);
        }
        String message2 = "\nphysical file " + (Files.exists(file2, new LinkOption[0]) ? "exists" : "doesn't exist") + "; length = ";
        try {
            message2 = message2 + Files.size(file2);
        }
        catch (IOException e) {
            message2 = message2 + e.getMessage();
        }
        return message2;
    }

    private static void checkDeserializationCreatesNoPsi(ObjectStubTree<?> tree) {
        if (ourStubReloadingProhibited || !(tree instanceof StubTree)) {
            return;
        }
        for (PsiFileStub root : ((PsiFileStubImpl)tree.getRoot()).getStubRoots()) {
            if (!(root instanceof StubBase)) continue;
            StubList stubList = ((StubBase)root).myStubList;
            for (int i2 = 0; i2 < stubList.size(); ++i2) {
                PsiElement cachedPsi;
                StubBase each = stubList.getCachedStub(i2);
                PsiElement psiElement = cachedPsi = each == null ? null : each.getCachedPsi();
                if (cachedPsi == null) continue;
                ourStubReloadingProhibited = true;
                throw new AssertionError((Object)("Stub deserialization shouldn't create PSI: " + cachedPsi + "; " + each));
            }
        }
    }

    private static int getCurrentTextContentLength(Project project, VirtualFile vFile, Document document, PsiFile psiFile) {
        if (vFile.getFileType().isBinary()) {
            return -1;
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            return psiFile.getTextLength();
        }
        if (document != null) {
            return PsiDocumentManager.getInstance((Project)project).getLastCommittedText(document).length();
        }
        return -1;
    }

    private static ObjectStubTree<?> processError(VirtualFile vFile, String message2, @Nullable Exception e) {
        LOG.error(message2, (Throwable)e);
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> {
            Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
            if (doc != null) {
                FileDocumentManager.getInstance().saveDocument(doc);
            }
            FileBasedIndex.getInstance().requestReindex(vFile);
        });
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile2) {
        FileBasedIndex.getInstance().requestReindex(virtualFile2);
    }

    @Override
    public boolean canHaveStub(VirtualFile file2) {
        return StubUpdatingIndex.canHaveStub(file2);
    }

    @Override
    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(7);
        }
        int count = 0;
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (PsiManagerEx.getInstanceEx(project).getFileManager().findCachedViewProvider(virtualFile2) == null) continue;
            ++count;
        }
        return count > 1;
    }

    @Override
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(8);
        }
        return StubUpdatingIndex.readSavedIndexingStampInfo(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/StubTreeLoaderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readOrBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromVFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "diagnoseLengthMismatch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPhysicalFileReport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPsiInManyProjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexingStampInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

