/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameSuggester {
    private static final Logger LOG = Logger.getInstance(NameSuggester.class);
    private final String[] myOldClassName;
    private final String[] myNewClassName;
    private final List<OriginalToNewChange> myChanges;
    private final String myOldClassNameAsGiven;
    private final String myNewClassNameAsGiven;

    public NameSuggester(String oldClassName, String newClassName) {
        this.myOldClassNameAsGiven = oldClassName;
        this.myNewClassNameAsGiven = newClassName;
        this.myOldClassName = NameUtilCore.splitNameIntoWords((String)oldClassName);
        this.myNewClassName = NameUtilCore.splitNameIntoWords((String)newClassName);
        this.myChanges = new ArrayList<OriginalToNewChange>();
        int oldLastMatch = this.myOldClassName.length;
        int newLastMatch = this.myNewClassName.length;
        for (int oldIndex = this.myOldClassName.length - 1; oldIndex >= 0; --oldIndex) {
            String patternWord = this.myOldClassName[oldIndex];
            int matchingWordIndex = this.findInNewBackwardsFromIndex(patternWord, newLastMatch - 1);
            if (matchingWordIndex < 0) continue;
            if (oldIndex + 1 <= oldLastMatch - 1 || matchingWordIndex + 1 <= newLastMatch - 1) {
                OriginalToNewChange change = new OriginalToNewChange(oldIndex + 1, oldLastMatch - 1, matchingWordIndex + 1, newLastMatch - 1);
                this.myChanges.add(change);
            }
            oldLastMatch = oldIndex;
            newLastMatch = matchingWordIndex;
        }
        if (0 <= oldLastMatch - 1 || 0 <= newLastMatch - 1) {
            this.myChanges.add(new OriginalToNewChange(0, oldLastMatch - 1, 0, newLastMatch - 1));
        }
    }

    private int findInNewBackwardsFromIndex(String patternWord, int newIndex) {
        for (int i2 = newIndex; i2 >= 0; --i2) {
            String s = this.myNewClassName[i2];
            if (!s.equals(patternWord)) continue;
            return i2;
        }
        return -1;
    }

    List<Pair<String, String>> getChanges() {
        ArrayList<Pair<String, String>> result2 = new ArrayList<Pair<String, String>>();
        for (int i2 = this.myChanges.size() - 1; i2 >= 0; --i2) {
            OriginalToNewChange change = this.myChanges.get(i2);
            result2.add((Pair<String, String>)Pair.create((Object)change.getOldString(), (Object)change.getNewString()));
        }
        return result2;
    }

    public String suggestName(String propertyName) {
        if (this.myOldClassNameAsGiven.equals(propertyName)) {
            return this.myNewClassNameAsGiven;
        }
        String[] propertyWords = NameUtilCore.splitNameIntoWords((String)propertyName);
        TIntIntHashMap matches = this.calculateMatches(propertyWords);
        if (matches.isEmpty()) {
            return propertyName;
        }
        TreeMap<Pair<Integer, Integer>, String> replacements = this.calculateReplacements(propertyWords, matches);
        if (replacements.isEmpty()) {
            return propertyName;
        }
        return NameSuggester.calculateNewName(replacements, propertyWords, propertyName);
    }

    private static Pair<int[], int[]> calculateWordPositions(String s, String[] words) {
        int[] starts = new int[words.length + 1];
        int[] prevEnds = new int[words.length + 1];
        prevEnds[0] = -1;
        int pos = 0;
        for (int i2 = 0; i2 < words.length; ++i2) {
            String word = words[i2];
            int index2 = s.indexOf(word, pos);
            LOG.assertTrue(index2 >= 0);
            starts[i2] = index2;
            pos = index2 + word.length();
            prevEnds[i2 + 1] = pos - 1;
        }
        starts[words.length] = s.length();
        return Pair.create((Object)starts, (Object)prevEnds);
    }

    private static String calculateNewName(TreeMap<Pair<Integer, Integer>, String> replacements, String[] propertyWords, String propertyName) {
        StringBuffer resultingWords = new StringBuffer();
        int currentWord = 0;
        Pair<int[], int[]> wordIndicies = NameSuggester.calculateWordPositions(propertyName, propertyWords);
        for (Map.Entry<Pair<Integer, Integer>, String> entry2 : replacements.entrySet()) {
            int first = (Integer)entry2.getKey().getFirst();
            int last = (Integer)entry2.getKey().getSecond();
            for (int i2 = currentWord; i2 < first; ++i2) {
                resultingWords.append(NameSuggester.calculateBetween(wordIndicies, i2, propertyName));
                String propertyWord = propertyWords[i2];
                NameSuggester.appendWord(resultingWords, propertyWord);
            }
            resultingWords.append(NameSuggester.calculateBetween(wordIndicies, first, propertyName));
            NameSuggester.appendWord(resultingWords, entry2.getValue());
            currentWord = last + 1;
        }
        while (currentWord < propertyWords.length) {
            resultingWords.append(NameSuggester.calculateBetween(wordIndicies, currentWord, propertyName));
            NameSuggester.appendWord(resultingWords, propertyWords[currentWord]);
            ++currentWord;
        }
        resultingWords.append(NameSuggester.calculateBetween(wordIndicies, propertyWords.length, propertyName));
        if (resultingWords.length() == 0) {
            return propertyName;
        }
        return NameSuggester.decapitalizeProbably(resultingWords.toString(), propertyName);
    }

    private static void appendWord(StringBuffer resultingWords, String propertyWord) {
        char lastChar;
        if (resultingWords.length() > 0 && Character.isLetterOrDigit(lastChar = resultingWords.charAt(resultingWords.length() - 1))) {
            propertyWord = StringUtil.capitalize((String)propertyWord);
        }
        resultingWords.append(propertyWord);
    }

    private static String calculateBetween(Pair<int[], int[]> wordIndicies, int i2, String propertyName) {
        int thisWordStart = ((int[])wordIndicies.getFirst())[i2];
        int prevWordEnd = ((int[])wordIndicies.getSecond())[i2];
        return propertyName.substring(prevWordEnd + 1, thisWordStart);
    }

    private TreeMap<Pair<Integer, Integer>, String> calculateReplacements(String[] propertyWords, TIntIntHashMap matches) {
        TreeMap<Pair<Integer, Integer>, String> replacements = new TreeMap<Pair<Integer, Integer>, String>(Pair.comparingByFirst());
        for (OriginalToNewChange change : this.myChanges) {
            String newString;
            int first = change.oldFirst;
            int last = change.oldLast;
            if (change.getOldLength() > 0) {
                if (!NameSuggester.containsAllBetween(matches, first, last)) continue;
                newString = change.getNewString();
                int propertyWordFirst = matches.get(first);
                if (first >= this.myOldClassName.length || last >= this.myOldClassName.length) {
                    LOG.error("old class name = " + this.myOldClassNameAsGiven + ", new class name = " + this.myNewClassNameAsGiven + ", propertyWords = " + Arrays.asList(propertyWords));
                }
                String replacement = NameSuggester.suggestReplacement(propertyWords[propertyWordFirst], newString);
                replacements.put((Pair<Integer, Integer>)Pair.create((Object)propertyWordFirst, (Object)matches.get(last)), replacement);
                continue;
            }
            newString = change.getNewString();
            int propertyWordToInsertBefore = matches.containsKey(first) ? matches.get(first) : (matches.contains(last) ? matches.get(last) + 1 : propertyWords.length);
            replacements.put((Pair<Integer, Integer>)Pair.create((Object)propertyWordToInsertBefore, (Object)(propertyWordToInsertBefore - 1)), newString);
        }
        return replacements;
    }

    private static String suggestReplacement(String propertyWord, @NotNull String newClassNameWords) {
        if (newClassNameWords == null) {
            NameSuggester.$$$reportNull$$$0(0);
        }
        return NameSuggester.decapitalizeProbably(newClassNameWords, propertyWord);
    }

    @NotNull
    private static String decapitalizeProbably(@NotNull String word, String originalWord) {
        if (word == null) {
            NameSuggester.$$$reportNull$$$0(1);
        }
        if (originalWord.length() == 0) {
            String string = word;
            if (string == null) {
                NameSuggester.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (Character.isLowerCase(originalWord.charAt(0))) {
            String string = StringUtil.decapitalize((String)word);
            if (string == null) {
                NameSuggester.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = word;
        if (string == null) {
            NameSuggester.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean containsAllBetween(TIntIntHashMap matches, int first, int last) {
        for (int i2 = first; i2 <= last; ++i2) {
            if (matches.containsKey(i2)) continue;
            return false;
        }
        return true;
    }

    private TIntIntHashMap calculateMatches(String[] propertyWords) {
        int classNameIndex = this.myOldClassName.length - 1;
        TIntIntHashMap matches = new TIntIntHashMap();
        for (int i2 = propertyWords.length - 1; i2 >= 0; --i2) {
            String propertyWord = propertyWords[i2];
            Match match = null;
            for (int j = classNameIndex; j >= 0 && match == null; --j) {
                match = this.checkMatch(j, i2, propertyWord);
            }
            if (match == null) continue;
            matches.put(match.oldClassNameIndex, i2);
            classNameIndex = match.oldClassNameIndex - 1;
        }
        return matches;
    }

    @Nullable
    private Match checkMatch(int oldClassNameIndex, int propertyNameIndex, String propertyWord) {
        if (propertyWord.equalsIgnoreCase(this.myOldClassName[oldClassNameIndex])) {
            return new Match(oldClassNameIndex, propertyNameIndex, propertyWord);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newClassNameWords";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/naming/NameSuggester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/naming/NameSuggester";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalizeProbably";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestReplacement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "decapitalizeProbably";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Match {
        final int oldClassNameIndex;
        final int propertyNameIndex;
        final String propertyWord;

        Match(int oldClassNameIndex, int propertyNameIndex, String propertyWord) {
            this.oldClassNameIndex = oldClassNameIndex;
            this.propertyNameIndex = propertyNameIndex;
            this.propertyWord = propertyWord;
        }
    }

    private class OriginalToNewChange {
        final int oldFirst;
        final int oldLast;
        final int newFirst;
        final int newLast;

        OriginalToNewChange(int firstInOld, int lastInOld, int firstInNew, int lastInNew) {
            this.oldFirst = firstInOld;
            this.oldLast = lastInOld;
            this.newFirst = firstInNew;
            this.newLast = lastInNew;
        }

        int getOldLength() {
            return this.oldLast - this.oldFirst + 1;
        }

        String getOldString() {
            StringBuilder buffer = new StringBuilder();
            for (int i2 = this.oldFirst; i2 <= this.oldLast; ++i2) {
                buffer.append(NameSuggester.this.myOldClassName[i2]);
            }
            return buffer.toString();
        }

        @NotNull
        String getNewString() {
            StringBuilder buffer = new StringBuilder();
            for (int i2 = this.newFirst; i2 <= this.newLast; ++i2) {
                buffer.append(NameSuggester.this.myNewClassName[i2]);
            }
            String string = buffer.toString();
            if (string == null) {
                OriginalToNewChange.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/naming/NameSuggester$OriginalToNewChange", "getNewString"));
        }
    }
}

