/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureComponent
extends EditorTextField {
    public MethodSignatureComponent(String signature, Project project, FileType filetype) {
        super(MethodSignatureComponent.createNonUndoableDocument(signature), project, filetype, true, false);
        this.setFont(EditorFontType.getGlobalPlainFont());
        this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR));
    }

    private static Document createNonUndoableDocument(String text2) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        UndoUtil.disableUndoFor((Document)document);
        return document;
    }

    public void setSignature(String signature) {
        this.setText(signature);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getScrollingModel().scrollVertically(0);
            editor.getScrollingModel().scrollHorizontally(0);
        }
    }

    @Override
    @NotNull
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        String fileName = this.getFileName();
        if (fileName != null) {
            editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getProject(), fileName));
        }
        editor.getSettings().setWhitespacesShown(false);
        editor.setHorizontalScrollbarVisible(true);
        editor.setVerticalScrollbarVisible(true);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            MethodSignatureComponent.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    @Nullable
    protected String getFileName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/MethodSignatureComponent", "createEditor"));
    }
}

