/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RefactoringUIUtil {
    public static final EditorSettingsProvider SELECT_ALL_ON_FOCUS = editor -> editor.addFocusListener(new FocusChangeListener(){

        @Override
        public void focusGained(@NotNull Editor editor) {
            if (editor == null) {
                1.$$$reportNull$$$0(0);
            }
            if (LookupManager.getActiveLookup(editor) == null) {
                editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/RefactoringUIUtil$1", "focusGained"));
        }
    });

    private RefactoringUIUtil() {
    }

    @Nls
    public static String getDescription(@NotNull PsiElement element2, boolean includeParent) {
        if (element2 == null) {
            RefactoringUIUtil.$$$reportNull$$$0(0);
        }
        RefactoringDescriptionLocation location = includeParent ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT;
        return ElementDescriptionUtil.getElementDescription((PsiElement)element2, (ElementDescriptionLocation)location);
    }

    public static void processIncorrectOperation(Project project, IncorrectOperationException e) {
        int index2;
        String message2 = e.getMessage();
        int n = index2 = message2 != null ? message2.indexOf("java.io.IOException") : -1;
        if (index2 > 0) {
            message2 = message2.substring(index2 + "java.io.IOException".length());
        }
        String s = message2;
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)s, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
    }

    @NotNull
    public static String calculatePsiElementDescriptionList(@NotNull @NotNull PsiElement @NotNull [] elements) {
        if (elements == null) {
            RefactoringUIUtil.$$$reportNull$$$0(1);
        }
        Function presentationFun = e -> UsageViewUtil.getType(e) + " " + DescriptiveNameUtil.getDescriptiveName((PsiElement)e);
        String string = StringUtil.join((Collection)ContainerUtil.map2LinkedSet(Arrays.asList(elements), (Function)presentationFun), (String)", ");
        if (string == null) {
            RefactoringUIUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/RefactoringUIUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/RefactoringUIUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePsiElementDescriptionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculatePsiElementDescriptionList";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

