/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.base.Joiner;
import com.intellij.remote.RemoteFile;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteProcessUtil {
    @Contract(value="null -> null")
    public static String toRemoteFileSystemStyle(@Nullable String path2) {
        if (path2 == null) {
            return null;
        }
        return RemoteFile.detectSystemByPath(path2).createRemoteFile(path2).getPath();
    }

    public static String[] buildRemoteCommand(@NotNull AbstractPathMapper pathMapper, @NotNull Collection<String> commands) {
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(0);
        }
        if (commands == null) {
            RemoteProcessUtil.$$$reportNull$$$0(1);
        }
        return ArrayUtilRt.toStringArray((Collection)pathMapper.convertToRemote(commands));
    }

    @NotNull
    public static String remapPathsList(@NotNull String pathsValue, @NotNull PathMapper pathMapper, @NotNull String interpreterPath) {
        if (pathsValue == null) {
            RemoteProcessUtil.$$$reportNull$$$0(2);
        }
        if (pathMapper == null) {
            RemoteProcessUtil.$$$reportNull$$$0(3);
        }
        if (interpreterPath == null) {
            RemoteProcessUtil.$$$reportNull$$$0(4);
        }
        boolean isWin = RemoteFile.isWindowsPath(interpreterPath);
        ArrayList<String> mappedPaths = new ArrayList<String>();
        for (String path2 : pathsValue.split(File.pathSeparator)) {
            mappedPaths.add(new RemoteFile(pathMapper.convertToRemote(path2), isWin).getPath());
        }
        String string = Joiner.on((char)(isWin ? (char)';' : ':')).join(mappedPaths);
        if (string == null) {
            RemoteProcessUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteProcessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteProcessUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "remapPathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildRemoteCommand";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remapPathsList";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

