/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.serialization.BaseBeanBinding;
import com.intellij.serialization.BeanBindingKt;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.BindingProducer;
import com.intellij.serialization.IonObjectSerializerKt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.NonDefaultConstructorInfo;
import com.intellij.serialization.ObjectIdReader;
import com.intellij.serialization.ObjectIdWriter;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.ReadError;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.WriteContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020 H\u0016JI\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010#\u001a\u00020$2%\b\u0002\u0010%\u001a\u001f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020$\u0018\u00010&H\u0002J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020,H\u0016R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/serialization/BeanBinding;", "Lcom/intellij/serialization/BaseBeanBinding;", "Lcom/intellij/serialization/Binding;", "beanClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "bindings", "", "[Lcom/intellij/serialization/Binding;", "nameToBindingIndex", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "", "properties", "", "Lcom/intellij/serialization/MutableAccessor;", "propertyMapping", "Lkotlin/Lazy;", "Lcom/intellij/serialization/NonDefaultConstructorInfo;", "createCacheKey", "aClass", "type", "Ljava/lang/reflect/Type;", "createUsingCustomConstructor", "", "context", "Lcom/intellij/serialization/ReadContext;", "hostObject", "deserialize", "getPropertyMappingIfDataClass", "init", "", "originalType", "Lcom/intellij/serialization/BindingInitializationContext;", "readIntoObject", "instance", "checkId", "", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "fieldName", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class BeanBinding
extends BaseBeanBinding
implements Binding {
    private Binding[] bindings;
    private Object2IntMap<String> nameToBindingIndex;
    private List<? extends MutableAccessor> properties;
    private final Lazy<NonDefaultConstructorInfo> propertyMapping;

    @Override
    @NotNull
    public Class<?> createCacheKey(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class<?> clazz = aClass;
        Intrinsics.checkNotNull(clazz);
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull Type originalType, @NotNull BindingInitializationContext context2) {
        Binding[] bindingArray;
        List list2;
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List list3 = context2.getPropertyCollector().collect(this.getBeanClass$intellij_platform_objectSerializer());
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"context.propertyCollector.collect(beanClass)");
        this.properties = list2 = list3;
        Object2IntOpenHashMap nameToBindingIndex = new Object2IntOpenHashMap(list2.size());
        nameToBindingIndex.defaultReturnValue(-1);
        int n = list2.size();
        BeanBinding beanBinding = this;
        Binding[] bindingArray2 = new Binding[n];
        int n2 = 0;
        while (n2 < n) {
            Binding binding;
            void index2;
            int n3 = n2;
            int n4 = n2++;
            bindingArray = bindingArray2;
            boolean bl = false;
            MutableAccessor accessor2 = (MutableAccessor)list2.get((int)index2);
            BindingProducer bindingProducer2 = context2.getBindingProducer();
            MutableAccessor mutableAccessor = accessor2;
            Intrinsics.checkNotNullExpressionValue((Object)mutableAccessor, (String)"accessor");
            Binding binding2 = bindingProducer2.getNestedBinding(mutableAccessor);
            nameToBindingIndex.put((Object)accessor2.getName(), (int)index2);
            bindingArray[n4] = binding = binding2;
        }
        bindingArray = bindingArray2;
        beanBinding.bindings = bindingArray;
        this.nameToBindingIndex = (Object2IntMap)nameToBindingIndex;
        if (context2.isResolveConstructorOnInit()) {
            try {
                this.resolveConstructor();
            }
            catch (NoSuchMethodException e) {
                this.propertyMapping.getValue();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context2) {
        int alreadySerializedReference;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IonWriter writer = context2.getWriter();
        ObjectIdWriter objectIdWriter = context2.getObjectIdWriter();
        if (objectIdWriter != null && (alreadySerializedReference = objectIdWriter.getId(obj2)) != -1) {
            writer.writeInt((long)alreadySerializedReference);
            return;
        }
        writer.stepIn(IonType.STRUCT);
        if (objectIdWriter != null) {
            writer.setFieldName("@id");
            writer.writeInt((long)objectIdWriter.registerObject(obj2));
        }
        if (this.bindings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
        }
        Binding[] bindings = this.bindings;
        List<? extends MutableAccessor> list2 = this.properties;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        List<? extends MutableAccessor> properties = list2;
        int n = 0;
        int n2 = bindings.length;
        while (n < n2) {
            void i2;
            MutableAccessor property2 = properties.get((int)i2);
            Binding binding = bindings[i2];
            try {
                binding.serialize(obj2, property2, context2);
            }
            catch (Exception e) {
                throw (Throwable)new SerializationException("Cannot serialize property (property=" + property2 + ", binding=" + binding + ", beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName() + ')', (Throwable)e);
            }
            ++i2;
        }
        writer.stepOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object createUsingCustomConstructor(ReadContext context2, Object hostObject) {
        void instance;
        Object object;
        Object constructorInfo = this.propertyMapping.getValue();
        if (constructorInfo == null) {
            Object object2 = context2.getConfiguration().getResolvePropertyMapping();
            if (object2 == null || (object2 = (NonDefaultConstructorInfo)object2.invoke(this.getBeanClass$intellij_platform_objectSerializer())) == null) {
                object2 = this.getPropertyMappingIfDataClass();
            }
            if (object2 == null) {
                throw (Throwable)new SerializationException("Please annotate non-default constructor with PropertyMapping (beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName() + ')');
            }
            constructorInfo = object2;
        }
        List<String> names2 = ((NonDefaultConstructorInfo)constructorInfo).getNames();
        Object[] initArgs = new Object[names2.size()];
        BufferExposingByteArrayOutputStream out = context2.allocateByteArrayOutputStream();
        Closeable closeable = (Closeable)IonObjectSerializerKt.getBinaryWriterBuilder().newWriter((OutputStream)out);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            IonWriter it322 = (IonWriter)closeable;
            boolean bl3 = false;
            it322.writeValue(context2.getReader());
            it322 = Unit.INSTANCE;
        }
        catch (Throwable it322) {
            throwable = it322;
            throw it322;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int id2 = -1;
        Closeable closeable2 = (Closeable)BeanBindingKt.access$getStructReaderBuilder$p().build(out.getInternalBuffer(), 0, out.size());
        boolean bl4 = false;
        boolean it322 = false;
        Throwable it322 = null;
        try {
            IonReader reader = (IonReader)closeable2;
            boolean bl5 = false;
            reader.next();
            IonReader ionReader = reader;
            Intrinsics.checkNotNullExpressionValue((Object)ionReader, (String)"reader");
            ReadContext subReadContext = context2.createSubContext(ionReader);
            IonReader reader$iv = reader;
            boolean $i$f$readStruct = false;
            reader$iv.stepIn();
            while (reader$iv.next() != null) {
                int bindingIndex;
                void type;
                IonType type$iv;
                String fieldName$iv = reader$iv.getFieldName();
                if (fieldName$iv == null) {
                    throw (Throwable)new IllegalStateException("No valid current value or the current value is not a field of a struct.");
                }
                IonType ionType = type$iv;
                String fieldName = fieldName$iv;
                boolean bl6 = false;
                if (type == IonType.NULL) continue;
                if (type == IonType.INT && Intrinsics.areEqual((Object)fieldName, (Object)"@id")) {
                    id2 = reader.intValue();
                    continue;
                }
                int argIndex = names2.indexOf(fieldName);
                if (argIndex == -1) continue;
                Object2IntMap<String> object2IntMap = this.nameToBindingIndex;
                if (object2IntMap == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nameToBindingIndex");
                }
                if ((bindingIndex = object2IntMap.getInt((Object)fieldName)) == -1) {
                    ObjectSerializerKt.getLOG().error("Cannot find binding (fieldName=" + fieldName + ", valueType=" + reader.getType() + ", beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName());
                    continue;
                }
                if (this.bindings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
                }
                Binding binding = this.bindings[bindingIndex];
                try {
                    initArgs[argIndex] = binding.deserialize(subReadContext, hostObject);
                }
                catch (Exception e) {
                    throw (Throwable)new SerializationException("Cannot deserialize parameter value (fieldName=" + fieldName + ", binding=" + binding + ", valueType=" + reader.getType() + ", beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName() + ')', (Throwable)e);
                }
            }
            reader$iv.stepOut();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            it322 = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)it322);
        }
        Closeable closeable3 = closeable2 = new Ref.ObjectRef();
        try {
            Closeable closeable4 = closeable3;
            object = ((NonDefaultConstructorInfo)constructorInfo).getConstructor().newInstance(Arrays.copyOf(initArgs, initArgs.length));
        }
        catch (Exception it322) {
            void e;
            Closeable closeable5 = closeable3;
            throw (Throwable)new SerializationException("Cannot create instance (beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName() + ", initArgs=" + ArraysKt.joinToString$default((Object[])initArgs, null, null, null, (int)0, null, null, (int)63, null) + ')', (Throwable)e);
        }
        ((Ref.ObjectRef)closeable4).element = object;
        Function1<Object, Object> function1 = context2.getConfiguration().getBeanConstructed();
        if (function1 != null) {
            object = function1;
            boolean bl7 = false;
            boolean bl8 = false;
            Object it = object;
            boolean bl9 = false;
            Object object3 = instance.element;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"instance");
            instance.element = it.invoke(object3);
        }
        if (id2 != -1) {
            ObjectIdReader objectIdReader = context2.getObjectIdReader();
            Object object4 = instance.element;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"instance");
            objectIdReader.registerObject(object4, id2);
        }
        if (this.bindings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
        }
        if (this.bindings.length > names2.size()) {
            object = (Closeable)BeanBindingKt.access$getStructReaderBuilder$p().build(out.getInternalBuffer(), 0, out.size());
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable3 = null;
            try {
                IonReader reader = (IonReader)object;
                boolean bl12 = false;
                reader.next();
                Object object5 = instance.element;
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"instance");
                IonReader ionReader = reader;
                Intrinsics.checkNotNullExpressionValue((Object)ionReader, (String)"reader");
                this.readIntoObject(object5, context2.createSubContext(ionReader), false, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this, (Ref.ObjectRef)instance, context2, names2){
                    final /* synthetic */ BeanBinding this$0;
                    final /* synthetic */ Ref.ObjectRef $instance$inlined;
                    final /* synthetic */ ReadContext $context$inlined;
                    final /* synthetic */ List $names$inlined;
                    {
                        this.this$0 = beanBinding;
                        this.$instance$inlined = objectRef;
                        this.$context$inlined = readContext;
                        this.$names$inlined = list2;
                        super(1);
                    }

                    public final boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !this.$names$inlined.contains(it);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(object, (Throwable)throwable3);
            }
        }
        Object object6 = instance.element;
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"instance");
        return object6;
    }

    /*
     * WARNING - void declaration
     */
    private final NonDefaultConstructorInfo getPropertyMappingIfDataClass() {
        try {
            void $this$mapNotNullTo$iv$iv;
            KFunction kFunction = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(this.getBeanClass$intellij_platform_objectSerializer()));
            if (kFunction == null) {
                return null;
            }
            KFunction kFunction2 = kFunction;
            try {
                KCallablesJvm.setAccessible((KCallable)((KCallable)kFunction2), (boolean)true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Iterable $this$mapNotNull$iv = kFunction2.getParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KParameter it = (KParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List names2 = (List)destination$iv$iv;
            if (names2.isEmpty()) {
                return null;
            }
            Constructor constructor = ReflectJvmMapping.getJavaConstructor((KFunction)kFunction2);
            Intrinsics.checkNotNull((Object)constructor);
            return new NonDefaultConstructorInfo(names2, constructor);
        }
        catch (Exception e) {
            ObjectSerializerKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context2, @Nullable Object hostObject) {
        Object object;
        block11: {
            Object instance;
            block10: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                IonReader reader = context2.getReader();
                IonType ionType = reader.getType();
                if (ionType == IonType.INT) {
                    return context2.getObjectIdReader().getObject(reader.intValue());
                }
                if (ionType != IonType.STRUCT) {
                    String stringValue = "";
                    if (ionType == IonType.SYMBOL || ionType == IonType.STRING) {
                        String string = reader.stringValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.stringValue()");
                        stringValue = string;
                    }
                    throw (Throwable)new SerializationException("Expected STRUCT, but got " + ionType + " (stringValue=" + stringValue + ')');
                }
                if (this.propertyMapping.isInitialized()) {
                    return this.createUsingCustomConstructor(context2, hostObject);
                }
                try {
                    object2 = this.resolveConstructor().newInstance(new Object[0]);
                }
                catch (SecurityException e) {
                    object2 = this.getBeanClass$intellij_platform_objectSerializer().newInstance();
                }
                catch (NoSuchMethodException e) {
                    return this.createUsingCustomConstructor(context2, hostObject);
                }
                Object obj2 = instance = object2;
                Intrinsics.checkNotNullExpressionValue(obj2, (String)"instance");
                BeanBinding.readIntoObject$default(this, obj2, context2, false, null, 12, null);
                object = context2.getConfiguration().getBeanConstructed();
                if (object == null) break block10;
                object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = it.invoke(instance);
                if (object != null) break block11;
            }
            object = instance;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void readIntoObject(Object instance, ReadContext context2, boolean checkId, Function1<? super String, Boolean> filter) {
        Object2IntMap<String> object2IntMap = this.nameToBindingIndex;
        if (object2IntMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameToBindingIndex");
        }
        Object2IntMap<String> nameToBindingIndex = object2IntMap;
        if (this.bindings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
        }
        Binding[] bindings = this.bindings;
        List<? extends MutableAccessor> list2 = this.properties;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        List<? extends MutableAccessor> accessors = list2;
        IonReader reader = context2.getReader();
        boolean $i$f$readStruct = false;
        reader.stepIn();
        while (reader.next() != null) {
            void type;
            IonType type$iv;
            String fieldName$iv = reader.getFieldName();
            if (fieldName$iv == null) {
                throw (Throwable)new IllegalStateException("No valid current value or the current value is not a field of a struct.");
            }
            IonType ionType = type$iv;
            String fieldName = fieldName$iv;
            boolean bl = false;
            if (type == IonType.INT && Intrinsics.areEqual((Object)fieldName, (Object)"@id")) {
                if (!checkId) continue;
                int id2 = reader.intValue();
                context2.getObjectIdReader().registerObject(instance, id2);
                continue;
            }
            if (filter != null && !((Boolean)filter.invoke((Object)fieldName)).booleanValue()) continue;
            int bindingIndex = nameToBindingIndex.getInt((Object)fieldName);
            if (bindingIndex == -1) {
                context2.getErrors().getUnknownFields().add(new ReadError("Unknown field (fieldName=" + fieldName + ", beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName() + ')', null, 2, null));
                continue;
            }
            Binding binding = bindings[bindingIndex];
            try {
                binding.deserialize(instance, accessors.get(bindingIndex), context2);
            }
            catch (SerializationException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                throw (Throwable)new SerializationException("Cannot deserialize field value (field=" + fieldName + ", binding=" + binding + ", valueType=" + reader.getType() + ", beanClass=" + this.getBeanClass$intellij_platform_objectSerializer().getName() + ')', (Throwable)e);
            }
        }
        reader.stepOut();
    }

    static /* synthetic */ void readIntoObject$default(BeanBinding beanBinding, Object object, ReadContext readContext, boolean bl, Function1 function1, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        beanBinding.readIntoObject(object, readContext, bl, (Function1<? super String, Boolean>)function1);
    }

    public BeanBinding(@NotNull Class<?> beanClass) {
        Intrinsics.checkNotNullParameter(beanClass, (String)"beanClass");
        super(beanClass);
        this.propertyMapping = LazyKt.lazy((Function0)((Function0)new Function0<NonDefaultConstructorInfo>(beanClass){
            final /* synthetic */ Class $beanClass;

            @Nullable
            public final NonDefaultConstructorInfo invoke() {
                return BeanBindingKt.access$computeNonDefaultConstructorInfo(this.$beanClass);
            }
            {
                this.$beanClass = clazz;
                super(0);
            }
        }));
    }

    @Override
    public void serialize(@NotNull Object hostObject, @NotNull MutableAccessor property2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Binding.DefaultImpls.serialize(this, hostObject, property2, context2);
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property2, @NotNull ReadContext context2) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Binding.DefaultImpls.deserialize(this, hostObject, property2, context2);
    }
}

