/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.util.SPFileUtil;
import com.intellij.util.Consumer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="SpellCheckerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class SpellCheckerSettings
implements PersistentStateComponent<Element> {
    private static final String SPELLCHECKER_MANAGER_SETTINGS_TAG = "SpellCheckerSettings";
    private static final String FOLDERS_ATTR_NAME = "Folders";
    private static final String FOLDER_ATTR_NAME = "Folder";
    private static final String CUSTOM_DICTIONARIES_ATTR_NAME = "CustomDictionaries";
    private static final String CUSTOM_DICTIONARY_ATTR_NAME = "CustomDictionary";
    private static final String RUNTIME_DICTIONARIES_ATTR_NAME = "RuntimeDictionaries";
    private static final String RUNTIME_DICTIONARY_ATTR_NAME = "RuntimeDictionary";
    private static final String DICTIONARY_TO_SAVE_ATTR_NAME = "DefaultDictionary";
    private static final String DEFAULT_DICTIONARY_TO_SAVE = SpellCheckerManager.DictionaryLevel.PROJECT.getName();
    private static final String USE_SINGLE_DICT_ATTR_NAME = "UseSingleDictionary";
    private static final boolean DEFAULT_USE_SINGLE_DICT = true;
    private static final String SETTINGS_TRANSFERRED = "transferred";
    private final List<String> myOldDictionaryFoldersPaths = new ArrayList<String>();
    private List<String> myCustomDictionariesPaths = new ArrayList<String>();
    private Set<String> myRuntimeDisabledDictionariesNames = new HashSet<String>();
    private String myDictionaryToSave = DEFAULT_DICTIONARY_TO_SAVE;
    private boolean myUseSingleDictionaryToSave = true;
    private boolean mySettingsTransferred;

    @NlsSafe
    public String getDictionaryToSave() {
        return this.myDictionaryToSave;
    }

    public void setDictionaryToSave(String dictionaryToSave) {
        this.myDictionaryToSave = dictionaryToSave;
    }

    public boolean isUseSingleDictionaryToSave() {
        return this.myUseSingleDictionaryToSave;
    }

    public void setUseSingleDictionaryToSave(boolean useSingleDictionaryToSave) {
        this.myUseSingleDictionaryToSave = useSingleDictionaryToSave;
    }

    public boolean isSettingsTransferred() {
        return this.mySettingsTransferred;
    }

    public void setSettingsTransferred(boolean settingsTransferred) {
        this.mySettingsTransferred = settingsTransferred;
    }

    @NotNull
    public static SpellCheckerSettings getInstance(Project project) {
        SpellCheckerSettings spellCheckerSettings = (SpellCheckerSettings)project.getService(SpellCheckerSettings.class);
        if (spellCheckerSettings == null) {
            SpellCheckerSettings.$$$reportNull$$$0(0);
        }
        return spellCheckerSettings;
    }

    public List<String> getCustomDictionariesPaths() {
        return this.myCustomDictionariesPaths;
    }

    public void setCustomDictionariesPaths(List<String> customDictionariesPaths) {
        this.myCustomDictionariesPaths = customDictionariesPaths;
    }

    public Set<String> getRuntimeDisabledDictionariesNames() {
        return this.myRuntimeDisabledDictionariesNames;
    }

    public void setRuntimeDisabledDictionariesNames(Set<String> runtimeDisabledDictionariesNames) {
        this.myRuntimeDisabledDictionariesNames = runtimeDisabledDictionariesNames;
    }

    public boolean isDefaultAdvancedSettings() {
        return this.myUseSingleDictionaryToSave && this.myDictionaryToSave == DEFAULT_DICTIONARY_TO_SAVE;
    }

    public Element getState() {
        int j;
        if (this.myRuntimeDisabledDictionariesNames.isEmpty() && this.myOldDictionaryFoldersPaths.isEmpty() && this.myCustomDictionariesPaths.isEmpty() && this.myUseSingleDictionaryToSave && this.myDictionaryToSave.equals(DEFAULT_DICTIONARY_TO_SAVE) && !this.mySettingsTransferred) {
            return null;
        }
        Element element2 = new Element(SPELLCHECKER_MANAGER_SETTINGS_TAG);
        element2.setAttribute(RUNTIME_DICTIONARIES_ATTR_NAME, String.valueOf(this.myRuntimeDisabledDictionariesNames.size()));
        Iterator<String> iterator2 = this.myRuntimeDisabledDictionariesNames.iterator();
        int i2 = 0;
        while (iterator2.hasNext()) {
            element2.setAttribute(RUNTIME_DICTIONARY_ATTR_NAME + i2, iterator2.next());
            ++i2;
        }
        element2.setAttribute(FOLDERS_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element2.setAttribute(FOLDER_ATTR_NAME + j, Paths.get(this.myCustomDictionariesPaths.get(j), new String[0]).getParent().toString());
        }
        element2.setAttribute(CUSTOM_DICTIONARIES_ATTR_NAME, String.valueOf(this.myCustomDictionariesPaths.size()));
        for (j = 0; j < this.myCustomDictionariesPaths.size(); ++j) {
            element2.setAttribute(CUSTOM_DICTIONARY_ATTR_NAME + j, this.myCustomDictionariesPaths.get(j));
        }
        element2.setAttribute(DICTIONARY_TO_SAVE_ATTR_NAME, this.myDictionaryToSave);
        element2.setAttribute(USE_SINGLE_DICT_ATTR_NAME, String.valueOf(this.myUseSingleDictionaryToSave));
        element2.setAttribute(SETTINGS_TRANSFERRED, String.valueOf(this.mySettingsTransferred));
        return element2;
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            SpellCheckerSettings.$$$reportNull$$$0(1);
        }
        this.myRuntimeDisabledDictionariesNames.clear();
        this.myCustomDictionariesPaths.clear();
        this.myOldDictionaryFoldersPaths.clear();
        try {
            int i2;
            int runtimeDictionariesSize = StringUtil.parseInt((String)element2.getAttributeValue(RUNTIME_DICTIONARIES_ATTR_NAME), (int)0);
            for (int i3 = 0; i3 < runtimeDictionariesSize; ++i3) {
                this.myRuntimeDisabledDictionariesNames.add(element2.getAttributeValue(RUNTIME_DICTIONARY_ATTR_NAME + i3));
            }
            if (element2.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME) == null) {
                int foldersSize = StringUtil.parseInt((String)element2.getAttributeValue(FOLDERS_ATTR_NAME), (int)0);
                for (i2 = 0; i2 < foldersSize; ++i2) {
                    this.myOldDictionaryFoldersPaths.add(element2.getAttributeValue(FOLDER_ATTR_NAME + i2));
                }
                this.myOldDictionaryFoldersPaths.forEach(folder -> SPFileUtil.processFilesRecursively(folder, (Consumer<? super String>)((Consumer)file2 -> {
                    if (FileUtilRt.extensionEquals((String)file2, (String)"dic")) {
                        this.myCustomDictionariesPaths.add((String)file2);
                    }
                })));
            }
            int customDictSize = StringUtil.parseInt((String)element2.getAttributeValue(CUSTOM_DICTIONARIES_ATTR_NAME), (int)0);
            for (i2 = 0; i2 < customDictSize; ++i2) {
                this.myCustomDictionariesPaths.add(element2.getAttributeValue(CUSTOM_DICTIONARY_ATTR_NAME + i2));
            }
            this.myDictionaryToSave = StringUtil.notNullize((String)element2.getAttributeValue(DICTIONARY_TO_SAVE_ATTR_NAME), (String)DEFAULT_DICTIONARY_TO_SAVE);
            this.myUseSingleDictionaryToSave = Boolean.parseBoolean(StringUtil.notNullize((String)element2.getAttributeValue(USE_SINGLE_DICT_ATTR_NAME), (String)String.valueOf(true)));
            this.mySettingsTransferred = Boolean.parseBoolean(StringUtil.notNullize((String)element2.getAttributeValue(SETTINGS_TRANSFERRED), (String)"false"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/settings/SpellCheckerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/settings/SpellCheckerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

