/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class PsiIdentifierOwnerTokenizer
extends Tokenizer<PsiNameIdentifierOwner> {
    public static final PsiIdentifierOwnerTokenizer INSTANCE = new PsiIdentifierOwnerTokenizer();

    @Override
    public void tokenize(@NotNull PsiNameIdentifierOwner element2, TokenConsumer consumer) {
        PsiElement identifier;
        if (element2 == null) {
            PsiIdentifierOwnerTokenizer.$$$reportNull$$$0(0);
        }
        if ((identifier = element2.getNameIdentifier()) == null) {
            return;
        }
        PsiNameIdentifierOwner parent = element2;
        TextRange range2 = identifier.getTextRange();
        if (range2.isEmpty()) {
            return;
        }
        int offset = range2.getStartOffset() - parent.getTextRange().getStartOffset();
        if (offset < 0) {
            parent = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element2);
            offset = range2.getStartOffset() - parent.getTextRange().getStartOffset();
        }
        String text2 = identifier.getText();
        consumer.consumeToken((PsiElement)parent, text2, true, offset, TextRange.allOf((String)text2), IdentifierSplitter.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/PsiIdentifierOwnerTokenizer", "tokenize"));
    }
}

