/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scopes {
    private Scopes() {
    }

    public static Type getType(@Nullable SearchScope scope2) {
        if (scope2 instanceof ProjectScopeImpl || scope2 == null) {
            return Type.PROJECT;
        }
        if (scope2 instanceof ModuleWithDependenciesScope) {
            return Type.MODULE;
        }
        if (scope2 instanceof GlobalSearchScopesCore.DirectoryScope) {
            return Type.DIRECTORY;
        }
        return Type.NAMED;
    }

    public static String getDescriptor(SearchScope scope2) {
        if (scope2 instanceof ProjectScopeImpl || scope2 == null) {
            return "";
        }
        if (scope2 instanceof ModuleWithDependenciesScope) {
            return ((ModuleWithDependenciesScope)scope2).getModule().getName();
        }
        if (scope2 instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope2;
            String url = directoryScope.getDirectory().getPresentableUrl();
            return directoryScope.isWithSubdirectories() ? "*" + url : url;
        }
        return scope2.getDisplayName();
    }

    public static SearchScope createScope(@NotNull Project project, @NotNull String descriptor2, @NotNull Type scopeType2) {
        if (project == null) {
            Scopes.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            Scopes.$$$reportNull$$$0(1);
        }
        if (scopeType2 == null) {
            Scopes.$$$reportNull$$$0(2);
        }
        if (scopeType2 == Type.PROJECT) {
            return GlobalSearchScope.projectScope((Project)project);
        }
        if (scopeType2 == Type.MODULE) {
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(descriptor2);
            if (module != null) {
                return GlobalSearchScope.moduleScope((Module)module);
            }
        } else {
            if (scopeType2 == Type.DIRECTORY) {
                boolean recursive = StringUtil.startsWithChar((CharSequence)descriptor2, (char)'*');
                if (recursive) {
                    descriptor2 = descriptor2.substring(1);
                }
                String path2 = FileUtil.toSystemIndependentName((String)descriptor2.substring(1));
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path2);
                if (virtualFile2 == null) {
                    return null;
                }
                return new GlobalSearchScopesCore.DirectoryScope(project, virtualFile2, recursive);
            }
            if (scopeType2 == Type.NAMED) {
                return Scopes.findScopeByName(project, descriptor2);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static SearchScope findScopeByName(@NotNull Project project, @NotNull String scopeName) {
        if (project == null) {
            Scopes.$$$reportNull$$$0(3);
        }
        if (scopeName == null) {
            Scopes.$$$reportNull$$$0(4);
        }
        List<SearchScope> predefinedScopes = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, true, false, true, true, true);
        for (SearchScope predefinedScope : predefinedScopes) {
            if (!predefinedScope.getDisplayName().equals(scopeName)) continue;
            return predefinedScope;
        }
        for (FindInProjectExtension extension2 : FindInProjectExtension.EP_NAME.getExtensionList()) {
            for (NamedScope namedScope : extension2.getFilteredNamedScopes(project)) {
                if (!namedScope.getScopeId().equals(scopeName)) continue;
                return GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope);
            }
        }
        for (Iterator<Object> iterator2 : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            for (NamedScope scope3 : iterator2.getEditableScopes()) {
                if (!scope3.getScopeId().equals(scopeName)) continue;
                return GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope3);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/Scopes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findScopeByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        PROJECT,
        MODULE,
        DIRECTORY,
        NAMED;

    }
}

