/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.DeleteNodesAction;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ContainsPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReferencePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.impl.matcher.predicates.WithinPredicate;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PatternCompiler {
    private static String ourLastSearchPlan;

    public static CompiledPattern compilePattern(Project project, MatchOptions options2, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        return (CompiledPattern)ReadAction.compute(() -> PatternCompiler.doCompilePattern(project, options2, checkForErrors, optimizeScope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CompiledPattern doCompilePattern(@NotNull Project project, @NotNull MatchOptions options2, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        StructuralSearchProfile profile;
        if (project == null) {
            PatternCompiler.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            PatternCompiler.$$$reportNull$$$0(1);
        }
        if ((profile = StructuralSearchUtil.getProfileByFileType(options2.getFileType())) == null) {
            return null;
        }
        CompiledPattern result2 = profile.createCompiledPattern();
        String[] prefixes = result2.getTypedVarPrefixes();
        assert (prefixes.length > 0);
        CompileContext context2 = new CompileContext(result2, options2, project);
        try {
            List<PsiElement> elements = PatternCompiler.compileByAllPrefixes(project, options2, result2, context2, prefixes, checkForErrors);
            if (elements.isEmpty()) {
                CompiledPattern compiledPattern = null;
                return compiledPattern;
            }
            CompiledPattern pattern = context2.getPattern();
            PatternCompiler.collectVariableNodes(pattern, elements, checkForErrors);
            pattern.setNodes(elements);
            if (checkForErrors) {
                profile.checkSearchPattern(pattern);
            }
            if (optimizeScope) {
                PatternCompiler.optimizeScope(options2, checkForErrors, context2, result2);
            }
            CompiledPattern compiledPattern = result2;
            return compiledPattern;
        }
        finally {
            context2.clear();
        }
    }

    private static void optimizeScope(MatchOptions options2, boolean checkForErrors, CompileContext context2, CompiledPattern result2) throws NoMatchFoundException {
        OptimizingSearchHelper searchHelper = context2.getSearchHelper();
        if (searchHelper.doOptimizing() && searchHelper.isScannedSomething()) {
            Set<VirtualFile> filesToScan = searchHelper.getFilesSetToScan();
            GlobalSearchScope scope2 = (GlobalSearchScope)options2.getScope();
            assert (scope2 != null);
            if (checkForErrors && filesToScan.isEmpty()) {
                throw new NoMatchFoundException(SSRBundle.message("ssr.will.not.find.anything", scope2.getDisplayName()));
            }
            result2.setScope((SearchScope)(scope2.isSearchInLibraries() ? GlobalSearchScope.filesWithLibrariesScope((Project)context2.getProject(), filesToScan) : GlobalSearchScope.filesWithoutLibrariesScope((Project)context2.getProject(), filesToScan)));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourLastSearchPlan = ((TestModeOptimizingSearchHelper)searchHelper).getSearchPlan();
        }
    }

    private static void collectVariableNodes(final CompiledPattern pattern, List<? extends PsiElement> elements, boolean checkForErrors) throws MalformedPatternException {
        for (PsiElement psiElement : elements) {
            pattern.putVariableNode("__context__", psiElement);
            if (checkForErrors) {
                PatternCompiler.checkForUnknownVariables(pattern, psiElement);
            }
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.collectNode(element2, element2.getUserData(CompiledPattern.HANDLER_KEY));
                    super.visitElement(element2);
                    if (element2 instanceof LeafElement) {
                        this.collectNode(element2, pattern.getHandler(pattern.getTypedVarString(element2)));
                    }
                }

                private void collectNode(PsiElement element2, Object handler2) {
                    if (handler2 instanceof DelegatingHandler) {
                        handler2 = ((DelegatingHandler)handler2).getDelegate();
                    }
                    if (handler2 instanceof SubstitutionHandler) {
                        pattern.putVariableNode(((SubstitutionHandler)handler2).getName(), element2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$1", "visitElement"));
                }
            });
        }
    }

    private static void checkForUnknownVariables(final CompiledPattern pattern, PsiElement element2) {
        element2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element2.getUserData(CompiledPattern.HANDLER_KEY) != null) {
                    return;
                }
                super.visitElement(element2);
                if (!(element2 instanceof LeafElement)) {
                    return;
                }
                String text2 = element2.getText();
                if (!pattern.isTypedVar(text2)) {
                    for (String prefix2 : pattern.getTypedVarPrefixes()) {
                        if (!text2.contains(prefix2)) continue;
                        throw new MalformedPatternException();
                    }
                    return;
                }
                MatchingHandler handler2 = pattern.getHandler(pattern.getTypedVarString(element2));
                if (handler2 == null) {
                    throw new MalformedPatternException();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$2", "visitElement"));
            }
        });
    }

    @TestOnly
    public static String getLastSearchPlan() {
        return ourLastSearchPlan;
    }

    @NotNull
    private static List<PsiElement> compileByAllPrefixes(@NotNull Project project, @NotNull MatchOptions options2, @NotNull CompiledPattern pattern, @NotNull CompileContext context2, String @NotNull [] applicablePrefixes, boolean checkForErrors) throws MalformedPatternException {
        if (project == null) {
            PatternCompiler.$$$reportNull$$$0(2);
        }
        if (options2 == null) {
            PatternCompiler.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            PatternCompiler.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            PatternCompiler.$$$reportNull$$$0(5);
        }
        if (applicablePrefixes == null) {
            PatternCompiler.$$$reportNull$$$0(6);
        }
        if (applicablePrefixes.length == 0) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PatternCompiler.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<PsiElement> elements = PatternCompiler.doCompile(project, options2, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context2, checkForErrors);
        if (elements.isEmpty()) {
            List<PsiElement> list3 = elements;
            if (list3 == null) {
                PatternCompiler.$$$reportNull$$$0(8);
            }
            return list3;
        }
        PsiFile file2 = elements.get(0).getContainingFile();
        if (file2 == null) {
            List<PsiElement> list4 = elements;
            if (list4 == null) {
                PatternCompiler.$$$reportNull$$$0(9);
            }
            return list4;
        }
        PsiElement last = elements.get(elements.size() - 1);
        Pattern[] patterns = new Pattern[applicablePrefixes.length];
        for (int i2 = 0; i2 < applicablePrefixes.length; ++i2) {
            patterns[i2] = Pattern.compile(StructuralSearchUtil.shieldRegExpMetaChars(applicablePrefixes[i2]) + "\\w+\\b");
        }
        int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file2, patterns);
        int patternEndOffset = last.getTextRange().getEndOffset();
        if (elements.isEmpty() || PatternCompiler.checkErrorElements((PsiElement)file2, patternEndOffset, patternEndOffset, varEndOffsets, true) != Boolean.TRUE) {
            List<PsiElement> list5 = elements;
            if (list5 == null) {
                PatternCompiler.$$$reportNull$$$0(10);
            }
            return list5;
        }
        int varCount = varEndOffsets.length;
        String[] prefixSequence = new String[varCount];
        for (int i3 = 0; i3 < varCount; ++i3) {
            prefixSequence[i3] = applicablePrefixes[0];
        }
        List<PsiElement> finalElements = PatternCompiler.compileByPrefixes(project, options2, pattern, context2, applicablePrefixes, patterns, prefixSequence, 0, checkForErrors);
        return finalElements != null ? finalElements : PatternCompiler.doCompile(project, options2, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context2, checkForErrors);
    }

    @Nullable
    private static List<PsiElement> compileByPrefixes(Project project, MatchOptions options2, CompiledPattern pattern, CompileContext context2, String[] applicablePrefixes, Pattern[] substitutionPatterns, String[] prefixSequence, int index2, boolean checkForErrors) throws MalformedPatternException {
        if (index2 >= prefixSequence.length) {
            List<PsiElement> elements = PatternCompiler.doCompile(project, options2, pattern, new ArrayPrefixProvider(prefixSequence), context2, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiElement parent = elements.get(0).getParent();
            PsiElement last = elements.get(elements.size() - 1);
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(parent.getContainingFile(), substitutionPatterns);
            int patternEndOffset = last.getTextRange().getEndOffset();
            return PatternCompiler.checkErrorElements(parent, patternEndOffset, patternEndOffset, varEndOffsets, false) != Boolean.TRUE ? elements : null;
        }
        String[] alternativeVariant = null;
        String[] stringArray = applicablePrefixes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            List<PsiElement> finalElements;
            int patternEndOffset;
            String applicablePrefix;
            prefixSequence[index2] = applicablePrefix = stringArray[j];
            List<PsiElement> elements = PatternCompiler.doCompile(project, options2, pattern, new ArrayPrefixProvider(prefixSequence), context2, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiFile file2 = elements.get(0).getContainingFile();
            if (file2 == null) {
                return elements;
            }
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file2, substitutionPatterns);
            int offset = varEndOffsets[index2];
            Boolean result2 = PatternCompiler.checkErrorElements((PsiElement)file2, offset, patternEndOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset(), varEndOffsets, false);
            if (result2 == Boolean.TRUE || result2 != Boolean.FALSE && (result2 != null || alternativeVariant != null) || (finalElements = PatternCompiler.compileByPrefixes(project, options2, pattern, context2, applicablePrefixes, substitutionPatterns, prefixSequence, index2 + 1, checkForErrors)) == null) continue;
            if (result2 == Boolean.FALSE) {
                return finalElements;
            }
            alternativeVariant = (String[])prefixSequence.clone();
        }
        return alternativeVariant != null ? PatternCompiler.compileByPrefixes(project, options2, pattern, context2, applicablePrefixes, substitutionPatterns, alternativeVariant, index2 + 1, checkForErrors) : null;
    }

    private static int @NotNull [] findAllTypedVarOffsets(PsiFile file2, final Pattern[] substitutionPatterns) {
        IntOpenHashSet result2 = new IntOpenHashSet();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((IntSet)result2){
            final /* synthetic */ IntSet val$result;
            {
                this.val$result = intSet;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitElement(element2);
                if (element2 instanceof LeafElement) {
                    String text2 = element2.getText();
                    for (Pattern pattern : substitutionPatterns) {
                        Matcher matcher = pattern.matcher(text2);
                        while (matcher.find()) {
                            this.val$result.add(element2.getTextRange().getStartOffset() + matcher.end());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$3", "visitElement"));
            }
        });
        int[] resultArray = result2.toIntArray();
        Arrays.sort(resultArray);
        if (resultArray == null) {
            PatternCompiler.$$$reportNull$$$0(11);
        }
        return resultArray;
    }

    @Nullable
    private static Boolean checkErrorElements(PsiElement element2, int offset, int patternEndOffset, int[] varEndOffsets, final boolean strict) {
        IntArrayList errorOffsets = new IntArrayList();
        boolean[] containsErrorTail = new boolean[]{false};
        IntOpenHashSet varEndOffsetsSet = new IntOpenHashSet(varEndOffsets);
        element2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((IntSet)varEndOffsetsSet, patternEndOffset, (IntList)errorOffsets, offset, containsErrorTail){
            final /* synthetic */ IntSet val$varEndOffsetsSet;
            final /* synthetic */ int val$patternEndOffset;
            final /* synthetic */ IntList val$errorOffsets;
            final /* synthetic */ int val$offset;
            final /* synthetic */ boolean[] val$containsErrorTail;
            {
                this.val$varEndOffsetsSet = intSet;
                this.val$patternEndOffset = n;
                this.val$errorOffsets = intList;
                this.val$offset = n2;
                this.val$containsErrorTail = blArray;
            }

            public void visitErrorElement(@NotNull PsiErrorElement element2) {
                if (element2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.visitErrorElement(element2);
                int startOffset = element2.getTextRange().getStartOffset();
                if ((strict || !this.val$varEndOffsetsSet.contains(startOffset)) && startOffset != this.val$patternEndOffset) {
                    this.val$errorOffsets.add(startOffset);
                }
                if (startOffset == this.val$offset) {
                    this.val$containsErrorTail[0] = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$4", "visitErrorElement"));
            }
        });
        for (int i2 = 0; i2 < errorOffsets.size(); ++i2) {
            int errorOffset = errorOffsets.getInt(i2);
            if (errorOffset > offset) continue;
            return true;
        }
        return containsErrorTail[0] ? null : Boolean.valueOf(false);
    }

    @NotNull
    private static List<PsiElement> doCompile(@NotNull Project project, @NotNull MatchOptions options2, @NotNull CompiledPattern result2, @NotNull PrefixProvider prefixProvider, @NotNull CompileContext context2, boolean checkForErrors) throws MalformedPatternException {
        GlobalCompilingVisitor compilingVisitor;
        SmartList elements;
        block41: {
            String patternElements;
            MatchVariableConstraint constraint;
            LanguageFileType fileType;
            int prevOffset;
            String text2;
            StringBuilder buf;
            block40: {
                if (project == null) {
                    PatternCompiler.$$$reportNull$$$0(12);
                }
                if (options2 == null) {
                    PatternCompiler.$$$reportNull$$$0(13);
                }
                if (result2 == null) {
                    PatternCompiler.$$$reportNull$$$0(14);
                }
                if (prefixProvider == null) {
                    PatternCompiler.$$$reportNull$$$0(15);
                }
                if (context2 == null) {
                    PatternCompiler.$$$reportNull$$$0(16);
                }
                result2.clearHandlers();
                buf = new StringBuilder();
                Template template = TemplateManager.getInstance(project).createTemplate("", "", options2.getSearchPattern());
                int segmentsCount = template.getSegmentsCount();
                text2 = template.getTemplateText();
                prevOffset = 0;
                HashSet<String> variableNames = new HashSet<String>();
                fileType = options2.getFileType();
                assert (fileType != null);
                for (int i2 = 0; i2 < segmentsCount; ++i2) {
                    int offset;
                    block39: {
                        offset = template.getSegmentOffset(i2);
                        String name = template.getSegmentName(i2);
                        String prefix2 = prefixProvider.getPrefix(i2);
                        if (prefix2 == null) {
                            if (checkForErrors) {
                                throw new MalformedPatternException();
                            }
                            List<PsiElement> list2 = Collections.emptyList();
                            if (list2 == null) {
                                PatternCompiler.$$$reportNull$$$0(17);
                            }
                            return list2;
                        }
                        String compiledName = prefix2 + name;
                        buf.append(text2, prevOffset, offset).append(compiledName);
                        int repeated = !variableNames.add(name) ? 1 : 0;
                        SubstitutionHandler existing = (SubstitutionHandler)result2.getHandler(compiledName);
                        if (existing != null) {
                            existing.setRepeatedVar(repeated != 0);
                        } else {
                            try {
                                MatchPredicate predicate2;
                                MatchVariableConstraint constraint2 = options2.getVariableConstraint(name);
                                if (constraint2 == null) {
                                    constraint2 = options2.addNewVariableConstraint(name);
                                }
                                SubstitutionHandler handler2 = result2.createSubstitutionHandler(name, compiledName, constraint2.isPartOfSearchResults(), constraint2.getMinCount(), constraint2.getMaxCount(), constraint2.isGreedy());
                                handler2.setRepeatedVar(repeated != 0);
                                if (constraint2.isWithinHierarchy()) {
                                    handler2.setSubtype(true);
                                }
                                if (constraint2.isStrictlyWithinHierarchy()) {
                                    handler2.setStrictSubtype(true);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getRegExp())) {
                                    predicate2 = new RegExpPredicate(constraint2.getRegExp(), options2.isCaseSensitiveMatch(), name, constraint2.isWholeWordsOnly(), constraint2.isPartOfSearchResults());
                                    if (constraint2.isInvertRegExp()) {
                                        predicate2 = new NotPredicate(predicate2);
                                    }
                                    PatternCompiler.addPredicate(handler2, predicate2);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getReferenceConstraint())) {
                                    predicate2 = new ReferencePredicate(constraint2.getReferenceConstraint(), fileType, project);
                                    if (constraint2.isInvertReference()) {
                                        predicate2 = new NotPredicate(predicate2);
                                    }
                                    PatternCompiler.addPredicate(handler2, predicate2);
                                }
                                PatternCompiler.addExtensionPredicates(options2, constraint2, handler2);
                                PatternCompiler.addScriptConstraint(project, name, constraint2, handler2, variableNames, options2, checkForErrors);
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getContainsConstraint())) {
                                    predicate2 = new ContainsPredicate(name, constraint2.getContainsConstraint());
                                    if (constraint2.isInvertContainsConstraint()) {
                                        predicate2 = new NotPredicate(predicate2);
                                    }
                                    PatternCompiler.addPredicate(handler2, predicate2);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getWithinConstraint())) assert (false);
                            }
                            catch (MalformedPatternException e) {
                                if (!checkForErrors) break block39;
                                throw e;
                            }
                        }
                    }
                    prevOffset = offset;
                }
                constraint = options2.getVariableConstraint("__context__");
                if (constraint != null) {
                    SubstitutionHandler handler3 = result2.createSubstitutionHandler("__context__", "__context__", constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
                    try {
                        if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) {
                            MatchPredicate predicate3 = new WithinPredicate(constraint.getWithinConstraint(), fileType, project);
                            if (constraint.isInvertWithinConstraint()) {
                                predicate3 = new NotPredicate(predicate3);
                            }
                            PatternCompiler.addPredicate(handler3, predicate3);
                        }
                        PatternCompiler.addExtensionPredicates(options2, constraint, handler3);
                        PatternCompiler.addScriptConstraint(project, "__context__", constraint, handler3, variableNames, options2, checkForErrors);
                    }
                    catch (MalformedPatternException e) {
                        if (!checkForErrors) break block40;
                        throw e;
                    }
                }
            }
            buf.append(text2.substring(prevOffset));
            try {
                PatternContextInfo contextInfo = new PatternContextInfo(PatternTreeContext.Block, options2.getPatternContext(), constraint != null ? constraint.getContextConstraint() : null);
                Language dialect = options2.getDialect();
                assert (dialect != null);
                patternElements = MatcherImplUtil.createTreeFromText(buf.toString(), contextInfo, fileType, dialect, project, false);
                if (((PsiElement[])patternElements).length == 0 && checkForErrors) {
                    throw new MalformedPatternException();
                }
            }
            catch (IncorrectOperationException e) {
                if (checkForErrors) {
                    throw new MalformedPatternException(e.getMessage());
                }
                List<PsiElement> list3 = Collections.emptyList();
                if (list3 == null) {
                    PatternCompiler.$$$reportNull$$$0(18);
                }
                return list3;
            }
            NodeFilter filter = LexicalNodesFilter.getInstance();
            elements = new SmartList();
            for (PsiElement element2 : patternElements) {
                if (filter.accepts(element2)) continue;
                elements.add(element2);
            }
            compilingVisitor = new GlobalCompilingVisitor();
            try {
                compilingVisitor.compile(elements.toArray(PsiElement.EMPTY_ARRAY), context2);
            }
            catch (MalformedPatternException e) {
                if (!checkForErrors) break block41;
                throw e;
            }
        }
        new DeleteNodesAction(compilingVisitor.getLexicalNodes()).run();
        SmartList smartList = elements;
        if (smartList == null) {
            PatternCompiler.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    private static void addExtensionPredicates(@NotNull MatchOptions options2, @NotNull MatchVariableConstraint constraint, @NotNull SubstitutionHandler handler2) {
        if (options2 == null) {
            PatternCompiler.$$$reportNull$$$0(20);
        }
        if (constraint == null) {
            PatternCompiler.$$$reportNull$$$0(21);
        }
        if (handler2 == null) {
            PatternCompiler.$$$reportNull$$$0(22);
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options2.getFileType());
        assert (profile != null);
        for (MatchPredicate matchPredicate : profile.getCustomPredicates(constraint, handler2.getName(), options2)) {
            PatternCompiler.addPredicate(handler2, matchPredicate);
        }
    }

    private static void addScriptConstraint(Project project, String name, MatchVariableConstraint constraint, SubstitutionHandler handler2, Set<String> variableNames, MatchOptions matchOptions, boolean checkForErrors) throws MalformedPatternException {
        String scriptCodeConstraint = constraint.getScriptCodeConstraint();
        if (scriptCodeConstraint.length() > 2) {
            String script = StringUtil.unquoteString((String)scriptCodeConstraint);
            String problem = ScriptSupport.checkValidScript(script, matchOptions);
            if (problem != null) {
                if (checkForErrors) {
                    throw new MalformedPatternException(SSRBundle.message("error.script.constraint.for.0.has.problem.1", constraint.getName(), problem));
                }
                return;
            }
            PatternCompiler.addPredicate(handler2, new ScriptPredicate(project, name, script, variableNames, matchOptions));
        }
    }

    private static void addPredicate(SubstitutionHandler handler2, @NotNull MatchPredicate predicate2) {
        if (predicate2 == null) {
            PatternCompiler.$$$reportNull$$$0(23);
        }
        handler2.setPredicate(handler2.getPredicate() == null ? predicate2 : new AndPredicate(handler2.getPredicate(), predicate2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicablePrefixes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "compileByAllPrefixes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTypedVarOffsets";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCompilePattern";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compileByAllPrefixes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCompile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPredicates";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addPredicate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArrayPrefixProvider
    implements PrefixProvider {
        private final String[] myPrefixes;

        ArrayPrefixProvider(String @NotNull [] prefixes) {
            if (prefixes == null) {
                ArrayPrefixProvider.$$$reportNull$$$0(0);
            }
            this.myPrefixes = prefixes;
        }

        @Override
        public String getPrefix(int varIndex) {
            if (varIndex >= this.myPrefixes.length) {
                return null;
            }
            return this.myPrefixes[varIndex];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ArrayPrefixProvider", "<init>"));
        }
    }

    private static class ConstantPrefixProvider
    implements PrefixProvider {
        private final String myPrefix;

        ConstantPrefixProvider(@NotNull String prefix2) {
            if (prefix2 == null) {
                ConstantPrefixProvider.$$$reportNull$$$0(0);
            }
            this.myPrefix = prefix2;
        }

        @Override
        @NotNull
        public String getPrefix(int varIndex) {
            String string = this.myPrefix;
            if (string == null) {
                ConstantPrefixProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ConstantPrefixProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ConstantPrefixProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface PrefixProvider {
        public String getPrefix(int var1);
    }
}

