/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class StringToConstraintsTransformer {
    @NonNls
    private static final String REF = "ref";
    @NonNls
    private static final String REGEX = "regex";
    @NonNls
    private static final String REGEXW = "regexw";
    @NonNls
    private static final String EXPRTYPE = "exprtype";
    @NonNls
    private static final String FORMAL = "formal";
    @NonNls
    private static final String SCRIPT = "script";
    @NonNls
    private static final String CONTAINS = "contains";
    @NonNls
    private static final String WITHIN = "within";
    @NonNls
    private static final String CONTEXT = "context";
    private static final Set<String> knownOptions = ContainerUtil.set((Object[])new String[]{"ref", "regex", "regexw", "exprtype", "formal", "script", "contains", "within", "context"});

    public static void transformCriteria(@NotNull String criteria, @NotNull MatchOptions options2) {
        if (criteria == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(1);
        }
        StringBuilder pattern = new StringBuilder();
        int anonymousTypedVarsCount = 0;
        boolean targetFound = false;
        MatchVariableConstraint context2 = options2.addNewVariableConstraint("__context__");
        int length = criteria.length();
        for (int index2 = 0; index2 < length; ++index2) {
            char ch = criteria.charAt(index2);
            if (index2 == 0 && ch == '[') {
                index2 = StringToConstraintsTransformer.handleTypedVarCondition(0, criteria, context2);
                if (index2 == length) break;
                ch = criteria.charAt(index2);
            }
            if (ch == '\\' && index2 + 1 < length) {
                ch = criteria.charAt(++index2);
            } else if (ch == '\'') {
                Object typedVar;
                int endIndex;
                int newIndex = StringToConstraintsTransformer.handleCharacterLiteral(criteria, index2, pattern);
                if (newIndex != index2) {
                    index2 = newIndex;
                    continue;
                }
                for (endIndex = ++index2; endIndex < length && Character.isJavaIdentifierPart(criteria.charAt(endIndex)); ++endIndex) {
                }
                if (endIndex == index2) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.character", new Object[0]));
                }
                boolean target2 = true;
                if (criteria.charAt(index2) == '_') {
                    target2 = false;
                    typedVar = endIndex == index2 + 1 ? "_" + ++anonymousTypedVarsCount : criteria.substring(index2 + 1, endIndex);
                } else {
                    typedVar = criteria.substring(index2, endIndex);
                }
                pattern.append("$").append((String)typedVar).append("$");
                index2 = endIndex;
                MatchVariableConstraint constraint = options2.getVariableConstraint((String)typedVar);
                boolean constraintCreated = false;
                if (constraint == null) {
                    constraint = new MatchVariableConstraint((String)typedVar);
                    constraintCreated = true;
                }
                int savedIndex = index2;
                int minOccurs = 1;
                int maxOccurs = 1;
                boolean greedy = true;
                if (index2 < length) {
                    ch = criteria.charAt(index2);
                    if (ch == '+') {
                        maxOccurs = Integer.MAX_VALUE;
                        ++index2;
                    } else if (ch == '?') {
                        minOccurs = 0;
                        ++index2;
                    } else if (ch == '*') {
                        minOccurs = 0;
                        maxOccurs = Integer.MAX_VALUE;
                        ++index2;
                    } else if (ch == '{') {
                        ++index2;
                        minOccurs = -1;
                        maxOccurs = -1;
                        while (index2 < length && (ch = criteria.charAt(index2)) >= '0' && ch <= '9') {
                            if (minOccurs < 0) {
                                minOccurs = 0;
                            }
                            if ((minOccurs = minOccurs * 10 + (ch - 48)) < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                            }
                            ++index2;
                        }
                        if (ch == ',') {
                            ++index2;
                            while (index2 < length && (ch = criteria.charAt(index2)) >= '0' && ch <= '9') {
                                if (maxOccurs < 0) {
                                    maxOccurs = 0;
                                }
                                if ((maxOccurs = maxOccurs * 10 + (ch - 48)) < 0) {
                                    throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                }
                                ++index2;
                            }
                        } else {
                            maxOccurs = -2;
                        }
                        if (ch != '}') {
                            if (minOccurs < 0 && maxOccurs < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.expected.digit", new Object[0]));
                            }
                            if (maxOccurs < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.expected.brace1", new Object[0]));
                            }
                            throw new MalformedPatternException(SSRBundle.message("error.expected.brace2", new Object[0]));
                        }
                        if (minOccurs < 0 && maxOccurs < 0) {
                            throw new MalformedPatternException(SSRBundle.message("error.empty.quantifier", new Object[0]));
                        }
                        if (minOccurs == -1) {
                            minOccurs = 0;
                        } else if (maxOccurs == -1) {
                            maxOccurs = Integer.MAX_VALUE;
                        } else if (maxOccurs == -2) {
                            maxOccurs = minOccurs;
                        }
                        ++index2;
                    }
                    if (index2 < length && (ch = criteria.charAt(index2)) == '?') {
                        greedy = false;
                        ++index2;
                    }
                }
                if (constraintCreated) {
                    constraint.setMinCount(minOccurs);
                    constraint.setMaxCount(maxOccurs);
                    constraint.setGreedy(greedy);
                    constraint.setPartOfSearchResults(target2);
                    if (targetFound && target2) {
                        throw new MalformedPatternException(SSRBundle.message("error.only.one.target.allowed", new Object[0]));
                    }
                    targetFound |= target2;
                } else if (savedIndex != index2) {
                    throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                }
                if (index2 < length && criteria.charAt(index2) == ':') {
                    if (++index2 >= length) {
                        throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
                    }
                    ch = criteria.charAt(index2);
                    if (ch == ':') {
                        pattern.append(ch);
                    } else {
                        if (!constraintCreated) {
                            throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                        }
                        index2 = StringToConstraintsTransformer.handleTypedVarCondition(index2, criteria, constraint);
                    }
                }
                if (constraintCreated) {
                    options2.addVariableConstraint(constraint);
                }
                if (index2 == length) break;
                --index2;
                continue;
            }
            pattern.append(ch);
        }
        options2.setSearchPattern(pattern.toString());
    }

    public static int handleCharacterLiteral(@NotNull String criteria, int index2, @NotNull StringBuilder pattern) {
        int length;
        if (criteria == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(3);
        }
        if (index2 + 1 < (length = criteria.length()) && criteria.charAt(index2 + 1) == '\'') {
            pattern.append('\'');
            return index2 + 1;
        }
        if (index2 + 2 < length && criteria.charAt(index2 + 2) == '\'') {
            pattern.append(criteria, index2, index2 + 3);
            return index2 + 2;
        }
        if (index2 + 3 < length && criteria.charAt(index2 + 1) == '\\' && criteria.charAt(index2 + 3) == '\'') {
            pattern.append(criteria, index2, index2 + 4);
            return index2 + 3;
        }
        if (index2 + 7 < length && criteria.charAt(index2 + 1) == '\\' && criteria.charAt(index2 + 2) == 'u' && criteria.charAt(index2 + 7) == '\'') {
            pattern.append(criteria, index2, index2 + 8);
            return index2 + 7;
        }
        return index2;
    }

    private static int handleTypedVarCondition(int index2, @NotNull String criteria, @NotNull MatchVariableConstraint constraint) {
        if (criteria == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(4);
        }
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(5);
        }
        int length = criteria.length();
        char ch = criteria.charAt(index2);
        if (ch == '!') {
            constraint.setInvertRegExp(true);
            if (++index2 >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = criteria.charAt(index2);
        }
        if (ch == '+' || ch == '*') {
            switch (ch) {
                case '+': {
                    constraint.setStrictlyWithinHierarchy(true);
                    break;
                }
                case '*': {
                    constraint.setWithinHierarchy(true);
                }
            }
            if (++index2 >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = criteria.charAt(index2);
        }
        if (ch == '[') {
            boolean quoted = false;
            int endIndex = index2++;
            while (++endIndex < length) {
                if (criteria.charAt(endIndex - 1) == '\\') continue;
                ch = criteria.charAt(endIndex);
                if (ch == '\"') {
                    quoted = !quoted;
                    continue;
                }
                if (ch != ']' || quoted) continue;
            }
            if (quoted) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
            }
            if (ch != ']') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "]"));
            }
            StringToConstraintsTransformer.parseCondition(constraint, criteria.substring(index2, endIndex));
            return endIndex + 1;
        }
        return StringToConstraintsTransformer.handleRegExp(index2, criteria, constraint);
    }

    private static int handleRegExp(int index2, @NotNull String criteria, @NotNull MatchVariableConstraint constraint) {
        int endIndex;
        if (criteria == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(6);
        }
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(7);
        }
        int length = criteria.length();
        for (endIndex = index2; endIndex < length && !Character.isWhitespace(criteria.charAt(endIndex)); ++endIndex) {
        }
        if (endIndex == index2) {
            if (criteria.charAt(index2 - 1) == ':') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
            }
            return endIndex;
        }
        String regexp = criteria.substring(index2, endIndex);
        if (!constraint.getRegExp().isEmpty() && !constraint.getRegExp().equals(regexp)) {
            throw new MalformedPatternException(SSRBundle.message("error.two.different.type.constraints", new Object[0]));
        }
        StringToConstraintsTransformer.checkRegex(regexp);
        constraint.setRegExp(regexp);
        return endIndex;
    }

    private static void parseCondition(@NotNull MatchVariableConstraint constraint, @NotNull String condition2) {
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(8);
        }
        if (condition2 == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(9);
        }
        int length = condition2.length();
        StringBuilder text2 = new StringBuilder();
        boolean invert2 = false;
        boolean optionExpected = true;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = condition2.charAt(i2);
            if (Character.isWhitespace(c)) {
                if (text2.length() == 0) continue;
                StringToConstraintsTransformer.handleOption(constraint, text2.toString(), "", invert2);
                optionExpected = false;
                continue;
            }
            if (c == '(') {
                if (text2.length() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.condition.name", new Object[0]));
                }
                String option2 = text2.toString();
                if (!option2.startsWith("_") && !knownOptions.contains(option2)) {
                    throw new MalformedPatternException(SSRBundle.message("option.is.not.recognized.error.message", option2));
                }
                text2.setLength(0);
                int spaces = 0;
                while (++i2 < length && condition2.charAt(i2) == ' ') {
                    ++spaces;
                }
                --i2;
                boolean quoted = false;
                boolean closed = false;
                while (++i2 < length) {
                    c = condition2.charAt(i2);
                    if (condition2.charAt(i2 - 1) != '\\') {
                        if (c == '\"') {
                            quoted = !quoted;
                        } else if (c == ')' && !quoted) {
                            int j;
                            for (j = 1; j <= spaces && condition2.charAt(i2 - j) == ' '; ++j) {
                            }
                            if (j - 1 == spaces) {
                                closed = true;
                                break;
                            }
                        }
                    }
                    text2.append(c);
                }
                if (text2.length() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.argument.expected", option2));
                }
                if (quoted) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
                }
                if (!closed) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", StringUtil.repeatSymbol((char)' ', (int)spaces) + ")"));
                }
                StringToConstraintsTransformer.handleOption(constraint, option2, text2.toString(), invert2);
                text2.setLength(0);
                invert2 = false;
                optionExpected = false;
                continue;
            }
            if (c == '&') {
                if (text2.length() != 0) {
                    StringToConstraintsTransformer.handleOption(constraint, text2.toString(), "", invert2);
                    optionExpected = false;
                }
                if (++i2 == length || condition2.charAt(i2) != '&' || optionExpected) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "&"));
                }
                text2.setLength(0);
                invert2 = false;
                optionExpected = true;
                continue;
            }
            if (!optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "&&"));
            }
            if (c == '!') {
                if (text2.length() != 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "!"));
                }
                invert2 = !invert2;
                continue;
            }
            text2.append(c);
        }
        if (text2.length() != 0) {
            StringToConstraintsTransformer.handleOption(constraint, text2.toString(), "", invert2);
        } else {
            if (invert2) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "!"));
            }
            if (optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", length == 0 ? "[" : "&&"));
            }
        }
    }

    private static void handleOption(@NotNull MatchVariableConstraint constraint, @NotNull String option2, @NotNull String argument, boolean invert2) {
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(10);
        }
        if (option2 == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(11);
        }
        if (argument == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(12);
        }
        argument = argument.trim();
        if (option2.equals(REF)) {
            constraint.setReferenceConstraint(argument);
            constraint.setInvertReference(invert2);
        } else if (option2.equals(REGEX) || option2.equals(REGEXW)) {
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setRegExp(argument);
            constraint.setInvertRegExp(invert2);
            if (option2.equals(REGEXW)) {
                constraint.setWholeWordsOnly(true);
            }
        } else if (option2.equals(EXPRTYPE)) {
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setExprTypeWithinHierarchy(true);
            }
            argument = StringToConstraintsTransformer.unescape(argument);
            constraint.setExpressionTypes(argument);
            constraint.setInvertExprType(invert2);
        } else if (option2.equals(FORMAL)) {
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setFormalArgTypeWithinHierarchy(true);
            }
            argument = StringToConstraintsTransformer.unescape(argument);
            constraint.setExpectedTypes(argument);
            constraint.setInvertFormalType(invert2);
        } else if (option2.equals(SCRIPT)) {
            if (invert2) {
                throw new MalformedPatternException(SSRBundle.message("error.cannot.invert", option2));
            }
            constraint.setScriptCodeConstraint(argument);
        } else if (option2.equals(CONTAINS)) {
            constraint.setContainsConstraint(argument);
            constraint.setInvertContainsConstraint(invert2);
        } else if (option2.equals(WITHIN)) {
            if (!"__context__".equals(constraint.getName())) {
                throw new MalformedPatternException(SSRBundle.message("error.only.applicable.to.complete.match", option2));
            }
            constraint.setWithinConstraint(argument);
            constraint.setInvertWithinConstraint(invert2);
        } else if (option2.equals(CONTEXT)) {
            if (invert2) {
                throw new MalformedPatternException(SSRBundle.message("error.cannot.invert", option2));
            }
            if (!"__context__".equals(constraint.getName())) {
                throw new MalformedPatternException(SSRBundle.message("error.only.applicable.to.complete.match", option2));
            }
            constraint.setContextConstraint(argument);
        } else if (option2.startsWith("_")) {
            if (invert2) {
                throw new MalformedPatternException(SSRBundle.message("error.cannot.invert", option2));
            }
            constraint.putAdditionalConstraint(option2.substring(1), argument);
        } else assert (false);
    }

    private static void checkRegex(@NotNull String regex) {
        if (regex == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(13);
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", e.getMessage()));
        }
    }

    @NotNull
    private static String unescape(@NotNull String s) {
        if (s == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(14);
        }
        StringBuilder result2 = new StringBuilder();
        boolean escaped = false;
        int length = s.length();
        for (int i2 = 0; i2 < length; ++i2) {
            int c = s.codePointAt(i2);
            if (c == 92 && !escaped) {
                escaped = true;
                continue;
            }
            escaped = false;
            result2.appendCodePoint(c);
        }
        String string = result2.toString();
        if (string == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "criteria";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGEX;
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/StringToConstraintsTransformer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/StringToConstraintsTransformer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transformCriteria";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleCharacterLiteral";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleTypedVarCondition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleRegExp";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseCondition";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleOption";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkRegex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

