/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WordOptimizer {
    default public boolean handleWord(@Nullable String text2, GlobalCompilingVisitor.OccurenceKind kind, CompileContext compileContext) {
        OptimizingSearchHelper searchHelper = compileContext.getSearchHelper();
        if (!searchHelper.doOptimizing()) {
            return false;
        }
        if (text2 == null) {
            return true;
        }
        for (String word : StringUtil.getWordsInStringLongestFirst((String)text2)) {
            CompiledPattern pattern = compileContext.getPattern();
            if (pattern.isTypedVar(word)) {
                SubstitutionHandler handler2 = (SubstitutionHandler)pattern.getHandler(word);
                if (handler2 == null || handler2.getMinOccurs() == 0) {
                    return false;
                }
                RegExpPredicate predicate2 = handler2.findRegExpPredicate();
                if (predicate2 == null || !predicate2.couldBeOptimized()) continue;
                if (handler2.isStrictSubtype() || handler2.isSubtype()) {
                    List<String> descendants = this.getDescendantsOf(predicate2.getRegExp(), handler2.isSubtype(), compileContext.getProject());
                    for (String descendant : descendants) {
                        searchHelper.addWordToSearchInCode(descendant);
                    }
                    searchHelper.endTransaction();
                    continue;
                }
                GlobalCompilingVisitor.addFilesToSearchForGivenWord(predicate2.getRegExp(), true, kind, compileContext);
                continue;
            }
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(word, true, kind, compileContext);
        }
        return true;
    }

    @NotNull
    default public List<String> getDescendantsOf(@NotNull String className, boolean includeSelf, @NotNull Project project) {
        if (className == null) {
            WordOptimizer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            WordOptimizer.$$$reportNull$$$0(1);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            WordOptimizer.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/WordOptimizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/WordOptimizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendantsOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescendantsOf";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

