/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MatchingHandler {
    protected NodeFilter filter;
    private PsiElement pinnedElement;
    protected static ClearStateVisitor clearingVisitor = new ClearStateVisitor();

    public void setFilter(@Nullable NodeFilter filter) {
        this.filter = filter;
    }

    public boolean match(PsiElement patternNode, PsiElement matchedNode, @NotNull MatchContext context2) {
        if (context2 == null) {
            MatchingHandler.$$$reportNull$$$0(0);
        }
        return patternNode == null ? matchedNode == null : this.canMatch(patternNode, matchedNode, context2);
    }

    public boolean canMatch(@NotNull PsiElement patternNode, PsiElement matchedNode, @NotNull MatchContext context2) {
        if (patternNode == null) {
            MatchingHandler.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            MatchingHandler.$$$reportNull$$$0(2);
        }
        return this.filter != null ? this.filter.accepts(matchedNode) : DefaultFilter.accepts(patternNode, matchedNode);
    }

    public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context2) {
        if (patternNodes == null) {
            MatchingHandler.$$$reportNull$$$0(3);
        }
        if (matchNodes == null) {
            MatchingHandler.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            MatchingHandler.$$$reportNull$$$0(5);
        }
        MatchingStrategy strategy = context2.getPattern().getStrategy();
        PsiElement currentPatternNode = patternNodes.current();
        PsiElement currentMatchNode = matchNodes.current();
        MatchingHandler.skipIfNecessary(matchNodes, currentPatternNode, strategy);
        MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy);
        if (!patternNodes.hasNext()) {
            return !matchNodes.hasNext();
        }
        PsiElement patternElement = patternNodes.current();
        MatchingHandler handler2 = context2.getPattern().getHandler(patternElement);
        if (!(handler2 instanceof TopLevelMatchingHandler)) {
            MatchingHandler.skipComments(matchNodes, currentPatternNode);
        }
        if (matchNodes.hasNext() && handler2.match(patternElement, matchNodes.current(), context2)) {
            patternNodes.advance();
            MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy);
            if (this.shouldAdvanceTheMatchFor(patternElement, matchNodes.current())) {
                matchNodes.advance();
                MatchingHandler.skipIfNecessary(matchNodes, patternNodes.current(), strategy);
                if (patternNodes.hasNext()) {
                    MatchingHandler.skipComments(matchNodes, patternNodes.current());
                }
            }
            if (patternNodes.hasNext()) {
                MatchingHandler nextHandler = context2.getPattern().getHandler(patternNodes.current());
                if (nextHandler.matchSequentially(patternNodes, matchNodes, context2)) {
                    return true;
                }
                patternNodes.rewindTo(currentPatternNode);
                matchNodes.rewindTo(currentMatchNode);
            } else {
                return handler2.isMatchSequentiallySucceeded(matchNodes);
            }
        }
        return false;
    }

    private static void skipComments(@NotNull NodeIterator matchNodes, PsiElement patternNode) {
        if (matchNodes == null) {
            MatchingHandler.$$$reportNull$$$0(6);
        }
        if (patternNode instanceof PsiComment) {
            return;
        }
        while (matchNodes.current() instanceof PsiComment) {
            matchNodes.advance();
        }
    }

    private static void skipIfNecessary(@NotNull NodeIterator nodes, PsiElement elementToMatchWith, @NotNull MatchingStrategy strategy) {
        if (nodes == null) {
            MatchingHandler.$$$reportNull$$$0(7);
        }
        if (strategy == null) {
            MatchingHandler.$$$reportNull$$$0(8);
        }
        while (nodes.hasNext() && strategy.shouldSkip(nodes.current(), elementToMatchWith)) {
            nodes.advance();
        }
    }

    protected boolean isMatchSequentiallySucceeded(@NotNull NodeIterator matchNodes) {
        if (matchNodes == null) {
            MatchingHandler.$$$reportNull$$$0(9);
        }
        MatchingHandler.skipComments(matchNodes, null);
        return !matchNodes.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchInAnyOrder(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchedNodes, @NotNull MatchContext context2) {
        if (patternNodes == null) {
            MatchingHandler.$$$reportNull$$$0(10);
        }
        if (matchedNodes == null) {
            MatchingHandler.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            MatchingHandler.$$$reportNull$$$0(12);
        }
        MatchResultImpl saveResult = context2.hasResult() ? context2.getResult() : null;
        context2.setResult(null);
        try {
            if (patternNodes.hasNext() && !matchedNodes.hasNext()) {
                boolean bl = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context2);
                return bl;
            }
            HashSet<PsiElement> matchedElements = null;
            while (patternNodes.hasNext()) {
                PsiElement patternNode = patternNodes.current();
                patternNodes.advance();
                CompiledPattern pattern = context2.getPattern();
                MatchingHandler handler2 = pattern.getHandler(patternNode);
                matchedNodes.reset();
                boolean allElementsMatched = true;
                int matchedOccurs = 0;
                while (true) {
                    PsiElement pinnedNode;
                    PsiElement matchedNode;
                    PsiElement psiElement = matchedNode = (pinnedNode = handler2.getPinnedNode()) != null ? pinnedNode : matchedNodes.current();
                    if (pinnedNode == null) {
                        matchedNodes.advance();
                    }
                    if (matchedElements == null || !matchedElements.contains(matchedNode)) {
                        allElementsMatched = false;
                        if (handler2.match(patternNode, matchedNode, context2)) {
                            ++matchedOccurs;
                            if (matchedElements == null) {
                                matchedElements = new HashSet<PsiElement>();
                            }
                            matchedElements.add(matchedNode);
                            if (handler2.shouldAdvanceThePatternFor(patternNode, matchedNode)) {
                                break;
                            }
                        } else if (pinnedNode != null) {
                            boolean bl = false;
                            return bl;
                        }
                        clearingVisitor.clearState(pattern, patternNode);
                    }
                    if (matchedNodes.hasNext() && pinnedNode == null) continue;
                    if (!handler2.validate(context2, matchedOccurs)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!allElementsMatched && patternNodes.hasNext()) break;
                    boolean result2 = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context2);
                    if (result2 && matchedElements != null) {
                        context2.notifyMatchedElements(matchedElements);
                    }
                    boolean bl = result2;
                    return bl;
                }
                if (handler2.validate(context2, matchedOccurs)) continue;
                boolean bl = false;
                return bl;
            }
            boolean result3 = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context2);
            if (result3 && matchedElements != null) {
                context2.notifyMatchedElements(matchedElements);
            }
            boolean bl = result3;
            return bl;
        }
        finally {
            if (saveResult != null) {
                if (context2.hasResult()) {
                    for (MatchResult child2 : context2.getResult().getChildren()) {
                        saveResult.addChild(child2);
                    }
                }
                context2.setResult(saveResult);
            }
        }
    }

    protected static boolean validateSatisfactionOfHandlers(@NotNull NodeIterator patternNodes, @NotNull MatchContext context2) {
        if (patternNodes == null) {
            MatchingHandler.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            MatchingHandler.$$$reportNull$$$0(14);
        }
        while (patternNodes.hasNext()) {
            if (!context2.getPattern().getHandler(patternNodes.current()).validate(context2, 0)) {
                return false;
            }
            patternNodes.advance();
        }
        return true;
    }

    public boolean validate(@NotNull MatchContext context2, int matchedOccurs) {
        if (context2 == null) {
            MatchingHandler.$$$reportNull$$$0(15);
        }
        return matchedOccurs == 1;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean shouldAdvanceThePatternFor(@NotNull PsiElement patternElement, @NotNull PsiElement matchedElement) {
        if (patternElement == null) {
            MatchingHandler.$$$reportNull$$$0(16);
        }
        if (matchedElement == null) {
            MatchingHandler.$$$reportNull$$$0(17);
        }
        return true;
    }

    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public void reset() {
    }

    public PsiElement getPinnedNode() {
        return this.pinnedElement;
    }

    public void setPinnedElement(@NotNull PsiElement pinnedElement) {
        if (pinnedElement == null) {
            MatchingHandler.$$$reportNull$$$0(18);
        }
        this.pinnedElement = pinnedElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNode";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNodes";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNodes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinnedElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/MatchingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canMatch";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "matchSequentially";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "skipComments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "skipIfNecessary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatchSequentiallySucceeded";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "matchInAnyOrder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSatisfactionOfHandlers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAdvanceThePatternFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "setPinnedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ClearStateVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private CompiledPattern pattern;

        ClearStateVisitor() {
            super(true);
        }

        public void visitElement(@NotNull PsiElement element2) {
            MatchingHandler handler2;
            if (element2 == null) {
                ClearStateVisitor.$$$reportNull$$$0(0);
            }
            if (this.pattern.isToResetHandler(element2) && (handler2 = this.pattern.getHandlerSimple(element2)) != null) {
                handler2.reset();
            }
            super.visitElement(element2);
        }

        synchronized void clearState(@NotNull CompiledPattern _pattern, @NotNull PsiElement el) {
            if (_pattern == null) {
                ClearStateVisitor.$$$reportNull$$$0(1);
            }
            if (el == null) {
                ClearStateVisitor.$$$reportNull$$$0(2);
            }
            this.pattern = _pattern;
            el.acceptChildren((PsiElementVisitor)this);
            this.pattern = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "el";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/MatchingHandler$ClearStateVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clearState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

