/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionHandler
extends MatchingHandler {
    @NotNull
    private final String name;
    private final int maxOccurs;
    private final int minOccurs;
    private final boolean greedy;
    private boolean target;
    private MatchPredicate predicate;
    private MatchingHandler matchHandler;
    private boolean subtype;
    private boolean strictSubtype;
    private int matchedOccurs;
    private int totalMatchedOccurs;
    private MatchResultImpl myNestedResult;
    private boolean myRepeatedVar;
    private static final NodeFilter VARS_DELIM_FILTER = element2 -> {
        if (element2 == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element2);
        if (profile == null) {
            return false;
        }
        return profile.canBeVarDelimiter(element2);
    };

    public SubstitutionHandler(@NotNull String name, boolean target2, int minOccurs, int maxOccurs, boolean greedy) {
        if (name == null) {
            SubstitutionHandler.$$$reportNull$$$0(0);
        }
        this.totalMatchedOccurs = -1;
        if (minOccurs < 0) {
            throw new IllegalArgumentException("minOccurs must be greater or equal to 0");
        }
        if (minOccurs > maxOccurs) {
            throw new IllegalArgumentException("maxOccurs must be greater equal to minOccurs");
        }
        this.name = name;
        this.maxOccurs = maxOccurs;
        this.minOccurs = minOccurs;
        this.target = target2;
        this.greedy = greedy;
    }

    public boolean isSubtype() {
        return this.subtype;
    }

    public boolean isStrictSubtype() {
        return this.strictSubtype;
    }

    public void setStrictSubtype(boolean strictSubtype) {
        this.strictSubtype = strictSubtype;
    }

    public void setSubtype(boolean subtype) {
        this.subtype = subtype;
    }

    public void setPredicate(@NotNull MatchPredicate handler2) {
        if (handler2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(1);
        }
        this.predicate = handler2;
    }

    public MatchPredicate getPredicate() {
        return this.predicate;
    }

    @Nullable
    public RegExpPredicate findRegExpPredicate() {
        return SubstitutionHandler.findRegExpPredicate(this.getPredicate());
    }

    public void setRepeatedVar(boolean repeatedVar) {
        this.myRepeatedVar = repeatedVar;
    }

    private static RegExpPredicate findRegExpPredicate(MatchPredicate start2) {
        if (start2 == null) {
            return null;
        }
        if (start2 instanceof RegExpPredicate) {
            return (RegExpPredicate)start2;
        }
        if (start2 instanceof AndPredicate) {
            AndPredicate binary = (AndPredicate)start2;
            RegExpPredicate result2 = SubstitutionHandler.findRegExpPredicate(binary.getFirst());
            if (result2 != null) {
                return result2;
            }
            return SubstitutionHandler.findRegExpPredicate(binary.getSecond());
        }
        if (start2 instanceof NotPredicate) {
            return null;
        }
        return null;
    }

    private boolean validateOneMatch(@NotNull PsiElement match, int start2, int end, @NotNull MatchResult result2, @NotNull MatchContext matchContext) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(3);
        }
        if (matchContext == null) {
            SubstitutionHandler.$$$reportNull$$$0(4);
        }
        if (!this.myRepeatedVar) {
            return true;
        }
        if (start2 == 0 && end == -1 && result2.getStart() == 0 && result2.getEnd() == -1) {
            return matchContext.getMatcher().match(match, result2.getMatch());
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        assert (profile != null);
        return profile.getText(match, start2, end).equals(result2.getMatchImage());
    }

    public boolean validate(PsiElement match, @NotNull MatchContext context2) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(5);
        }
        return this.validate(match, 0, -1, context2);
    }

    public boolean validate(PsiElement match, int start2, int end, @NotNull MatchContext context2) {
        MatchResultImpl previous;
        MatchResult result2;
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(6);
        }
        if (match == null || this.predicate != null && !this.predicate.match(match, start2, end, context2)) {
            return false;
        }
        MatchResult matchResult = result2 = context2.hasResult() ? context2.getResult().findChild(this.name) : null;
        if (result2 == null && this.myNestedResult != null) {
            result2 = this.myNestedResult.findChild(this.name);
        }
        if (result2 == null && (previous = context2.getPreviousResult()) != null) {
            result2 = previous.findChild(this.name);
        }
        if (result2 != null) {
            if (this.minOccurs == 1 && this.maxOccurs == 1) {
                return this.validateOneMatch(match, start2, end, result2, context2);
            }
            if (this.maxOccurs > 1 && this.totalMatchedOccurs != -1) {
                if (result2.isMultipleMatch()) {
                    List<MatchResult> children2 = result2.getChildren();
                    int size2 = children2.size();
                    if (this.matchedOccurs >= size2) {
                        return false;
                    }
                    if (size2 != 0) {
                        result2 = children2.get(this.matchedOccurs);
                    }
                }
                return this.validateOneMatch(match, start2, end, result2, context2);
            }
        }
        return true;
    }

    @Override
    public boolean match(PsiElement node2, PsiElement match, @NotNull MatchContext context2) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(7);
        }
        if (!super.match(node2, match, context2)) {
            return false;
        }
        return this.matchHandler == null ? context2.getMatcher().match(node2, match) : this.matchHandler.match(node2, match, context2);
    }

    public void addResult(@NotNull PsiElement match, @NotNull MatchContext context2) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(9);
        }
        this.addResult(match, 0, -1, context2);
    }

    public void addResult(@NotNull PsiElement match, int start2, int end, @NotNull MatchContext context2) {
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(11);
        }
        if (this.totalMatchedOccurs == -1) {
            MatchResultImpl matchResult = context2.getResult();
            MatchResultImpl substitution = matchResult.getChild(this.name);
            if (substitution == null) {
                matchResult.addChild(this.createMatch(match, start2, end));
            } else if (this.maxOccurs > 1 || this.target && !this.myRepeatedVar) {
                MatchResultImpl result2 = this.createMatch(match, start2, end);
                if (!substitution.isMultipleMatch()) {
                    MatchResultImpl sonresult = new MatchResultImpl(substitution.getName(), substitution.getMatchImage(), substitution.getMatchRef(), substitution.getStart(), substitution.getEnd(), this.target);
                    substitution.setMatchRef(new SmartPsiPointer(match));
                    substitution.setMultipleMatch(true);
                    if (substitution.isScopeMatch()) {
                        substitution.setScopeMatch(false);
                        sonresult.setScopeMatch(true);
                        for (MatchResult r : substitution.getChildren()) {
                            sonresult.addChild(r);
                        }
                        substitution.removeChildren();
                    }
                    substitution.addChild(sonresult);
                }
                substitution.addChild(result2);
            }
        }
    }

    public boolean handle(PsiElement match, @NotNull MatchContext context2) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(12);
        }
        return this.handle(match, 0, -1, context2);
    }

    public boolean handle(PsiElement match, int start2, int end, @NotNull MatchContext context2) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(13);
        }
        if (!this.validate(match, start2, end, context2)) {
            this.myNestedResult = null;
            return false;
        }
        if (!"__context__".equals(this.name)) {
            this.addResult(match, start2, end, context2);
        }
        return true;
    }

    @NotNull
    private MatchResultImpl createMatch(@NotNull PsiElement match, int start2, int end) {
        MatchResultImpl result2;
        if (match == null) {
            SubstitutionHandler.$$$reportNull$$$0(14);
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        assert (profile != null);
        String image = profile.getText(match, start2, end);
        SmartPsiPointer ref = new SmartPsiPointer(match);
        MatchResultImpl matchResultImpl = result2 = this.myNestedResult == null ? new MatchResultImpl(this.name, image, ref, start2, end, this.target) : this.myNestedResult;
        if (this.myNestedResult != null) {
            this.myNestedResult.setName(this.name);
            this.myNestedResult.setMatchImage(image);
            this.myNestedResult.setMatchRef(ref);
            this.myNestedResult.setStart(start2);
            this.myNestedResult.setEnd(end);
            this.myNestedResult.setTarget(this.target);
            this.myNestedResult = null;
        }
        MatchResultImpl matchResultImpl2 = result2;
        if (matchResultImpl2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(15);
        }
        return matchResultImpl2;
    }

    @Override
    public boolean validate(@NotNull MatchContext context2, int matchedOccurs) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(16);
        }
        if (this.target) {
            return matchedOccurs > 0;
        }
        if (this.minOccurs > matchedOccurs) {
            return false;
        }
        return this.maxOccurs >= matchedOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    private void removeLastResults(int numberOfResults, @NotNull MatchContext context2) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(17);
        }
        if (numberOfResults == 0) {
            return;
        }
        MatchResultImpl substitution = context2.getResult().getChild(this.name);
        if (substitution != null) {
            if (substitution.hasChildren()) {
                while (numberOfResults > 0) {
                    --numberOfResults;
                    MatchResult matchResult = substitution.removeLastChild();
                    context2.removeMatchedNode(matchResult.getMatch());
                }
                if (!substitution.hasChildren()) {
                    context2.getResult().removeChild(this.name);
                }
            } else {
                MatchResult matchResult = context2.getResult().removeChild(this.name);
                assert (matchResult != null);
                context2.removeMatchedNode(matchResult.getMatch());
            }
        }
    }

    @Override
    public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context2) {
        if (patternNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(18);
        }
        if (matchNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(20);
        }
        return this.doMatchSequentially(patternNodes, matchNodes, context2);
    }

    protected boolean doMatchSequentiallyBySimpleHandler(NodeIterator patternNodes, NodeIterator matchNodes, @NotNull MatchContext context2) {
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(21);
        }
        boolean oldValue = context2.shouldRecursivelyMatch();
        context2.setShouldRecursivelyMatch(false);
        boolean result2 = super.matchSequentially(patternNodes, matchNodes, context2);
        context2.setShouldRecursivelyMatch(oldValue);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMatchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context2) {
        if (patternNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(22);
        }
        if (matchNodes == null) {
            SubstitutionHandler.$$$reportNull$$$0(23);
        }
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(24);
        }
        int previousMatchedOccurs = this.matchedOccurs;
        FilteringNodeIterator fNodes = new FilteringNodeIterator(matchNodes, VARS_DELIM_FILTER);
        try {
            MatchingHandler nextHandler;
            PsiElement current22;
            CompiledPattern pattern = context2.getPattern();
            PsiElement currentPatternNode = patternNodes.current();
            MatchingHandler handler2 = pattern.getHandler(currentPatternNode);
            this.matchedOccurs = 0;
            boolean flag = false;
            SmartList matchedNodes = new SmartList();
            while (fNodes.hasNext() && (this.matchedOccurs < this.minOccurs || this.target && !this.myRepeatedVar && !(handler2 instanceof TopLevelMatchingHandler))) {
                current22 = matchNodes.current();
                if (handler2.match(currentPatternNode, current22, context2)) {
                    matchedNodes.add(current22);
                    ++this.matchedOccurs;
                } else if (handler2 instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                fNodes.advance();
                flag = true;
            }
            if (this.matchedOccurs != this.minOccurs && (!this.target || this.myRepeatedVar || this.matchedOccurs == 0)) {
                this.removeLastResults(this.matchedOccurs, context2);
                fNodes.rewind(this.matchedOccurs);
                boolean current22 = false;
                return current22;
            }
            if (this.greedy) {
                while (fNodes.hasNext() && this.matchedOccurs < this.maxOccurs) {
                    current22 = matchNodes.current();
                    if (handler2.match(currentPatternNode, current22, context2)) {
                        matchedNodes.add(current22);
                        ++this.matchedOccurs;
                    } else if (handler2 instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                    fNodes.advance();
                    flag = true;
                }
                if (flag) {
                    fNodes.rewind();
                    matchNodes.advance();
                }
                patternNodes.advance();
                if (patternNodes.hasNext()) {
                    nextHandler = pattern.getHandler(patternNodes.current());
                    while (this.matchedOccurs >= this.minOccurs && patternNodes.hasNext()) {
                        if (nextHandler.matchSequentially(patternNodes, matchNodes, context2)) {
                            this.totalMatchedOccurs = this.matchedOccurs;
                            boolean bl = true;
                            return bl;
                        }
                        int size2 = matchedNodes.size();
                        if (size2 > 0) {
                            matchNodes.rewindTo((PsiElement)matchedNodes.remove(size2 - 1));
                        }
                        this.removeLastResults(1, context2);
                        --this.matchedOccurs;
                    }
                    if (this.matchedOccurs > 0) {
                        this.removeLastResults(this.matchedOccurs, context2);
                    }
                    patternNodes.rewind();
                } else {
                    if (handler2.isMatchSequentiallySucceeded(matchNodes)) {
                        boolean nextHandler2 = this.checkSameOccurrencesConstraint(context2);
                        return nextHandler2;
                    }
                    this.removeLastResults(this.matchedOccurs, context2);
                }
                boolean nextHandler2 = false;
                return nextHandler2;
            }
            patternNodes.advance();
            if (flag) {
                fNodes.rewind();
                matchNodes.advance();
            }
            if (patternNodes.hasNext()) {
                nextHandler = pattern.getHandler(patternNodes.current());
                flag = false;
                while (matchNodes.hasNext() && this.matchedOccurs <= this.maxOccurs) {
                    if (nextHandler.matchSequentially(patternNodes, matchNodes, context2)) {
                        boolean bl = this.checkSameOccurrencesConstraint(context2);
                        return bl;
                    }
                    if (flag) {
                        matchNodes.rewind();
                        fNodes.advance();
                    }
                    if (handler2.match(patternNodes.current(), matchNodes.current(), context2)) {
                        ++this.matchedOccurs;
                    } else {
                        patternNodes.rewind();
                        this.removeLastResults(this.matchedOccurs, context2);
                        boolean bl = false;
                        return bl;
                    }
                    matchNodes.advance();
                    flag = true;
                }
                patternNodes.rewind();
                this.removeLastResults(this.matchedOccurs, context2);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.checkSameOccurrencesConstraint(context2);
            return bl;
        }
        finally {
            this.matchedOccurs = previousMatchedOccurs;
        }
    }

    private boolean checkSameOccurrencesConstraint(@NotNull MatchContext context2) {
        MatchResultImpl result2;
        if (context2 == null) {
            SubstitutionHandler.$$$reportNull$$$0(25);
        }
        if (this.totalMatchedOccurs == -1) {
            this.totalMatchedOccurs = this.matchedOccurs;
            return true;
        }
        MatchResultImpl matchResultImpl = result2 = context2.hasResult() ? context2.getResult().getChild(this.name) : null;
        if (result2 == null && context2.getPreviousResult() != null) {
            result2 = context2.getPreviousResult().getChild(this.name);
        }
        return result2 == null || ((MatchResult)result2).size() == this.matchedOccurs || this.target;
    }

    public void setTarget(boolean target2) {
        this.target = target2;
    }

    public void setMatchHandler(@NotNull MatchingHandler matchHandler) {
        if (matchHandler == null) {
            SubstitutionHandler.$$$reportNull$$$0(26);
        }
        this.matchHandler = matchHandler;
    }

    public boolean isTarget() {
        return this.target;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            SubstitutionHandler.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public void reset() {
        super.reset();
        this.totalMatchedOccurs = -1;
    }

    @Override
    public boolean shouldAdvanceThePatternFor(@NotNull PsiElement patternElement, @NotNull PsiElement matchedElement) {
        if (patternElement == null) {
            SubstitutionHandler.$$$reportNull$$$0(28);
        }
        if (matchedElement == null) {
            SubstitutionHandler.$$$reportNull$$$0(29);
        }
        return this.maxOccurs <= 1 && !this.target;
    }

    public void setNestedResult(MatchResultImpl nestedResult) {
        this.myNestedResult = nestedResult;
    }

    public MatchResultImpl getNestedResult() {
        return this.myNestedResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/handlers/SubstitutionHandler";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNodes";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchNodes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchHandler";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/handlers/SubstitutionHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatch";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPredicate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateOneMatch";
                break;
            }
            case 5: 
            case 6: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMatch";
                break;
            }
            case 15: 
            case 27: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeLastResults";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "matchSequentially";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doMatchSequentiallyBySimpleHandler";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doMatchSequentially";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkSameOccurrencesConstraint";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setMatchHandler";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldAdvanceThePatternFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

