/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project project;
    @NotNull
    private final ReplaceOptions options;
    private final StructuralReplaceHandler replaceHandler;
    private final ReplacementBuilder replacementBuilder;
    private PsiElement lastAffectedElement;

    public Replacer(@NotNull Project project, @NotNull ReplaceOptions options2) {
        if (project == null) {
            Replacer.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            Replacer.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.options = options2;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options2.getMatchOptions().getFileType());
        assert (profile != null);
        this.replaceHandler = profile.getReplaceHandler(project, options2);
        assert (this.replaceHandler != null);
        this.replacementBuilder = new ReplacementBuilder(this.project, this.options);
    }

    public static String stripTypedVariableDecoration(String type) {
        return type.substring(1, type.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result2, int offset, ParameterInfo info2, String image) {
        if (!image.isEmpty()) {
            result2.insert(offset + info2.getStartIndex(), image);
            offset += image.length();
        }
        return offset;
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options2, Project project) {
        return Replacer.testReplace(in, what, by, options2, project, false);
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options2, Project project, boolean sourceIsFile) {
        LanguageFileType fileType = options2.getMatchOptions().getFileType();
        assert (fileType != null);
        return Replacer.testReplace(in, what, by, options2, project, sourceIsFile, false, fileType, fileType.getLanguage());
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions replaceOptions, Project project, boolean sourceIsFile, boolean createPhysicalFile, @NotNull LanguageFileType sourceFileType, @NotNull Language sourceDialect) {
        if (sourceFileType == null) {
            Replacer.$$$reportNull$$$0(2);
        }
        if (sourceDialect == null) {
            Replacer.$$$reportNull$$$0(3);
        }
        replaceOptions.setReplacement(by);
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        matchOptions.fillSearchCriteria(what);
        Matcher.validate(project, matchOptions);
        Replacer.checkReplacementPattern(project, replaceOptions);
        Replacer replacer = new Replacer(project, replaceOptions);
        Matcher matcher = new Matcher(project, matchOptions);
        try {
            PsiElement nextSibling;
            PsiElement parent;
            PsiElement lastElement;
            PsiElement firstElement;
            if (matchOptions.getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(in, new PatternContextInfo(sourceIsFile ? PatternTreeContext.File : PatternTreeContext.Block), sourceFileType, sourceDialect, project, createPhysicalFile);
                firstElement = elements[0];
                lastElement = elements[elements.length - 1];
                parent = firstElement.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope(elements));
            } else {
                parent = ((LocalSearchScope)matchOptions.getScope()).getScope()[0];
                firstElement = parent.getFirstChild();
                lastElement = parent.getLastChild();
            }
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            matcher.testFindMatches(sink);
            SmartList replacements = new SmartList();
            for (MatchResult result2 : sink.getMatches()) {
                replacements.add(replacer.buildReplacement(result2));
            }
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = sourceIsFile ? 0 : parent.getTextLength() - lastElement.getTextRange().getEndOffset();
            PsiElement prevSibling = firstElement.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                startOffset -= prevSibling.getTextLength();
            }
            if ((nextSibling = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                endOffset -= nextSibling.getTextLength();
            }
            replacer.replaceAll((List<? extends ReplacementInfo>)replacements);
            if (firstElement == lastElement && firstElement instanceof PsiFile) {
                String string = firstElement.getText();
                return string;
            }
            String result3 = parent.getText();
            String string = result3.substring(startOffset, result3.length() - endOffset);
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        finally {
            matchOptions.setScope(null);
        }
    }

    public void replaceAll(List<? extends ReplacementInfo> infos) {
        for (ReplacementInfo replacementInfo : infos) {
            this.replaceHandler.prepare(replacementInfo);
        }
        ((ApplicationEx)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.project, null, indicator2 -> {
            indicator2.setIndeterminate(false);
            try {
                int size2 = infos.size();
                VirtualFile lastFile = null;
                for (int i2 = 0; i2 < size2; ++i2) {
                    indicator2.checkCanceled();
                    indicator2.setFraction((double)((float)(i2 + 1) / (float)size2));
                    ReplacementInfo info2 = (ReplacementInfo)infos.get(i2);
                    PsiElement element2 = info2.getMatch(0);
                    if (element2 == null) continue;
                    VirtualFile vFile = element2.getContainingFile().getVirtualFile();
                    if (vFile != null && !vFile.equals(lastFile)) {
                        indicator2.setText2(vFile.getPresentableUrl());
                        lastFile = vFile;
                    }
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        PsiElement affectedElement = this.doReplace(info2);
                        if (affectedElement != this.lastAffectedElement) {
                            if (this.lastAffectedElement != null) {
                                this.reformatAndPostProcess(this.lastAffectedElement);
                            }
                            this.lastAffectedElement = affectedElement;
                        }
                    });
                }
            }
            finally {
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.reformatAndPostProcess(this.lastAffectedElement));
            }
        });
    }

    public void replace(@NotNull ReplacementInfo info2) {
        if (info2 == null) {
            Replacer.$$$reportNull$$$0(4);
        }
        this.replaceHandler.prepare(info2);
        this.reformatAndPostProcess(this.doReplace(info2));
    }

    @Nullable
    private PsiElement doReplace(@NotNull ReplacementInfo info2) {
        PsiElement element2;
        if (info2 == null) {
            Replacer.$$$reportNull$$$0(5);
        }
        if ((element2 = info2.getMatch(0)) == null || !element2.isWritable() || !element2.isValid()) {
            return null;
        }
        PsiElement elementParent = StructuralSearchUtil.getPresentableElement(element2).getParent();
        CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(() -> this.replaceHandler.replace(info2, this.options));
        if (!elementParent.isValid() || !elementParent.isWritable()) {
            return null;
        }
        return elementParent;
    }

    private void reformatAndPostProcess(PsiElement elementParent) {
        if (elementParent == null || !elementParent.isValid()) {
            return;
        }
        PsiFile containingFile = elementParent.getContainingFile();
        if (containingFile != null && this.options.isToReformatAccordingToStyle()) {
            Document document;
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 != null && (document = FileDocumentManager.getInstance().getDocument(file2)) != null) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(document);
            }
            int parentOffset = elementParent.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.project).reformatRange((PsiElement)containingFile, parentOffset, parentOffset + elementParent.getTextLength(), true);
        }
        this.replaceHandler.postProcess(elementParent, this.options);
    }

    public static void handleComments(PsiElement el, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement firstChild;
        PsiElement lastChild = el.getLastChild();
        if (lastChild instanceof PsiComment && replacementInfo.getVariableName(lastChild) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            PsiElement firstElementAfterStatementEnd = lastChild;
            for (PsiElement curElement = firstElementAfterStatementEnd.getPrevSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getPrevSibling()) {
                firstElementAfterStatementEnd = curElement;
            }
            replacement.addRangeAfter(firstElementAfterStatementEnd, lastChild, replacement.getLastChild());
        }
        if ((firstChild = el.getFirstChild()) instanceof PsiComment && !(firstChild instanceof PsiDocCommentBase) && replacementInfo.getVariableName(firstChild) == null) {
            PsiElement lastElementBeforeStatementStart = firstChild;
            for (PsiElement curElement = lastElementBeforeStatementStart.getNextSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getNextSibling()) {
                lastElementBeforeStatementStart = curElement;
            }
            replacement.addRangeBefore(firstChild, lastElementBeforeStatementStart, replacement.getFirstChild());
        }
    }

    public static void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options2) {
        if (project == null) {
            Replacer.$$$reportNull$$$0(6);
        }
        if (options2 == null) {
            Replacer.$$$reportNull$$$0(7);
        }
        try {
            String search2 = options2.getMatchOptions().getSearchPattern();
            String replacement = options2.getReplacement();
            Template searchTemplate = TemplateManager.getInstance(project).createTemplate("", "", search2);
            Template replaceTemplate = TemplateManager.getInstance(project).createTemplate("", "", replacement);
            int segmentCount = replaceTemplate.getSegmentsCount();
            for (int i2 = 0; i2 < segmentCount; ++i2) {
                String searchSegmentName;
                int j;
                String replacementSegmentName = replaceTemplate.getSegmentName(i2);
                int segmentCount2 = searchTemplate.getSegmentsCount();
                for (j = 0; j < segmentCount2 && !replacementSegmentName.equals(searchSegmentName = searchTemplate.getSegmentName(j)); ++j) {
                    if (!replacementSegmentName.startsWith(searchSegmentName) || replacementSegmentName.charAt(searchSegmentName.length()) != '_') continue;
                    try {
                        Integer.parseInt(replacementSegmentName.substring(searchSegmentName.length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (j != segmentCount2) continue;
                ReplacementVariableDefinition definition = options2.getVariableDefinition(replacementSegmentName);
                if (definition == null || definition.getScriptCodeConstraint().length() <= 2) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", replacementSegmentName));
                }
                String message2 = ScriptSupport.checkValidScript(StringUtil.unquoteString((String)definition.getScriptCodeConstraint()), options2.getMatchOptions());
                if (message2 == null) continue;
                throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.valid", replacementSegmentName, message2));
            }
            LanguageFileType fileType = options2.getMatchOptions().getFileType();
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            if (profile != null) {
                ReadAction.run(() -> profile.checkReplacementPattern(project, options2));
            }
        }
        catch (IncorrectOperationException ex) {
            throw new MalformedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    @NotNull
    public ReplacementInfo buildReplacement(@NotNull MatchResult result2) {
        if (result2 == null) {
            Replacer.$$$reportNull$$$0(8);
        }
        ReplacementInfoImpl replacementInfo = new ReplacementInfoImpl(result2, this.project);
        LanguageFileType fileType = this.options.getMatchOptions().getFileType();
        assert (fileType != null);
        replacementInfo.setReplacement(this.replacementBuilder.process(result2, replacementInfo, fileType));
        ReplacementInfoImpl replacementInfoImpl = replacementInfo;
        if (replacementInfoImpl == null) {
            Replacer.$$$reportNull$$$0(9);
        }
        return replacementInfoImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/impl/Replacer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/impl/Replacer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildReplacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "testReplace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doReplace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

