/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSchemeColorPalette;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.messages.MessageBusConnection;
import com.jediterm.terminal.emulator.ColorPalette;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TerminalUiSettingsManager", storages={@Storage(value="other.xml")})
@Service(value={Service.Level.APP})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003+,-B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0001J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020\u0014J\b\u0010$\u001a\u00020\u0002H\u0016J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0006\u0010(\u001a\u00020\u001aJ\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/terminal/TerminalUiSettingsManager$State;", "Lcom/intellij/openapi/Disposable;", "()V", "cachedColorPalette", "Lcom/intellij/terminal/JBTerminalSchemeColorPalette;", "value", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "cursorShape", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "<set-?>", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "editorColorsScheme", "getEditorColorsScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "fontSize", "", "state", "terminalPanels", "", "Lcom/intellij/terminal/JBTerminalPanel;", "addListener", "", "terminalPanel", "detectFontSize", "dispose", "fireCursorUpdate", "fireFontChanged", "getDefaultBackground", "Ljava/awt/Color;", "getDefaultForeground", "getFontSize", "getState", "getTerminalColorPalette", "Lcom/jediterm/terminal/emulator/ColorPalette;", "loadState", "resetFontSize", "setFontSize", "newFontSize", "Companion", "CursorShape", "State", "intellij.platform.execution.impl"})
public final class TerminalUiSettingsManager
implements PersistentStateComponent<State>,
Disposable {
    @NotNull
    private EditorColorsScheme editorColorsScheme;
    private JBTerminalSchemeColorPalette cachedColorPalette;
    private int fontSize = -1;
    private final List<JBTerminalPanel> terminalPanels = new CopyOnWriteArrayList();
    private State state = new State();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EditorColorsScheme getEditorColorsScheme() {
        return this.editorColorsScheme;
    }

    @NotNull
    public final ColorPalette getTerminalColorPalette() {
        JBTerminalSchemeColorPalette palette = this.cachedColorPalette;
        if (palette == null) {
            this.cachedColorPalette = palette = new JBTerminalSchemeColorPalette(this.editorColorsScheme);
        }
        return palette;
    }

    @NotNull
    public final Color getDefaultForeground() {
        TextAttributes textAttributes = this.editorColorsScheme.getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"editorColorsScheme.getAt\u2026ntType.NORMAL_OUTPUT_KEY)");
        Color foregroundColor = textAttributes.getForegroundColor();
        Color color = foregroundColor;
        if (color == null) {
            Color color2 = this.editorColorsScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"editorColorsScheme.defaultForeground");
        }
        return color;
    }

    @NotNull
    public final Color getDefaultBackground() {
        Color backgroundColor = this.editorColorsScheme.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
        Color color = backgroundColor;
        if (color == null) {
            Color color2 = this.editorColorsScheme.getDefaultBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"editorColorsScheme.defaultBackground");
        }
        return color;
    }

    @JvmName(name="addListener")
    public final void addListener(@NotNull JBTerminalPanel terminalPanel) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        this.terminalPanels.add(terminalPanel);
        Disposer.register((Disposable)terminalPanel, (Disposable)new Disposable(this, terminalPanel){
            final /* synthetic */ TerminalUiSettingsManager this$0;
            final /* synthetic */ JBTerminalPanel $terminalPanel;

            public final void dispose() {
                TerminalUiSettingsManager.access$getTerminalPanels$p(this.this$0).remove(this.$terminalPanel);
            }
            {
                this.this$0 = terminalUiSettingsManager;
                this.$terminalPanel = jBTerminalPanel;
            }
        });
    }

    @NotNull
    public final CursorShape getCursorShape() {
        return this.state.getCursorShape();
    }

    public final void setCursorShape(@NotNull CursorShape value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.state.setCursorShape(value2);
        this.fireCursorUpdate();
    }

    private final void fireCursorUpdate() {
        for (JBTerminalPanel panel2 : this.terminalPanels) {
            JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase = panel2.getSettingsProvider();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jBTerminalSystemSettingsProviderBase), (String)"panel.settingsProvider");
            panel2.setCursorShape(jBTerminalSystemSettingsProviderBase.getCursorShape());
            panel2.repaint();
        }
    }

    private final void fireFontChanged() {
        for (JBTerminalPanel panel2 : this.terminalPanels) {
            panel2.fontChanged();
        }
    }

    public final int getFontSize() {
        if (this.fontSize <= 0) {
            this.fontSize = this.detectFontSize();
        }
        return this.fontSize;
    }

    public final void setFontSize(int newFontSize) {
        int prevFontSize = this.fontSize;
        this.fontSize = newFontSize;
        if (prevFontSize != this.fontSize) {
            this.fireFontChanged();
        }
    }

    private final int detectFontSize() {
        return UISettings.Companion.getInstance().getPresentationMode() ? UISettings.Companion.getInstance().getPresentationModeFontSize() : this.editorColorsScheme.getConsoleFontSize();
    }

    public final void resetFontSize() {
        this.setFontSize(this.detectFontSize());
    }

    public void dispose() {
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    public TerminalUiSettingsManager() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        this.editorColorsScheme = editorColorsScheme;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection2 = application.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"ApplicationManager.getAp\u2026.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection2;
        connection.subscribe(UISettingsListener.TOPIC, (Object)new UISettingsListener(){

            public final void uiSettingsChanged(@NotNull UISettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.resetFontSize();
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public final void globalSchemeChange(@Nullable EditorColorsScheme scheme2) {
                EditorColorsScheme editorColorsScheme = scheme2;
                if (editorColorsScheme == null) {
                    EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
                    EditorColorsScheme editorColorsScheme2 = editorColorsManager.getGlobalScheme();
                    editorColorsScheme = editorColorsScheme2;
                    Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"EditorColorsManager.getInstance().globalScheme");
                }
                editorColorsScheme = editorColorsScheme;
                cachedColorPalette = null;
                this.resetFontSize();
            }
        });
        connection.subscribe(EditorOptionsListener.APPEARANCE_CONFIGURABLE_TOPIC, (Object)new EditorOptionsListener(){

            @Override
            public final void changesApplied() {
                this.fireCursorUpdate();
            }
        });
    }

    public static final /* synthetic */ List access$getTerminalPanels$p(TerminalUiSettingsManager $this) {
        return $this.terminalPanels;
    }

    public static final /* synthetic */ EditorColorsScheme access$getEditorColorsScheme$p(TerminalUiSettingsManager $this) {
        return $this.editorColorsScheme;
    }

    public static final /* synthetic */ JBTerminalSchemeColorPalette access$getCachedColorPalette$p(TerminalUiSettingsManager $this) {
        return $this.cachedColorPalette;
    }

    @JvmStatic
    @NotNull
    public static final TerminalUiSettingsManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0014\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "", "text", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;ILjava/lang/String;)V", "getText", "()Ljava/lang/String;", "BLOCK", "UNDERLINE", "VERTICAL", "intellij.platform.execution.impl"})
    public static final class CursorShape
    extends Enum<CursorShape> {
        public static final /* enum */ CursorShape BLOCK;
        public static final /* enum */ CursorShape UNDERLINE;
        public static final /* enum */ CursorShape VERTICAL;
        private static final /* synthetic */ CursorShape[] $VALUES;
        @NotNull
        private final String text;

        static {
            CursorShape[] cursorShapeArray = new CursorShape[3];
            CursorShape[] cursorShapeArray2 = cursorShapeArray;
            String string = IdeBundle.message((String)"terminal.cursor.shape.block.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"termi\u2026cursor.shape.block.name\")");
            cursorShapeArray[0] = BLOCK = new CursorShape(string);
            String string2 = IdeBundle.message((String)"terminal.cursor.shape.underline.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"termi\u2026or.shape.underline.name\")");
            cursorShapeArray[1] = UNDERLINE = new CursorShape(string2);
            String string3 = IdeBundle.message((String)"terminal.cursor.shape.vertical.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"termi\u2026sor.shape.vertical.name\")");
            cursorShapeArray[2] = VERTICAL = new CursorShape(string3);
            $VALUES = cursorShapeArray;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        private CursorShape(String text2) {
            this.text = text2;
        }

        public static CursorShape[] values() {
            return (CursorShape[])$VALUES.clone();
        }

        public static CursorShape valueOf(String string) {
            return Enum.valueOf(CursorShape.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager$State;", "", "()V", "cursorShape", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "intellij.platform.execution.impl"})
    public static final class State {
        @NotNull
        private CursorShape cursorShape = CursorShape.BLOCK;

        @NotNull
        public final CursorShape getCursorShape() {
            return this.cursorShape;
        }

        public final void setCursorShape(@NotNull CursorShape cursorShape) {
            Intrinsics.checkNotNullParameter((Object)((Object)cursorShape), (String)"<set-?>");
            this.cursorShape = cursorShape;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/terminal/TerminalUiSettingsManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/terminal/TerminalUiSettingsManager;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TerminalUiSettingsManager getInstance() {
            boolean $i$f$service = false;
            Class<TerminalUiSettingsManager> serviceClass$iv = TerminalUiSettingsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (TerminalUiSettingsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

