/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FinderRecursivePanel<T>
extends OnePixelSplitter
implements DataProvider,
UserDataHolder,
Disposable {
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myGroupId;
    @Nullable
    private final FinderRecursivePanel<?> myParent;
    @Nullable
    private JComponent myChild;
    private boolean myNonBlockingLoad;
    protected JBList<T> myList;
    protected final CollectionListModel<T> myListModel;
    private final MergingUpdateQueue myMergingUpdateQueue;
    private volatile boolean isMergeListItemsRunning;
    private final AtomicBoolean myUpdateSelectedPathModeActive;
    private final Object myUpdateCoalesceKey;
    private final CopyProvider myCopyProvider;
    private final UserDataHolderBase myUserDataHolder;

    protected FinderRecursivePanel(@NotNull FinderRecursivePanel<?> parent) {
        if (parent == null) {
            FinderRecursivePanel.$$$reportNull$$$0(0);
        }
        this(parent.getProject(), parent, parent.getGroupId());
    }

    protected FinderRecursivePanel(@NotNull Project project, @Nullable String groupId2) {
        if (project == null) {
            FinderRecursivePanel.$$$reportNull$$$0(1);
        }
        this(project, null, groupId2);
    }

    protected FinderRecursivePanel(@NotNull Project project, @Nullable FinderRecursivePanel<?> parent, @Nullable String groupId2) {
        if (project == null) {
            FinderRecursivePanel.$$$reportNull$$$0(2);
        }
        super(false, 0.0f);
        this.myChild = null;
        this.myNonBlockingLoad = false;
        this.myListModel = new CollectionListModel(new Object[0]);
        this.myMergingUpdateQueue = new MergingUpdateQueue("FinderRecursivePanel", 100, true, (JComponent)((Object)this), (Disposable)this);
        this.myUpdateSelectedPathModeActive = new AtomicBoolean();
        this.myUpdateCoalesceKey = new Object();
        this.myCopyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                Object value2;
                if (dataContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((value2 = FinderRecursivePanel.this.getSelectedValue()) != null) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(FinderRecursivePanel.this.getItemText(value2)));
                }
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                return FinderRecursivePanel.this.getSelectedValue() != null;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataContext";
                objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myUserDataHolder = new UserDataHolderBase();
        this.myProject = project;
        this.myParent = parent;
        this.myGroupId = groupId2;
        if (this.myParent != null) {
            Disposer.register(this.myParent, (Disposable)this);
        }
    }

    protected boolean isNonBlockingLoad() {
        return this.myNonBlockingLoad;
    }

    protected void setNonBlockingLoad(boolean nonBlockingLoad) {
        this.myNonBlockingLoad = nonBlockingLoad;
    }

    public void initPanel() {
        this.initWithoutUpdatePanel();
        this.updatePanel();
    }

    private void initWithoutUpdatePanel() {
        this.setFirstComponent(this.createLeftComponent());
        this.setSecondComponent(this.createDefaultRightComponent());
        if (this.getGroupId() != null) {
            this.setAndLoadSplitterProportionKey(this.getGroupId() + "[" + this.getIndex() + "]");
        }
    }

    @NotNull
    protected abstract List<T> getListItems();

    @Nls
    protected String getListEmptyText() {
        return IdeBundle.message((String)"empty.text.no.entries", (Object[])new Object[0]);
    }

    @NotNull
    @Nls
    protected abstract String getItemText(@NotNull T var1);

    @Nullable
    protected Icon getItemIcon(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    @NlsContexts.Tooltip
    protected String getItemTooltipText(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return null;
    }

    protected abstract boolean hasChildren(@NotNull T var1);

    @Nullable
    protected VirtualFile getContainingFile(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(5);
        }
        return null;
    }

    protected boolean isEditable() {
        return this.getSelectedValue() != null;
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull T t) {
        if (t == null) {
            FinderRecursivePanel.$$$reportNull$$$0(6);
        }
        return new JPanel();
    }

    @Nullable
    protected JComponent createDefaultRightComponent() {
        return new JBPanelWithEmptyText().withEmptyText(IdeBundle.message((String)"empty.text.nothing.selected", (Object[])new Object[0]));
    }

    protected JComponent createLeftComponent() {
        this.myList = this.createList();
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane(this.myList, (int)20, (int)31);
        return ListWithFilter.wrap(this.myList, (JScrollPane)pane2, o -> this.getItemText(o));
    }

    protected JBList<T> createList() {
        JBList list2 = new JBList(this.myListModel);
        list2.setSelectionMode(0);
        list2.setEmptyText(this.getListEmptyText());
        list2.setCellRenderer(this.createListCellRenderer());
        if (this.hasFixedSizeListElements()) {
            list2.setFixedCellHeight(JBUIScale.scale((int)20));
            list2.setFixedCellWidth(list2.getWidth());
        }
        this.installListActions(list2);
        list2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                if (FinderRecursivePanel.this.isMergeListItemsRunning()) {
                    return;
                }
                if (FinderRecursivePanel.this.myUpdateSelectedPathModeActive.get()) {
                    return;
                }
                FinderRecursivePanel.this.updateRightComponent(true);
            }
        });
        ScrollingUtil.installActions((JList)list2);
        this.installEditOnDoubleClick(list2);
        return list2;
    }

    private void handleGotoPrevious() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myList, true);
    }

    private void handleGotoNext() {
        if (!this.myList.isEmpty() && this.myList.getSelectedValue() == null) {
            this.myList.setSelectedIndex(0);
            this.updateRightComponent(true);
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myList, true);
    }

    private void installListActions(JBList list2) {
        AnAction previousPanelAction = new AnAction(IdeBundle.messagePointer((String)"action.FinderRecursivePanel.text.previous", (Object[])new Object[0]), AllIcons.Actions.Back){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!FinderRecursivePanel.this.isRootPanel());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                assert (FinderRecursivePanel.this.myParent != null);
                FinderRecursivePanel.this.myParent.handleGotoPrevious();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        previousPanelAction.registerCustomShortcutSet(37, 0, (JComponent)list2);
        AnAction nextPanelAction = new AnAction(IdeBundle.messagePointer((String)"action.FinderRecursivePanel.text.next", (Object[])new Object[0]), AllIcons.Actions.Forward){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                Object value2 = FinderRecursivePanel.this.getSelectedValue();
                e.getPresentation().setEnabled(value2 != null && FinderRecursivePanel.this.hasChildren(value2) && FinderRecursivePanel.this.getSecondComponent() instanceof FinderRecursivePanel);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                FinderRecursivePanel finderRecursivePanel = (FinderRecursivePanel)((Object)FinderRecursivePanel.this.getSecondComponent());
                finderRecursivePanel.handleGotoNext();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        nextPanelAction.registerCustomShortcutSet(39, 0, (JComponent)list2);
        AnAction editAction = new AnAction(IdeBundle.messagePointer((String)"action.FinderRecursivePanel.text.edit", (Object[])new Object[0]), AllIcons.Actions.Edit){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(FinderRecursivePanel.this.isEditable());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                FinderRecursivePanel.this.performEditAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/FinderRecursivePanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        editAction.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)list2);
        Object[] actions2 = new AnAction[]{previousPanelAction, nextPanelAction, Separator.getInstance(), editAction};
        Object[] customActions = this.getCustomListActions();
        if (customActions.length > 0) {
            actions2 = (AnAction[])ArrayUtil.append((Object[])actions2, (Object)Separator.getInstance());
            actions2 = (AnAction[])ArrayUtil.mergeArrays((Object[])actions2, (Object[])customActions);
        }
        DefaultActionGroup contextActionGroup = new DefaultActionGroup((AnAction[])actions2);
        PopupHandler.installPopupMenu((JComponent)list2, (ActionGroup)contextActionGroup, (String)"FinderPopup");
    }

    protected AnAction[] getCustomListActions() {
        return AnAction.EMPTY_ARRAY;
    }

    private void installSpeedSearch(JBList list2) {
        ListSpeedSearch search2 = new ListSpeedSearch(list2, o -> this.getItemText(o));
        search2.setComparator(new SpeedSearchComparator(false));
    }

    private void installEditOnDoubleClick(JBList list2) {
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                FinderRecursivePanel.this.performEditAction();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/FinderRecursivePanel$6", "onDoubleClick"));
            }
        }.installOn((Component)list2);
    }

    protected boolean performEditAction() {
        Navigatable data2 = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext(this.myList));
        if (data2 != null && data2.canNavigate()) {
            data2.navigate(true);
        }
        return false;
    }

    protected ListCellRenderer<T> createListCellRenderer() {
        return new MyListCellRenderer();
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent comp, @NotNull JList list2, @NotNull T value2, int index2, boolean selected2, boolean hasFocus) {
        if (comp == null) {
            FinderRecursivePanel.$$$reportNull$$$0(7);
        }
        if (list2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(9);
        }
    }

    protected boolean hasFixedSizeListElements() {
        return true;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        T selectedValue;
        if (dataId == null) {
            FinderRecursivePanel.$$$reportNull$$$0(10);
        }
        if ((selectedValue = this.getSelectedValue()) == null) {
            return null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && selectedValue instanceof PsiElement) {
            return selectedValue;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && selectedValue instanceof Navigatable) {
            return selectedValue;
        }
        if (LangDataKeys.MODULE.is(dataId) && selectedValue instanceof Module) {
            return selectedValue;
        }
        if (selectedValue instanceof DataProvider && (!(selectedValue instanceof ValidateableNode) || ((ValidateableNode)selectedValue).isValid())) {
            return ((DataProvider)selectedValue).getData(dataId);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        return null;
    }

    @Nullable
    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            FinderRecursivePanel.$$$reportNull$$$0(11);
        }
        return (U)this.myUserDataHolder.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, @Nullable U value2) {
        if (key == null) {
            FinderRecursivePanel.$$$reportNull$$$0(12);
        }
        this.myUserDataHolder.putUserData(key, value2);
    }

    public void dispose() {
        super.dispose();
        this.myMergingUpdateQueue.cancelAllUpdates();
    }

    protected boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this);
    }

    @Nullable
    public T getSelectedValue() {
        return (T)this.myList.getSelectedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectedPath(Object ... pathToSelect) {
        if (!this.myUpdateSelectedPathModeActive.compareAndSet(false, true)) {
            return;
        }
        try {
            FinderRecursivePanel panel2 = this;
            for (int i2 = 0; i2 < pathToSelect.length; ++i2) {
                Object selectedValue = pathToSelect[i2];
                panel2.setSelectedValue(selectedValue);
                if (i2 >= pathToSelect.length - 1) continue;
                JComponent component2 = panel2.getSecondComponent();
                if (!(component2 instanceof FinderRecursivePanel)) {
                    throw new IllegalStateException("failed to select idx=" + (i2 + 1) + ": component=" + component2 + ", pathToSelect=" + Arrays.toString(pathToSelect));
                }
                panel2 = (FinderRecursivePanel)((Object)component2);
            }
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(panel2.myList, true);
        }
        finally {
            this.myUpdateSelectedPathModeActive.set(false);
        }
    }

    private void setSelectedValue(Object value2) {
        if (value2.equals(this.myList.getSelectedValue())) {
            return;
        }
        this.myList.setPaintBusy(true);
        try {
            List listItems = (List)ReadAction.compute(() -> this.getListItems());
            this.mergeListItems(this.myListModel, (JList<? extends T>)this.myList, listItems);
        }
        finally {
            this.myList.setPaintBusy(false);
        }
        this.myList.setSelectedValue(value2, true);
        this.createRightComponent(false);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FinderRecursivePanel.$$$reportNull$$$0(13);
        }
        return project;
    }

    @Nullable
    public FinderRecursivePanel<?> getParentPanel() {
        return this.myParent;
    }

    @Nullable
    protected String getGroupId() {
        return this.myGroupId;
    }

    public void updatePanel() {
        if (this.myUpdateSelectedPathModeActive.get()) {
            return;
        }
        this.myList.setPaintBusy(true);
        this.myMergingUpdateQueue.queue(Update.create((Object)"update", () -> {
            T oldValue = this.getSelectedValue();
            int oldIndex = this.myList.getSelectedIndex();
            if (this.myNonBlockingLoad) {
                this.scheduleUpdateNonBlocking(oldValue, oldIndex);
            } else {
                this.scheduleUpdateBlocking(oldValue, oldIndex);
            }
        }));
    }

    private void scheduleUpdateBlocking(T oldSelectedValue, int oldSelectedIndex) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            try {
                List<T> listItems = this.getListItems();
                ApplicationManager.getApplication().invokeLater(() -> this.updateList(oldSelectedValue, oldSelectedIndex, listItems));
            }
            finally {
                this.myList.setPaintBusy(false);
            }
        }));
    }

    private void scheduleUpdateNonBlocking(T oldSelectedValue, int oldSelectedIndex) {
        ReadAction.nonBlocking(this::getListItems).finishOnUiThread(ModalityState.any(), listItems -> {
            try {
                this.updateList(oldSelectedValue, oldSelectedIndex, (List<T>)listItems);
            }
            finally {
                this.myList.setPaintBusy(false);
            }
        }).coalesceBy(new Object[]{this.myUpdateCoalesceKey}).expireWith((Disposable)this).inSmartMode(this.myProject).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void updateList(T oldValue, int oldIndex, List<T> listItems) {
        this.mergeListItems(this.myListModel, (JList<? extends T>)this.myList, (List<? extends T>)listItems);
        if (this.myList.isEmpty()) {
            this.createRightComponent(true);
        } else if (this.myList.getSelectedIndex() < 0) {
            this.myList.setSelectedIndex(this.myListModel.getSize() > oldIndex ? oldIndex : 0);
        } else {
            Object newValue2 = this.myList.getSelectedValue();
            this.updateRightComponent(oldValue == null || !oldValue.equals(newValue2) || this.myList.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeListItems(@NotNull CollectionListModel<T> listModel, @NotNull JList<? extends T> list2, @NotNull List<? extends T> newItems) {
        if (listModel == null) {
            FinderRecursivePanel.$$$reportNull$$$0(14);
        }
        if (list2 == null) {
            FinderRecursivePanel.$$$reportNull$$$0(15);
        }
        if (newItems == null) {
            FinderRecursivePanel.$$$reportNull$$$0(16);
        }
        this.setMergeListItemsRunning(true);
        try {
            if (listModel.getSize() == 0) {
                listModel.add(newItems);
            } else if (newItems.size() == 0) {
                listModel.removeAll();
            } else {
                int newSelectedIndex = -1;
                T selection = list2.getSelectedValue();
                if (selection != null) {
                    newSelectedIndex = newItems.indexOf(selection);
                }
                listModel.removeAll();
                listModel.add(newItems);
                list2.setSelectedIndex(newSelectedIndex);
            }
        }
        finally {
            this.setMergeListItemsRunning(false);
        }
    }

    public boolean isMergeListItemsRunning() {
        return this.isMergeListItemsRunning;
    }

    protected void setMergeListItemsRunning(boolean isListMergeRunning) {
        this.isMergeListItemsRunning = isListMergeRunning;
    }

    public void updateRightComponent(boolean force) {
        if (force) {
            this.createRightComponent(true);
        } else if (this.myChild instanceof FinderRecursivePanel) {
            ((FinderRecursivePanel)((Object)this.myChild)).updatePanel();
        }
    }

    private void createRightComponent(boolean withUpdatePanel) {
        T value2;
        if (this.myChild instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myChild));
        }
        if ((value2 = this.getSelectedValue()) != null) {
            this.myChild = this.createRightComponent(value2);
            if (this.myChild instanceof FinderRecursivePanel) {
                FinderRecursivePanel childPanel = (FinderRecursivePanel)((Object)this.myChild);
                if (withUpdatePanel) {
                    childPanel.initPanel();
                } else {
                    childPanel.initWithoutUpdatePanel();
                }
            }
        } else {
            this.myChild = this.createDefaultRightComponent();
        }
        this.setSecondComponent(this.myChild);
    }

    private int getIndex() {
        int index2 = 0;
        for (FinderRecursivePanel<?> parent = this.myParent; parent != null; parent = parent.getParentPanel()) {
            ++index2;
        }
        return index2;
    }

    protected boolean isRootPanel() {
        return this.getParentPanel() == null;
    }

    public void doLayout() {
        if (this.myProportion == 0.0f) {
            int total = this.getOrientation() ? this.getHeight() : this.getWidth();
            float proportion = (float)this.getFirstComponentPreferredSize() / (float)(total - this.getDividerWidth());
            if (proportion > 0.0f && proportion < 1.0f) {
                this.setProportion(proportion);
            }
        }
        super.doLayout();
    }

    protected int getFirstComponentPreferredSize() {
        return 200;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/FinderRecursivePanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listModel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/FinderRecursivePanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemTooltipText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeListItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DisposablePanel
    extends JPanel
    implements Disposable {
        public DisposablePanel(LayoutManager layout, @Nullable Disposable parent) {
            super(layout);
            if (parent != null) {
                Disposer.register((Disposable)parent, (Disposable)this);
            }
        }

        public void dispose() {
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<T> {
        @NonNls
        private static final String ITEM_PROPERTY = "FINDER_RECURSIVE_PANEL_ITEM_PROPERTY";

        private MyListCellRenderer() {
        }

        public String getToolTipText(MouseEvent event) {
            String toolTipText = super.getToolTipText(event);
            if (toolTipText != null) {
                return toolTipText;
            }
            Object value2 = this.getClientProperty(ITEM_PROPERTY);
            return FinderRecursivePanel.this.getItemTooltipText(value2);
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
            this.mySelected = isSelected;
            this.myForeground = UIUtil.getTreeForeground();
            this.mySelectionForeground = cellHasFocus ? list2.getSelectionForeground() : UIUtil.getTreeForeground();
            this.clear();
            this.setFont(UIUtil.getListFont());
            Object t = value2;
            try {
                this.putClientProperty(ITEM_PROPERTY, t);
                this.setIcon(FinderRecursivePanel.this.getItemIcon(t));
                this.append(FinderRecursivePanel.this.getItemText(t));
            }
            catch (IndexNotReadyException e) {
                this.append(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
            }
            try {
                FinderRecursivePanel.this.doCustomizeCellRenderer((SimpleColoredComponent)this, list2, t, index2, isSelected, cellHasFocus);
            }
            catch (IndexNotReadyException e) {
                // empty catch block
            }
            Color bg = UIUtil.getTreeBackground((boolean)isSelected, (boolean)cellHasFocus);
            if (!isSelected) {
                VirtualFile file2 = FinderRecursivePanel.this.getContainingFile(t);
                Color bgColor = file2 == null ? null : VfsPresentationUtil.getFileBackgroundColor(FinderRecursivePanel.this.myProject, file2);
                bg = bgColor == null ? bg : bgColor;
            }
            this.setBackground(bg);
            if (FinderRecursivePanel.this.hasChildren(t)) {
                MyListCellRenderer rendererComponent = this;
                JPanel result2 = new JPanel(new BorderLayout(), (JComponent)((Object)rendererComponent)){
                    final /* synthetic */ JComponent val$rendererComponent;
                    {
                        this.val$rendererComponent = jComponent;
                        super(arg0);
                    }

                    @Override
                    public String getToolTipText(MouseEvent event) {
                        return this.val$rendererComponent.getToolTipText(event);
                    }
                };
                JLabel childrenLabel = new JLabel();
                childrenLabel.setOpaque(true);
                childrenLabel.setVisible(true);
                childrenLabel.setBackground(bg);
                boolean isDark = ColorUtil.isDark((Color)UIUtil.getListSelectionBackground((boolean)true));
                childrenLabel.setIcon(isDark ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep);
                result2.add((Component)((Object)this), "Center");
                result2.add((Component)childrenLabel, "East");
                return result2;
            }
            return this;
        }

        protected final void customizeCellRenderer(@NotNull JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/FinderRecursivePanel$MyListCellRenderer", "customizeCellRenderer"));
        }
    }
}

