/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SystemTrayNotifications
implements SystemNotificationsImpl.Notifier {
    private static SystemTrayNotifications ourWin10Instance;
    private final TrayIcon myTrayIcon;
    private final TrayIcon.MessageType myType;

    @Nullable
    static synchronized SystemTrayNotifications getWin10Instance() throws AWTException {
        if (ourWin10Instance == null && SystemTray.isSupported()) {
            ourWin10Instance = new SystemTrayNotifications(SystemTrayNotifications.createImage(), TrayIcon.MessageType.INFO);
        }
        return ourWin10Instance;
    }

    @NotNull
    private static Image createImage() {
        Icon icon2 = AppUIUtil.loadSmallApplicationIcon(ScaleContext.create());
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)IconUtil.toImage(icon2));
        if (bufferedImage == null) {
            SystemTrayNotifications.$$$reportNull$$$0(0);
        }
        return bufferedImage;
    }

    private SystemTrayNotifications(@NotNull Image image, @NotNull TrayIcon.MessageType type) throws AWTException {
        if (image == null) {
            SystemTrayNotifications.$$$reportNull$$$0(1);
        }
        if (type == null) {
            SystemTrayNotifications.$$$reportNull$$$0(2);
        }
        this.myType = type;
        String tooltip2 = ApplicationInfoImpl.getShadowInstance().getFullApplicationName();
        this.myTrayIcon = new TrayIcon(image, tooltip2);
        this.myTrayIcon.setImageAutoSize(true);
        SystemTray.getSystemTray().add(this.myTrayIcon);
        this.myTrayIcon.addActionListener(e -> {
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (frame instanceof Window) {
                UIUtil.toFront((Window)((Window)frame));
            }
        });
    }

    @Override
    public void notify(@NotNull String name, @NotNull String title2, @NotNull String description2) {
        if (name == null) {
            SystemTrayNotifications.$$$reportNull$$$0(3);
        }
        if (title2 == null) {
            SystemTrayNotifications.$$$reportNull$$$0(4);
        }
        if (description2 == null) {
            SystemTrayNotifications.$$$reportNull$$$0(5);
        }
        this.myTrayIcon.displayMessage(title2, description2, this.myType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SystemTrayNotifications";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SystemTrayNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

