/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.colorpicker.ColorPickerModelKt;
import com.intellij.ui.colorpicker.ColorPipette;
import com.intellij.ui.picker.ColorListener;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0010J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010+\u001a\u00020$J\u001a\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00032\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u0001J\u0006\u00101\u001a\u00020*J\u000e\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u0003J\u000e\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020\u0003J\u0006\u00106\u001a\u00020*J\u0006\u00107\u001a\u00020*J\u000e\u00108\u001a\u00020*2\u0006\u0010+\u001a\u00020!J\u000e\u00109\u001a\u00020\u00102\u0006\u0010+\u001a\u00020$J\u001a\u0010:\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00032\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\bR\u0011\u0010'\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000e\u00a8\u0006;"}, d2={"Lcom/intellij/ui/colorpicker/ColorPickerModel;", "", "originalColor", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "alpha", "", "getAlpha", "()I", "blue", "getBlue", "brightness", "", "getBrightness", "()F", "changedByUser", "", "<set-?>", "color", "getColor", "()Ljava/awt/Color;", "green", "getGreen", "hex", "", "getHex", "()Ljava/lang/String;", "hsb", "", "hue", "getHue", "instantListeners", "", "Lcom/intellij/ui/picker/ColorListener;", "listeners", "pipetteListeners", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "red", "getRed", "saturation", "getSaturation", "addListener", "", "listener", "invokeOnEveryColorChange", "addPipetteListener", "applyColorToSource", "newColor", "source", "firePipetteCancelled", "firePipettePicked", "pickedColor", "firePipetteUpdated", "updatedColor", "onCancel", "onClose", "removeListener", "removePipetteListener", "setColor", "intellij.platform.ide.impl"})
public final class ColorPickerModel {
    private final Set<ColorListener> listeners;
    private final Set<ColorPipette.Callback> pipetteListeners;
    private final Set<ColorListener> instantListeners;
    private boolean changedByUser;
    @NotNull
    private Color color;
    private final float[] hsb;

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color newColor, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)newColor, (String)"newColor");
        this.color = newColor;
        Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.hsb);
        if (source != null) {
            this.changedByUser = true;
        }
        Iterable $this$forEach$iv = this.instantListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void setColor$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.setColor(color, object);
    }

    public final void onClose() {
        if (this.changedByUser) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ ColorPickerModel this$0;

                public final void run() {
                    Iterable $this$forEach$iv = ColorPickerModel.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ColorListener it = (ColorListener)element$iv;
                        boolean bl = false;
                        it.colorChanged(this.this$0.getColor(), (Object)this.this$0);
                    }
                }
                {
                    this.this$0 = colorPickerModel;
                }
            });
        }
    }

    public final void onCancel() {
    }

    public final void applyColorToSource(@NotNull Color newColor, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)newColor, (String)"newColor");
        this.setColor(newColor, source);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void applyColorToSource$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.applyColorToSource(color, object);
    }

    public final int getRed() {
        return this.color.getRed();
    }

    public final int getGreen() {
        return this.color.getGreen();
    }

    public final int getBlue() {
        return this.color.getBlue();
    }

    public final int getAlpha() {
        return this.color.getAlpha();
    }

    @NotNull
    public final String getHex() {
        String string = Integer.toHexString(this.color.getRGB());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Integer.toHexString(color.rgb)");
        return string;
    }

    public final float getHue() {
        return this.hsb[0];
    }

    public final float getSaturation() {
        return this.hsb[1];
    }

    public final float getBrightness() {
        return this.hsb[2];
    }

    public final void addListener(@NotNull ColorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.addListener(listener2, true);
    }

    public final void addListener(@NotNull ColorListener listener2, boolean invokeOnEveryColorChange) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        if (invokeOnEveryColorChange) {
            this.instantListeners.add(listener2);
        }
    }

    public final void removeListener(@NotNull ColorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
        this.instantListeners.remove(listener2);
    }

    public final boolean addPipetteListener(@NotNull ColorPipette.Callback listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.pipetteListeners.add(listener2);
    }

    public final boolean removePipetteListener(@NotNull ColorPipette.Callback listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.pipetteListeners.remove(listener2);
    }

    public final void firePipettePicked(@NotNull Color pickedColor) {
        Intrinsics.checkNotNullParameter((Object)pickedColor, (String)"pickedColor");
        Iterable $this$forEach$iv = this.pipetteListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPipette.Callback it = (ColorPipette.Callback)element$iv;
            boolean bl = false;
            it.picked(pickedColor);
        }
    }

    public final void firePipetteUpdated(@NotNull Color updatedColor) {
        Intrinsics.checkNotNullParameter((Object)updatedColor, (String)"updatedColor");
        Iterable $this$forEach$iv = this.pipetteListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPipette.Callback it = (ColorPipette.Callback)element$iv;
            boolean bl = false;
            it.update(updatedColor);
        }
    }

    public final void firePipetteCancelled() {
        Iterable $this$forEach$iv = this.pipetteListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPipette.Callback it = (ColorPipette.Callback)element$iv;
            boolean bl = false;
            it.cancel();
        }
    }

    public ColorPickerModel(@NotNull Color originalColor) {
        Intrinsics.checkNotNullParameter((Object)originalColor, (String)"originalColor");
        boolean bl = false;
        this.listeners = new LinkedHashSet();
        bl = false;
        this.pipetteListeners = new LinkedHashSet();
        bl = false;
        this.instantListeners = new LinkedHashSet();
        this.color = originalColor;
        float[] fArray = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"Color.RGBtoHSB(color.red\u2026.green, color.blue, null)");
        this.hsb = fArray;
    }

    public /* synthetic */ ColorPickerModel(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = ColorPickerModelKt.getDEFAULT_PICKER_COLOR();
        }
        this(color);
    }

    public ColorPickerModel() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Set access$getListeners$p(ColorPickerModel $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ Color access$getColor$p(ColorPickerModel $this) {
        return $this.color;
    }

    public static final /* synthetic */ void access$setColor$p(ColorPickerModel $this, Color color) {
        $this.color = color;
    }
}

