/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class TwoSideComponent
extends NonOpaquePanel {
    private final boolean myIsLocked;

    public TwoSideComponent(@NotNull JComponent left, @NotNull JComponent right) {
        if (left == null) {
            TwoSideComponent.$$$reportNull$$$0(0);
        }
        if (right == null) {
            TwoSideComponent.$$$reportNull$$$0(1);
        }
        try {
            this.add(left);
            this.add(right);
            this.setLayout((LayoutManager)((Object)new CommonToolbarLayout(left, right)));
        }
        finally {
            this.myIsLocked = true;
        }
    }

    protected void addImpl(Component comp, Object constraints2, int index2) {
        if (this.myIsLocked) {
            throw new UnsupportedOperationException();
        }
        super.addImpl(comp, constraints2, index2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "left";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "right";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/components/TwoSideComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommonToolbarLayout
    extends AbstractLayoutManager {
        private final JComponent myLeft;
        private final JComponent myRight;

        CommonToolbarLayout(JComponent left, JComponent right) {
            this.myLeft = left;
            this.myRight = right;
        }

        public Dimension preferredLayoutSize(@NotNull Container parent) {
            if (parent == null) {
                CommonToolbarLayout.$$$reportNull$$$0(0);
            }
            Dimension size2 = new Dimension();
            Dimension leftSize = this.myLeft.getPreferredSize();
            Dimension rightSize = this.myRight.getPreferredSize();
            size2.width = leftSize.width + rightSize.width;
            size2.height = Math.max(leftSize.height, rightSize.height);
            JBInsets.addTo((Dimension)size2, (Insets)parent.getInsets());
            return size2;
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                CommonToolbarLayout.$$$reportNull$$$0(1);
            }
            Insets insets = parent.getInsets();
            Dimension size2 = parent.getSize();
            Dimension prefSize = parent.getPreferredSize();
            if (prefSize.width <= size2.width) {
                this.myLeft.setBounds(insets.left, insets.top, this.myLeft.getPreferredSize().width, parent.getHeight() - insets.bottom);
                Dimension rightSize = this.myRight.getPreferredSize();
                this.myRight.setBounds(parent.getWidth() - rightSize.width - insets.left, insets.top, rightSize.width, parent.getHeight() - insets.bottom);
            } else {
                Dimension leftMinSize = this.myLeft.getMinimumSize();
                Dimension rightMinSize = this.myRight.getMinimumSize();
                int delta = 0;
                this.myLeft.setBounds(insets.left, insets.top, this.myLeft.getPreferredSize().width - delta, parent.getHeight() - insets.bottom);
                int rightX = (int)this.myLeft.getBounds().getMaxX();
                int rightWidth = size2.width - rightX - insets.right;
                if (rightWidth < rightMinSize.width) {
                    Dimension leftSize = this.myLeft.getSize();
                    int diffToRightMin = rightMinSize.width - rightWidth;
                    if (leftSize.width - diffToRightMin >= leftMinSize.width) {
                        leftSize.width -= diffToRightMin;
                        this.myLeft.setSize(leftSize);
                    }
                }
                this.myRight.setBounds((int)this.myLeft.getBounds().getMaxX(), insets.top, parent.getWidth() - (int)this.myLeft.getBounds().getMaxX() - insets.right, parent.getHeight() - insets.bottom);
            }
            CommonToolbarLayout.toMakeVerticallyInCenter(this.myLeft, parent);
            CommonToolbarLayout.toMakeVerticallyInCenter(this.myRight, parent);
        }

        private static void toMakeVerticallyInCenter(JComponent comp, Container parent) {
            Rectangle compBounds = comp.getBounds();
            Insets insets = parent.getInsets();
            int compHeight = comp.getPreferredSize().height;
            int parentHeight = parent.getHeight() - insets.top - insets.bottom;
            if (compHeight > parentHeight) {
                compHeight = parentHeight;
            }
            int y = (int)Math.floor((double)parentHeight / 2.0 - (double)compHeight / 2.0) + insets.top;
            comp.setBounds(compBounds.x, y, compBounds.width, compHeight);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "parent";
            objectArray2[1] = "com/intellij/ui/components/TwoSideComponent$CommonToolbarLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preferredLayoutSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

