/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GestureUtilities;
import com.apple.eawt.event.PressureEvent;
import com.apple.eawt.event.PressureListener;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public final class MacGestureSupportForEditor {
    public MacGestureSupportForEditor(final JComponent component2) {
        GestureUtilities.addGestureListenerTo((JComponent)component2, (GestureListener)new PressureListener(){

            public void pressure(PressureEvent e) {
                if (e.getStage() != 2.0) {
                    return;
                }
                ForceTouchEvent inputEvent = new ForceTouchEvent((Component)component2, e);
                try (AccessToken ignore = ((TransactionGuardImpl)TransactionGuard.getInstance()).startActivity(true);){
                    IdeEventQueue.getInstance().getMouseEventDispatcher().processEvent(inputEvent, 0, "force touch", (MouseShortcut)new PressureShortcut(e.getStage()), component2, false);
                }
            }
        });
    }

    private static final class ForceTouchEvent
    extends MouseEvent {
        final PressureEvent pressureEvent;

        ForceTouchEvent(Component source, PressureEvent pressureEvent) {
            super(source, 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
            this.pressureEvent = pressureEvent;
        }

        @Override
        public void consume() {
            super.consume();
            this.pressureEvent.consume();
        }
    }
}

