/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class IndexInfrastructure {
    private static final String STUB_VERSIONS = ".versions";
    private static final String PERSISTENT_INDEX_DIRECTORY_NAME = ".persistent";

    private IndexInfrastructure() {
    }

    @NotNull
    public static Path getVersionFile(@NotNull ID<?, ?> indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(0);
        }
        Path path2 = IndexInfrastructure.getIndexDirectory(indexName, true).resolve(indexName + ".ver");
        if (path2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(1);
        }
        return path2;
    }

    @NotNull
    public static Path getStorageFile(@NotNull ID<?, ?> indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(2);
        }
        Path path2 = IndexInfrastructure.getIndexRootDir(indexName).resolve(indexName.getName());
        if (path2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(3);
        }
        return path2;
    }

    @NotNull
    public static Path getInputIndexStorageFile(@NotNull ID<?, ?> indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(4);
        }
        Path path2 = IndexInfrastructure.getIndexRootDir(indexName).resolve(indexName + "_inputs");
        if (path2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(5);
        }
        return path2;
    }

    @NotNull
    public static Path getIndexRootDir(@NotNull ID<?, ?> indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(6);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, false);
    }

    @NotNull
    public static Path getPersistentIndexRoot() throws IOException {
        Path indexDir = PathManager.getIndexRoot().resolve(PERSISTENT_INDEX_DIRECTORY_NAME);
        Files.createDirectories(indexDir, new FileAttribute[0]);
        Path path2 = indexDir;
        if (path2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(7);
        }
        return path2;
    }

    @NotNull
    public static Path getPersistentIndexRootDir(@NotNull ID<?, ?> indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(8);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, false, PERSISTENT_INDEX_DIRECTORY_NAME);
    }

    @NotNull
    private static Path getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(9);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, forVersion, "");
    }

    @NotNull
    private static Path getIndexDirectory(@NotNull ID<?, ?> indexId, boolean forVersion, String relativePath) throws IOException {
        if (indexId == null) {
            IndexInfrastructure.$$$reportNull$$$0(10);
        }
        return IndexInfrastructure.getIndexDirectory(indexId.getName(), relativePath, indexId instanceof StubIndexKey, forVersion);
    }

    @NotNull
    private static Path getIndexDirectory(String indexName, String relativePath, boolean stubKey, boolean forVersion) throws IOException {
        Path indexDir;
        indexName = Strings.toLowerCase((String)indexName);
        if (stubKey) {
            indexDir = IndexInfrastructure.getIndexDirectory(StubUpdatingIndex.INDEX_ID, false, relativePath).resolve(forVersion ? STUB_VERSIONS : indexName);
        } else {
            indexDir = PathManager.getIndexRoot();
            if (!relativePath.isEmpty()) {
                indexDir = indexDir.resolve(relativePath);
            }
            indexDir = indexDir.resolve(indexName);
        }
        if (!FileBasedIndex.USE_IN_MEMORY_INDEX) {
            Files.createDirectories(indexDir, new FileAttribute[0]);
        }
        Path path2 = indexDir;
        if (path2 == null) {
            IndexInfrastructure.$$$reportNull$$$0(11);
        }
        return path2;
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getFileBasedIndexRootDir(@NotNull String indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(12);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, "", false, false);
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getStubIndexRootDir(@NotNull String indexName) throws IOException {
        if (indexName == null) {
            IndexInfrastructure.$$$reportNull$$$0(13);
        }
        return IndexInfrastructure.getIndexDirectory(indexName, "", true, false);
    }

    public static boolean hasIndices() {
        return !SystemProperties.is((String)"idea.skip.indices.initialization");
    }

    public static boolean isIndexesInitializationSuspended() {
        return SystemProperties.is((String)"idea.suspend.indexes.initialization");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexInfrastructure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexInfrastructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputIndexStorageFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentIndexRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInputIndexStorageFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndexRootDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPersistentIndexRootDir";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIndexDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileBasedIndexRootDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStubIndexRootDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

