/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class StaleIndexesChecker {
    private static final Logger LOG = Logger.getInstance(StaleIndexesChecker.class);
    private static final ThreadLocal<Boolean> IS_IN_STALE_IDS_DELETION = new ThreadLocal();

    public static boolean isStaleIdDeletion() {
        return IS_IN_STALE_IDS_DELETION.get() == Boolean.TRUE;
    }

    @NotNull
    static IntSet checkIndexForStaleRecords(@NotNull UpdatableIndex<?, ?, FileContent> index2, boolean onStartup) throws StorageException {
        if (index2 == null) {
            StaleIndexesChecker.$$$reportNull$$$0(0);
        }
        if (!ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isEAP()) {
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                StaleIndexesChecker.$$$reportNull$$$0(1);
            }
            return emptySet;
        }
        IndexExtension<?, ?, FileContent> extension2 = index2.getExtension();
        IndexId indexId = extension2.getName();
        LOG.assertTrue(indexId.equals(StubUpdatingIndex.INDEX_ID));
        LOG.assertTrue(extension2 instanceof SingleEntryFileBasedIndexExtension);
        Int2ObjectOpenHashMap staleFiles = new Int2ObjectOpenHashMap();
        IntListIterator intListIterator = (onStartup ? FSRecords.getRemainFreeRecords() : FSRecords.getNewFreeRecords()).iterator();
        while (intListIterator.hasNext()) {
            String name;
            int freeRecord = (Integer)intListIterator.next();
            Map<?, ?> dataAsMap = index2.getIndexedFileData(freeRecord);
            Object data2 = ContainerUtil.getFirstItem(dataAsMap.values());
            if (data2 == null) continue;
            try {
                name = StaleIndexesChecker.getDeadRecordPath(freeRecord);
            }
            catch (Exception e) {
                name = e.getMessage();
            }
            staleFiles.put(freeRecord, (Object)name);
        }
        if (!staleFiles.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode() && onStartup) {
                Disposer.register((Disposable)ApplicationManager.getApplication(), () -> StaleIndexesChecker.lambda$checkIndexForStaleRecords$0((Int2ObjectMap)staleFiles, indexId));
            } else {
                LOG.error(StaleIndexesChecker.getStaleInputIdsMessage((Int2ObjectMap<String>)staleFiles, indexId));
            }
        }
        IntSet intSet = staleFiles.keySet();
        if (intSet == null) {
            StaleIndexesChecker.$$$reportNull$$$0(2);
        }
        return intSet;
    }

    @NotNull
    private static String getDeadRecordPath(int freeRecord) {
        StringBuilder name = new StringBuilder(FSRecords.getName(freeRecord));
        int parent = FSRecords.getParent(freeRecord);
        while (parent > 0) {
            name.insert(0, FSRecords.getName(parent) + "/");
            parent = FSRecords.getParent(parent);
        }
        String string = name.toString();
        if (string == null) {
            StaleIndexesChecker.$$$reportNull$$$0(3);
        }
        return string;
    }

    static void clearStaleIndexes(@NotNull IntSet staleIds) {
        if (staleIds == null) {
            StaleIndexesChecker.$$$reportNull$$$0(4);
        }
        IS_IN_STALE_IDS_DELETION.set(Boolean.TRUE);
        try {
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                for (Integer staleId : staleIds) {
                    StaleIndexesChecker.clearStaleIndexesForId(staleId);
                }
            });
        }
        finally {
            IS_IN_STALE_IDS_DELETION.remove();
        }
    }

    static void clearStaleIndexesForId(int staleInputId) {
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        IndexConfiguration state = fileBasedIndex.getRegisteredIndexes().getState();
        for (ID<?, ?> id2 : state.getIndexIDs()) {
            try {
                UpdatableIndex<?, ?, FileContent> index2 = state.getIndex(id2);
                if (index2 == null) continue;
                fileBasedIndex.runUpdateForPersistentData((Computable<Boolean>)index2.mapInputAndPrepareUpdate(staleInputId, null));
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                fileBasedIndex.requestRebuild(id2);
            }
        }
    }

    @NotNull
    private static String getStaleInputIdsMessage(Int2ObjectMap<String> staleTrees, IndexId<?, ?> indexId) {
        String string = "`" + indexId + "` index contains several stale file ids (size = " + staleTrees.size() + "). Ids & filenames: " + StringUtil.first((String)staleTrees.toString(), (int)300, (boolean)true) + ".";
        if (string == null) {
            StaleIndexesChecker.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void lambda$checkIndexForStaleRecords$0(Int2ObjectMap staleFiles, IndexId indexId) {
        LOG.error(StaleIndexesChecker.getStaleInputIdsMessage((Int2ObjectMap<String>)staleFiles, indexId));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/StaleIndexesChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/StaleIndexesChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIndexForStaleRecords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeadRecordPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaleInputIdsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexForStaleRecords";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearStaleIndexes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

