/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u0000 :2\u00020\u0001:\u00059:;<=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020,J\u0014\u0010-\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\bH\u00d6\u0001J\t\u00108\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0012j\b\u0012\u0004\u0012\u00020\u0018`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR-\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u001fj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 `!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R-\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020%0\u001fj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020%`!\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#\u00a8\u0006>"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "indexingReason", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "biggestContributorsPerFileTypeLimit", "", "getIndexingReason", "()Ljava/lang/String;", "indexingSessionId", "", "getIndexingSessionId", "()J", "getProject", "()Lcom/intellij/openapi/project/Project;", "providerStatistics", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonFileProviderIndexStatistics;", "Lkotlin/collections/ArrayList;", "getProviderStatistics", "()Ljava/util/ArrayList;", "scanningStatistics", "Lcom/intellij/util/indexing/diagnostic/dto/JsonScanningStatistics;", "getScanningStatistics", "times", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "getTimes", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "totalStatsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerFileType;", "Lkotlin/collections/HashMap;", "getTotalStatsPerFileType", "()Ljava/util/HashMap;", "totalStatsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer;", "getTotalStatsPerIndexer", "addProviderStatistics", "", "statistics", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics;", "addScanningStatistics", "Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "addSnapshotInputMappingStatistics", "snapshotInputMappingsStatistics", "", "Lcom/intellij/util/indexing/snapshot/SnapshotInputMappingsStatistics;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "BiggestFileTypeContributor", "Companion", "IndexingTimes", "StatsPerFileType", "StatsPerIndexer", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistory {
    private final long indexingSessionId;
    private final int biggestContributorsPerFileTypeLimit;
    @NotNull
    private final IndexingTimes times;
    @NotNull
    private final ArrayList<JsonScanningStatistics> scanningStatistics;
    @NotNull
    private final ArrayList<JsonFileProviderIndexStatistics> providerStatistics;
    @NotNull
    private final HashMap<String, StatsPerFileType> totalStatsPerFileType;
    @NotNull
    private final HashMap<String, StatsPerIndexer> totalStatsPerIndexer;
    @NotNull
    private final Project project;
    @Nullable
    private final String indexingReason;
    @Deprecated
    @NotNull
    private static final AtomicLong indexingSessionIdSequencer;
    @NotNull
    private static final Companion Companion;

    public final long getIndexingSessionId() {
        return this.indexingSessionId;
    }

    @NotNull
    public final IndexingTimes getTimes() {
        return this.times;
    }

    @NotNull
    public final ArrayList<JsonScanningStatistics> getScanningStatistics() {
        return this.scanningStatistics;
    }

    @NotNull
    public final ArrayList<JsonFileProviderIndexStatistics> getProviderStatistics() {
        return this.providerStatistics;
    }

    @NotNull
    public final HashMap<String, StatsPerFileType> getTotalStatsPerFileType() {
        return this.totalStatsPerFileType;
    }

    @NotNull
    public final HashMap<String, StatsPerIndexer> getTotalStatsPerIndexer() {
        return this.totalStatsPerIndexer;
    }

    public final void addScanningStatistics(@NotNull ScanningStatistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Collection collection = this.scanningStatistics;
        JsonScanningStatistics jsonScanningStatistics = JsonConverterKt.toJsonStatistics(statistics);
        boolean bl = false;
        collection.add(jsonScanningStatistics);
    }

    /*
     * WARNING - void declaration
     */
    public final void addProviderStatistics(@NotNull IndexingJobStatistics statistics) {
        Object totalStats;
        Object answer$iv;
        Object value$iv;
        Object fileType;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv22;
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Map.Entry entry22 = this.providerStatistics;
        Iterator iterator2 = JsonConverterKt.toJsonStatistics(statistics);
        boolean bl = false;
        entry22.add(iterator2);
        Object object = statistics.getStatsPerFileType();
        boolean bl2 = false;
        iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Map.Entry entry3 = entry22 = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            object = (String)entry3.getKey();
            entry3 = entry22;
            bl3 = false;
            IndexingJobStatistics.StatsPerFileType fileTypeStats = (IndexingJobStatistics.StatsPerFileType)entry3.getValue();
            $this$getOrPut$iv22 = this.totalStatsPerFileType;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(fileType);
            if (value$iv == null) {
                boolean bl4 = false;
                boolean bl5 = false;
                answer$iv = new StatsPerFileType(0, 0L, 0L, 0L, new LimitedPriorityQueue<BiggestFileTypeContributor>(this.biggestContributorsPerFileTypeLimit, new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        BiggestFileTypeContributor it = (BiggestFileTypeContributor)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getProcessingTimeInAllThreads());
                        it = (BiggestFileTypeContributor)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Long.valueOf(it.getProcessingTimeInAllThreads());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                }));
                $this$getOrPut$iv22.put(fileType, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Object object3 = totalStats = (StatsPerFileType)object2;
            ((StatsPerFileType)object3).setTotalNumberOfFiles(((StatsPerFileType)object3).getTotalNumberOfFiles() + fileTypeStats.getNumberOfFiles());
            Object object4 = totalStats;
            ((StatsPerFileType)object4).setTotalBytes(((StatsPerFileType)object4).getTotalBytes() + fileTypeStats.getTotalBytes());
            Object object5 = totalStats;
            ((StatsPerFileType)object5).setTotalProcessingTimeInAllThreads(((StatsPerFileType)object5).getTotalProcessingTimeInAllThreads() + fileTypeStats.getProcessingTimeInAllThreads());
            Object object6 = totalStats;
            ((StatsPerFileType)object6).setTotalContentLoadingTimeInAllThreads(((StatsPerFileType)object6).getTotalContentLoadingTimeInAllThreads() + fileTypeStats.getContentLoadingTimeInAllThreads());
            ((StatsPerFileType)totalStats).getBiggestFileTypeContributors().addElement(new BiggestFileTypeContributor(statistics.getFileSetName(), fileTypeStats.getNumberOfFiles(), fileTypeStats.getTotalBytes(), fileTypeStats.getProcessingTimeInAllThreads()));
        }
        fileType = statistics.getStatsPerIndexer();
        boolean fileTypeStats = false;
        for (Map.Entry entry22 : fileType.entrySet()) {
            Object object7;
            void indexId;
            totalStats = entry22;
            boolean $this$getOrPut$iv22 = false;
            fileType = (String)totalStats.getKey();
            totalStats = entry22;
            $this$getOrPut$iv22 = false;
            IndexingJobStatistics.StatsPerIndexer stats = (IndexingJobStatistics.StatsPerIndexer)totalStats.getValue();
            $this$getOrPut$iv22 = this.totalStatsPerIndexer;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(indexId);
            if (value$iv == null) {
                boolean bl6 = false;
                answer$iv = new StatsPerIndexer(0, 0, 0L, 0L, new StatsPerIndexer.SnapshotInputMappingStats(0L, 0L));
                $this$getOrPut$iv22.put(indexId, answer$iv);
                object7 = answer$iv;
            } else {
                object7 = value$iv;
            }
            Object object8 = totalStats = (StatsPerIndexer)object7;
            ((StatsPerIndexer)object8).setTotalNumberOfFiles(((StatsPerIndexer)object8).getTotalNumberOfFiles() + stats.getNumberOfFiles());
            Object object9 = totalStats;
            ((StatsPerIndexer)object9).setTotalNumberOfFilesIndexedByExtensions(((StatsPerIndexer)object9).getTotalNumberOfFilesIndexedByExtensions() + stats.getNumberOfFilesIndexedByExtensions());
            Object object10 = totalStats;
            ((StatsPerIndexer)object10).setTotalBytes(((StatsPerIndexer)object10).getTotalBytes() + stats.getTotalBytes());
            Object object11 = totalStats;
            ((StatsPerIndexer)object11).setTotalIndexingTimeInAllThreads(((StatsPerIndexer)object11).getTotalIndexingTimeInAllThreads() + stats.getIndexingTime());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addSnapshotInputMappingStatistics(@NotNull List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics) {
        Intrinsics.checkNotNullParameter(snapshotInputMappingsStatistics, (String)"snapshotInputMappingsStatistics");
        for (SnapshotInputMappingsStatistics mappingsStatistic : snapshotInputMappingsStatistics) {
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            Map map2 = this.totalStatsPerIndexer;
            ID<?, ?> iD = mappingsStatistic.getIndexId();
            Intrinsics.checkNotNullExpressionValue(iD, (String)"mappingsStatistic.indexId");
            Intrinsics.checkNotNullExpressionValue((Object)iD.getName(), (String)"mappingsStatistic.indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                StatsPerIndexer answer$iv = new StatsPerIndexer(0, 0, 0L, 0L, new StatsPerIndexer.SnapshotInputMappingStats(0L, 0L));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            StatsPerIndexer totalStats = (StatsPerIndexer)object;
            StatsPerIndexer.SnapshotInputMappingStats snapshotInputMappingStats = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStats.setRequests(snapshotInputMappingStats.getRequests() + mappingsStatistic.getTotalRequests());
            StatsPerIndexer.SnapshotInputMappingStats snapshotInputMappingStats2 = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStats2.setMisses(snapshotInputMappingStats2.getMisses() + mappingsStatistic.getTotalMisses());
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String getIndexingReason() {
        return this.indexingReason;
    }

    public ProjectIndexingHistory(@NotNull Project project, @Nullable String indexingReason) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.indexingReason = indexingReason;
        this.indexingSessionId = indexingSessionIdSequencer.getAndIncrement();
        this.biggestContributorsPerFileTypeLimit = 10;
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now(ZoneOffset.UTC)");
        this.times = new IndexingTimes(this.indexingReason, zonedDateTime, System.nanoTime(), null, null, null, null, null, null, null, false, 2040, null);
        boolean bl = false;
        this.scanningStatistics = new ArrayList();
        bl = false;
        this.providerStatistics = new ArrayList();
        bl = false;
        this.totalStatsPerFileType = new HashMap();
        bl = false;
        this.totalStatsPerIndexer = new HashMap();
    }

    static {
        Companion = new Companion(null);
        indexingSessionIdSequencer = new AtomicLong();
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @Nullable
    public final String component2() {
        return this.indexingReason;
    }

    @NotNull
    public final ProjectIndexingHistory copy(@NotNull Project project, @Nullable String indexingReason) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ProjectIndexingHistory(project, indexingReason);
    }

    public static /* synthetic */ ProjectIndexingHistory copy$default(ProjectIndexingHistory projectIndexingHistory, Project project, String string, int n, Object object) {
        if ((n & 1) != 0) {
            project = projectIndexingHistory.project;
        }
        if ((n & 2) != 0) {
            string = projectIndexingHistory.indexingReason;
        }
        return projectIndexingHistory.copy(project, string);
    }

    @NotNull
    public String toString() {
        return "ProjectIndexingHistory(project=" + this.project + ", indexingReason=" + this.indexingReason + ")";
    }

    public int hashCode() {
        Project project = this.project;
        String string = this.indexingReason;
        return (project != null ? project.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProjectIndexingHistory)) break block3;
                ProjectIndexingHistory projectIndexingHistory = (ProjectIndexingHistory)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)projectIndexingHistory.project) || !Intrinsics.areEqual((Object)this.indexingReason, (Object)projectIndexingHistory.indexingReason)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001d\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010\u001e\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JM\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0005j\u0002`\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006("}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerFileType;", "", "totalNumberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalProcessingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalContentLoadingTimeInAllThreads", "biggestFileTypeContributors", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$BiggestFileTypeContributor;", "(IJJJLcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;)V", "getBiggestFileTypeContributors", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalContentLoadingTimeInAllThreads", "setTotalContentLoadingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalProcessingTimeInAllThreads", "setTotalProcessingTimeInAllThreads", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileType {
        private int totalNumberOfFiles;
        private long totalBytes;
        private long totalProcessingTimeInAllThreads;
        private long totalContentLoadingTimeInAllThreads;
        @NotNull
        private final LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors;

        public final int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getTotalProcessingTimeInAllThreads() {
            return this.totalProcessingTimeInAllThreads;
        }

        public final void setTotalProcessingTimeInAllThreads(long l) {
            this.totalProcessingTimeInAllThreads = l;
        }

        public final long getTotalContentLoadingTimeInAllThreads() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        public final void setTotalContentLoadingTimeInAllThreads(long l) {
            this.totalContentLoadingTimeInAllThreads = l;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributor> getBiggestFileTypeContributors() {
            return this.biggestFileTypeContributors;
        }

        public StatsPerFileType(int totalNumberOfFiles, long totalBytes, long totalProcessingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalBytes = totalBytes;
            this.totalProcessingTimeInAllThreads = totalProcessingTimeInAllThreads;
            this.totalContentLoadingTimeInAllThreads = totalContentLoadingTimeInAllThreads;
            this.biggestFileTypeContributors = biggestFileTypeContributors;
        }

        public final int component1() {
            return this.totalNumberOfFiles;
        }

        public final long component2() {
            return this.totalBytes;
        }

        public final long component3() {
            return this.totalProcessingTimeInAllThreads;
        }

        public final long component4() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributor> component5() {
            return this.biggestFileTypeContributors;
        }

        @NotNull
        public final StatsPerFileType copy(int totalNumberOfFiles, long totalBytes, long totalProcessingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributor> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            return new StatsPerFileType(totalNumberOfFiles, totalBytes, totalProcessingTimeInAllThreads, totalContentLoadingTimeInAllThreads, biggestFileTypeContributors);
        }

        public static /* synthetic */ StatsPerFileType copy$default(StatsPerFileType statsPerFileType, int n, long l, long l2, long l3, LimitedPriorityQueue limitedPriorityQueue, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statsPerFileType.totalNumberOfFiles;
            }
            if ((n2 & 2) != 0) {
                l = statsPerFileType.totalBytes;
            }
            if ((n2 & 4) != 0) {
                l2 = statsPerFileType.totalProcessingTimeInAllThreads;
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileType.totalContentLoadingTimeInAllThreads;
            }
            if ((n2 & 0x10) != 0) {
                limitedPriorityQueue = statsPerFileType.biggestFileTypeContributors;
            }
            return statsPerFileType.copy(n, l, l2, l3, limitedPriorityQueue);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileType(totalNumberOfFiles=" + this.totalNumberOfFiles + ", totalBytes=" + this.totalBytes + ", totalProcessingTimeInAllThreads=" + this.totalProcessingTimeInAllThreads + ", totalContentLoadingTimeInAllThreads=" + this.totalContentLoadingTimeInAllThreads + ", biggestFileTypeContributors=" + this.biggestFileTypeContributors + ")";
        }

        public int hashCode() {
            LimitedPriorityQueue<BiggestFileTypeContributor> limitedPriorityQueue = this.biggestFileTypeContributors;
            return (((Integer.hashCode(this.totalNumberOfFiles) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.totalProcessingTimeInAllThreads)) * 31 + Long.hashCode(this.totalContentLoadingTimeInAllThreads)) * 31 + (limitedPriorityQueue != null ? limitedPriorityQueue.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileType)) break block3;
                    StatsPerFileType statsPerFileType = (StatsPerFileType)object;
                    if (this.totalNumberOfFiles != statsPerFileType.totalNumberOfFiles || this.totalBytes != statsPerFileType.totalBytes || this.totalProcessingTimeInAllThreads != statsPerFileType.totalProcessingTimeInAllThreads || this.totalContentLoadingTimeInAllThreads != statsPerFileType.totalContentLoadingTimeInAllThreads || !Intrinsics.areEqual(this.biggestFileTypeContributors, statsPerFileType.biggestFileTypeContributors)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\nH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0007j\u0002`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$BiggestFileTypeContributor;", "", "providerName", "", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "processingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(Ljava/lang/String;IJJ)V", "getNumberOfFiles", "()I", "getProcessingTimeInAllThreads", "()J", "getProviderName", "()Ljava/lang/String;", "getTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.lang.impl"})
    public static final class BiggestFileTypeContributor {
        @NotNull
        private final String providerName;
        private final int numberOfFiles;
        private final long totalBytes;
        private final long processingTimeInAllThreads;

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final long getProcessingTimeInAllThreads() {
            return this.processingTimeInAllThreads;
        }

        public BiggestFileTypeContributor(@NotNull String providerName, int numberOfFiles, long totalBytes, long processingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.providerName = providerName;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
            this.processingTimeInAllThreads = processingTimeInAllThreads;
        }

        @NotNull
        public final String component1() {
            return this.providerName;
        }

        public final int component2() {
            return this.numberOfFiles;
        }

        public final long component3() {
            return this.totalBytes;
        }

        public final long component4() {
            return this.processingTimeInAllThreads;
        }

        @NotNull
        public final BiggestFileTypeContributor copy(@NotNull String providerName, int numberOfFiles, long totalBytes, long processingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new BiggestFileTypeContributor(providerName, numberOfFiles, totalBytes, processingTimeInAllThreads);
        }

        public static /* synthetic */ BiggestFileTypeContributor copy$default(BiggestFileTypeContributor biggestFileTypeContributor, String string, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = biggestFileTypeContributor.providerName;
            }
            if ((n2 & 2) != 0) {
                n = biggestFileTypeContributor.numberOfFiles;
            }
            if ((n2 & 4) != 0) {
                l = biggestFileTypeContributor.totalBytes;
            }
            if ((n2 & 8) != 0) {
                l2 = biggestFileTypeContributor.processingTimeInAllThreads;
            }
            return biggestFileTypeContributor.copy(string, n, l, l2);
        }

        @NotNull
        public String toString() {
            return "BiggestFileTypeContributor(providerName=" + this.providerName + ", numberOfFiles=" + this.numberOfFiles + ", totalBytes=" + this.totalBytes + ", processingTimeInAllThreads=" + this.processingTimeInAllThreads + ")";
        }

        public int hashCode() {
            String string = this.providerName;
            return (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.numberOfFiles)) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.processingTimeInAllThreads);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BiggestFileTypeContributor)) break block3;
                    BiggestFileTypeContributor biggestFileTypeContributor = (BiggestFileTypeContributor)object;
                    if (!Intrinsics.areEqual((Object)this.providerName, (Object)biggestFileTypeContributor.providerName) || this.numberOfFiles != biggestFileTypeContributor.numberOfFiles || this.totalBytes != biggestFileTypeContributor.totalBytes || this.processingTimeInAllThreads != biggestFileTypeContributor.processingTimeInAllThreads) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001)B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J\r\u0010 \u001a\u00060\u0006j\u0002`\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\f\b\u0002\u0010\b\u001a\u00060\u0006j\u0002`\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\b\u001a\u00060\u0006j\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer;", "", "totalNumberOfFiles", "", "totalNumberOfFilesIndexedByExtensions", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "snapshotInputMappingStats", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;", "(IIJJLcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;)V", "getSnapshotInputMappingStats", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;", "setSnapshotInputMappingStats", "(Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalNumberOfFilesIndexedByExtensions", "setTotalNumberOfFilesIndexedByExtensions", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "SnapshotInputMappingStats", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexer {
        private int totalNumberOfFiles;
        private int totalNumberOfFilesIndexedByExtensions;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;
        @NotNull
        private SnapshotInputMappingStats snapshotInputMappingStats;

        public final int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        public final int getTotalNumberOfFilesIndexedByExtensions() {
            return this.totalNumberOfFilesIndexedByExtensions;
        }

        public final void setTotalNumberOfFilesIndexedByExtensions(int n) {
            this.totalNumberOfFilesIndexedByExtensions = n;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public final void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        @NotNull
        public final SnapshotInputMappingStats getSnapshotInputMappingStats() {
            return this.snapshotInputMappingStats;
        }

        public final void setSnapshotInputMappingStats(@NotNull SnapshotInputMappingStats snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"<set-?>");
            this.snapshotInputMappingStats = snapshotInputMappingStats;
        }

        public StatsPerIndexer(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStats snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalNumberOfFilesIndexedByExtensions = totalNumberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
            this.snapshotInputMappingStats = snapshotInputMappingStats;
        }

        public final int component1() {
            return this.totalNumberOfFiles;
        }

        public final int component2() {
            return this.totalNumberOfFilesIndexedByExtensions;
        }

        public final long component3() {
            return this.totalBytes;
        }

        public final long component4() {
            return this.totalIndexingTimeInAllThreads;
        }

        @NotNull
        public final SnapshotInputMappingStats component5() {
            return this.snapshotInputMappingStats;
        }

        @NotNull
        public final StatsPerIndexer copy(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStats snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            return new StatsPerIndexer(totalNumberOfFiles, totalNumberOfFilesIndexedByExtensions, totalBytes, totalIndexingTimeInAllThreads, snapshotInputMappingStats);
        }

        public static /* synthetic */ StatsPerIndexer copy$default(StatsPerIndexer statsPerIndexer, int n, int n2, long l, long l2, SnapshotInputMappingStats snapshotInputMappingStats, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = statsPerIndexer.totalNumberOfFiles;
            }
            if ((n3 & 2) != 0) {
                n2 = statsPerIndexer.totalNumberOfFilesIndexedByExtensions;
            }
            if ((n3 & 4) != 0) {
                l = statsPerIndexer.totalBytes;
            }
            if ((n3 & 8) != 0) {
                l2 = statsPerIndexer.totalIndexingTimeInAllThreads;
            }
            if ((n3 & 0x10) != 0) {
                snapshotInputMappingStats = statsPerIndexer.snapshotInputMappingStats;
            }
            return statsPerIndexer.copy(n, n2, l, l2, snapshotInputMappingStats);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexer(totalNumberOfFiles=" + this.totalNumberOfFiles + ", totalNumberOfFilesIndexedByExtensions=" + this.totalNumberOfFilesIndexedByExtensions + ", totalBytes=" + this.totalBytes + ", totalIndexingTimeInAllThreads=" + this.totalIndexingTimeInAllThreads + ", snapshotInputMappingStats=" + this.snapshotInputMappingStats + ")";
        }

        public int hashCode() {
            SnapshotInputMappingStats snapshotInputMappingStats = this.snapshotInputMappingStats;
            return (((Integer.hashCode(this.totalNumberOfFiles) * 31 + Integer.hashCode(this.totalNumberOfFilesIndexedByExtensions)) * 31 + Long.hashCode(this.totalBytes)) * 31 + Long.hashCode(this.totalIndexingTimeInAllThreads)) * 31 + (snapshotInputMappingStats != null ? ((Object)snapshotInputMappingStats).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexer)) break block3;
                    StatsPerIndexer statsPerIndexer = (StatsPerIndexer)object;
                    if (this.totalNumberOfFiles != statsPerIndexer.totalNumberOfFiles || this.totalNumberOfFilesIndexedByExtensions != statsPerIndexer.totalNumberOfFilesIndexedByExtensions || this.totalBytes != statsPerIndexer.totalBytes || this.totalIndexingTimeInAllThreads != statsPerIndexer.totalIndexingTimeInAllThreads || !Intrinsics.areEqual((Object)this.snapshotInputMappingStats, (Object)statsPerIndexer.snapshotInputMappingStats)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$StatsPerIndexer$SnapshotInputMappingStats;", "", "requests", "", "misses", "(JJ)V", "hits", "getHits", "()J", "getMisses", "setMisses", "(J)V", "getRequests", "setRequests", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
        public static final class SnapshotInputMappingStats {
            private long requests;
            private long misses;

            public final long getHits() {
                return this.requests - this.misses;
            }

            public final long getRequests() {
                return this.requests;
            }

            public final void setRequests(long l) {
                this.requests = l;
            }

            public final long getMisses() {
                return this.misses;
            }

            public final void setMisses(long l) {
                this.misses = l;
            }

            public SnapshotInputMappingStats(long requests2, long misses) {
                this.requests = requests2;
                this.misses = misses;
            }

            public final long component1() {
                return this.requests;
            }

            public final long component2() {
                return this.misses;
            }

            @NotNull
            public final SnapshotInputMappingStats copy(long requests2, long misses) {
                return new SnapshotInputMappingStats(requests2, misses);
            }

            public static /* synthetic */ SnapshotInputMappingStats copy$default(SnapshotInputMappingStats snapshotInputMappingStats, long l, long l2, int n, Object object) {
                if ((n & 1) != 0) {
                    l = snapshotInputMappingStats.requests;
                }
                if ((n & 2) != 0) {
                    l2 = snapshotInputMappingStats.misses;
                }
                return snapshotInputMappingStats.copy(l, l2);
            }

            @NotNull
            public String toString() {
                return "SnapshotInputMappingStats(requests=" + this.requests + ", misses=" + this.misses + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.requests) * 31 + Long.hashCode(this.misses);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SnapshotInputMappingStats)) break block3;
                        SnapshotInputMappingStats snapshotInputMappingStats = (SnapshotInputMappingStats)object;
                        if (this.requests != snapshotInputMappingStats.requests || this.misses != snapshotInputMappingStats.misses) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b-\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000b\u00101\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u000bH\u00c6\u0003J\t\u00103\u001a\u00020\u0012H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\r\u00105\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u000bH\u00c6\u0003J\t\u00108\u001a\u00020\u000bH\u00c6\u0003J\t\u00109\u001a\u00020\u000bH\u00c6\u0003J\t\u0010:\u001a\u00020\u000bH\u00c6\u0003J\t\u0010;\u001a\u00020\u000bH\u00c6\u0003J}\u0010<\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001J\u0013\u0010=\u001a\u00020\u00122\b\u0010>\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\t\u0010A\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\r\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u001e\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006B"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$IndexingTimes;", "", "indexingReason", "", "updatingStart", "Ljava/time/ZonedDateTime;", "totalUpdatingTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "updatingEnd", "indexingDuration", "Ljava/time/Duration;", "contentLoadingDuration", "pushPropertiesDuration", "indexExtensionsDuration", "scanFilesDuration", "suspendedDuration", "wasInterrupted", "", "(Ljava/lang/String;Ljava/time/ZonedDateTime;JLjava/time/ZonedDateTime;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Z)V", "getContentLoadingDuration", "()Ljava/time/Duration;", "setContentLoadingDuration", "(Ljava/time/Duration;)V", "getIndexExtensionsDuration", "setIndexExtensionsDuration", "getIndexingDuration", "setIndexingDuration", "getIndexingReason", "()Ljava/lang/String;", "getPushPropertiesDuration", "setPushPropertiesDuration", "getScanFilesDuration", "setScanFilesDuration", "getSuspendedDuration", "setSuspendedDuration", "getTotalUpdatingTime", "()J", "setTotalUpdatingTime", "(J)V", "getUpdatingEnd", "()Ljava/time/ZonedDateTime;", "setUpdatingEnd", "(Ljava/time/ZonedDateTime;)V", "getUpdatingStart", "getWasInterrupted", "()Z", "setWasInterrupted", "(Z)V", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class IndexingTimes {
        @Nullable
        private final String indexingReason;
        @NotNull
        private final ZonedDateTime updatingStart;
        private long totalUpdatingTime;
        @NotNull
        private ZonedDateTime updatingEnd;
        @NotNull
        private Duration indexingDuration;
        @NotNull
        private Duration contentLoadingDuration;
        @NotNull
        private Duration pushPropertiesDuration;
        @NotNull
        private Duration indexExtensionsDuration;
        @NotNull
        private Duration scanFilesDuration;
        @NotNull
        private Duration suspendedDuration;
        private boolean wasInterrupted;

        @Nullable
        public final String getIndexingReason() {
            return this.indexingReason;
        }

        @NotNull
        public final ZonedDateTime getUpdatingStart() {
            return this.updatingStart;
        }

        public final long getTotalUpdatingTime() {
            return this.totalUpdatingTime;
        }

        public final void setTotalUpdatingTime(long l) {
            this.totalUpdatingTime = l;
        }

        @NotNull
        public final ZonedDateTime getUpdatingEnd() {
            return this.updatingEnd;
        }

        public final void setUpdatingEnd(@NotNull ZonedDateTime zonedDateTime) {
            Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"<set-?>");
            this.updatingEnd = zonedDateTime;
        }

        @NotNull
        public final Duration getIndexingDuration() {
            return this.indexingDuration;
        }

        public final void setIndexingDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexingDuration = duration;
        }

        @NotNull
        public final Duration getContentLoadingDuration() {
            return this.contentLoadingDuration;
        }

        public final void setContentLoadingDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.contentLoadingDuration = duration;
        }

        @NotNull
        public final Duration getPushPropertiesDuration() {
            return this.pushPropertiesDuration;
        }

        public final void setPushPropertiesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.pushPropertiesDuration = duration;
        }

        @NotNull
        public final Duration getIndexExtensionsDuration() {
            return this.indexExtensionsDuration;
        }

        public final void setIndexExtensionsDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexExtensionsDuration = duration;
        }

        @NotNull
        public final Duration getScanFilesDuration() {
            return this.scanFilesDuration;
        }

        public final void setScanFilesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.scanFilesDuration = duration;
        }

        @NotNull
        public final Duration getSuspendedDuration() {
            return this.suspendedDuration;
        }

        public final void setSuspendedDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.suspendedDuration = duration;
        }

        public final boolean getWasInterrupted() {
            return this.wasInterrupted;
        }

        public final void setWasInterrupted(boolean bl) {
            this.wasInterrupted = bl;
        }

        public IndexingTimes(@Nullable String indexingReason, @NotNull ZonedDateTime updatingStart, long totalUpdatingTime, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration contentLoadingDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)contentLoadingDuration, (String)"contentLoadingDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            this.indexingReason = indexingReason;
            this.updatingStart = updatingStart;
            this.totalUpdatingTime = totalUpdatingTime;
            this.updatingEnd = updatingEnd;
            this.indexingDuration = indexingDuration;
            this.contentLoadingDuration = contentLoadingDuration;
            this.pushPropertiesDuration = pushPropertiesDuration;
            this.indexExtensionsDuration = indexExtensionsDuration;
            this.scanFilesDuration = scanFilesDuration;
            this.suspendedDuration = suspendedDuration;
            this.wasInterrupted = wasInterrupted;
        }

        public /* synthetic */ IndexingTimes(String string, ZonedDateTime zonedDateTime, long l, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, Duration duration6, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                zonedDateTime2 = zonedDateTime;
            }
            if ((n & 0x10) != 0) {
                Duration duration7 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"Duration.ZERO");
                duration = duration7;
            }
            if ((n & 0x20) != 0) {
                Duration duration8 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"Duration.ZERO");
                duration2 = duration8;
            }
            if ((n & 0x40) != 0) {
                Duration duration9 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"Duration.ZERO");
                duration3 = duration9;
            }
            if ((n & 0x80) != 0) {
                Duration duration10 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"Duration.ZERO");
                duration4 = duration10;
            }
            if ((n & 0x100) != 0) {
                Duration duration11 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration11, (String)"Duration.ZERO");
                duration5 = duration11;
            }
            if ((n & 0x200) != 0) {
                Duration duration12 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration12, (String)"Duration.ZERO");
                duration6 = duration12;
            }
            if ((n & 0x400) != 0) {
                bl = false;
            }
            this(string, zonedDateTime, l, zonedDateTime2, duration, duration2, duration3, duration4, duration5, duration6, bl);
        }

        @Nullable
        public final String component1() {
            return this.indexingReason;
        }

        @NotNull
        public final ZonedDateTime component2() {
            return this.updatingStart;
        }

        public final long component3() {
            return this.totalUpdatingTime;
        }

        @NotNull
        public final ZonedDateTime component4() {
            return this.updatingEnd;
        }

        @NotNull
        public final Duration component5() {
            return this.indexingDuration;
        }

        @NotNull
        public final Duration component6() {
            return this.contentLoadingDuration;
        }

        @NotNull
        public final Duration component7() {
            return this.pushPropertiesDuration;
        }

        @NotNull
        public final Duration component8() {
            return this.indexExtensionsDuration;
        }

        @NotNull
        public final Duration component9() {
            return this.scanFilesDuration;
        }

        @NotNull
        public final Duration component10() {
            return this.suspendedDuration;
        }

        public final boolean component11() {
            return this.wasInterrupted;
        }

        @NotNull
        public final IndexingTimes copy(@Nullable String indexingReason, @NotNull ZonedDateTime updatingStart, long totalUpdatingTime, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration contentLoadingDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)contentLoadingDuration, (String)"contentLoadingDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            return new IndexingTimes(indexingReason, updatingStart, totalUpdatingTime, updatingEnd, indexingDuration, contentLoadingDuration, pushPropertiesDuration, indexExtensionsDuration, scanFilesDuration, suspendedDuration, wasInterrupted);
        }

        public static /* synthetic */ IndexingTimes copy$default(IndexingTimes indexingTimes, String string, ZonedDateTime zonedDateTime, long l, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, Duration duration6, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = indexingTimes.indexingReason;
            }
            if ((n & 2) != 0) {
                zonedDateTime = indexingTimes.updatingStart;
            }
            if ((n & 4) != 0) {
                l = indexingTimes.totalUpdatingTime;
            }
            if ((n & 8) != 0) {
                zonedDateTime2 = indexingTimes.updatingEnd;
            }
            if ((n & 0x10) != 0) {
                duration = indexingTimes.indexingDuration;
            }
            if ((n & 0x20) != 0) {
                duration2 = indexingTimes.contentLoadingDuration;
            }
            if ((n & 0x40) != 0) {
                duration3 = indexingTimes.pushPropertiesDuration;
            }
            if ((n & 0x80) != 0) {
                duration4 = indexingTimes.indexExtensionsDuration;
            }
            if ((n & 0x100) != 0) {
                duration5 = indexingTimes.scanFilesDuration;
            }
            if ((n & 0x200) != 0) {
                duration6 = indexingTimes.suspendedDuration;
            }
            if ((n & 0x400) != 0) {
                bl = indexingTimes.wasInterrupted;
            }
            return indexingTimes.copy(string, zonedDateTime, l, zonedDateTime2, duration, duration2, duration3, duration4, duration5, duration6, bl);
        }

        @NotNull
        public String toString() {
            return "IndexingTimes(indexingReason=" + this.indexingReason + ", updatingStart=" + this.updatingStart + ", totalUpdatingTime=" + this.totalUpdatingTime + ", updatingEnd=" + this.updatingEnd + ", indexingDuration=" + this.indexingDuration + ", contentLoadingDuration=" + this.contentLoadingDuration + ", pushPropertiesDuration=" + this.pushPropertiesDuration + ", indexExtensionsDuration=" + this.indexExtensionsDuration + ", scanFilesDuration=" + this.scanFilesDuration + ", suspendedDuration=" + this.suspendedDuration + ", wasInterrupted=" + this.wasInterrupted + ")";
        }

        public int hashCode() {
            String string = this.indexingReason;
            ZonedDateTime zonedDateTime = this.updatingStart;
            ZonedDateTime zonedDateTime2 = this.updatingEnd;
            Duration duration = this.indexingDuration;
            Duration duration2 = this.contentLoadingDuration;
            Duration duration3 = this.pushPropertiesDuration;
            Duration duration4 = this.indexExtensionsDuration;
            Duration duration5 = this.scanFilesDuration;
            Duration duration6 = this.suspendedDuration;
            int n = ((((((((((string != null ? string.hashCode() : 0) * 31 + (zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0)) * 31 + Long.hashCode(this.totalUpdatingTime)) * 31 + (zonedDateTime2 != null ? ((Object)zonedDateTime2).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + (duration3 != null ? ((Object)duration3).hashCode() : 0)) * 31 + (duration4 != null ? ((Object)duration4).hashCode() : 0)) * 31 + (duration5 != null ? ((Object)duration5).hashCode() : 0)) * 31 + (duration6 != null ? ((Object)duration6).hashCode() : 0)) * 31;
            int n2 = this.wasInterrupted ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexingTimes)) break block3;
                    IndexingTimes indexingTimes = (IndexingTimes)object;
                    if (!Intrinsics.areEqual((Object)this.indexingReason, (Object)indexingTimes.indexingReason) || !Intrinsics.areEqual((Object)this.updatingStart, (Object)indexingTimes.updatingStart) || this.totalUpdatingTime != indexingTimes.totalUpdatingTime || !Intrinsics.areEqual((Object)this.updatingEnd, (Object)indexingTimes.updatingEnd) || !Intrinsics.areEqual((Object)this.indexingDuration, (Object)indexingTimes.indexingDuration) || !Intrinsics.areEqual((Object)this.contentLoadingDuration, (Object)indexingTimes.contentLoadingDuration) || !Intrinsics.areEqual((Object)this.pushPropertiesDuration, (Object)indexingTimes.pushPropertiesDuration) || !Intrinsics.areEqual((Object)this.indexExtensionsDuration, (Object)indexingTimes.indexExtensionsDuration) || !Intrinsics.areEqual((Object)this.scanFilesDuration, (Object)indexingTimes.scanFilesDuration) || !Intrinsics.areEqual((Object)this.suspendedDuration, (Object)indexingTimes.suspendedDuration) || this.wasInterrupted != indexingTimes.wasInterrupted) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory$Companion;", "", "()V", "indexingSessionIdSequencer", "Ljava/util/concurrent/atomic/AtomicLong;", "getIndexingSessionIdSequencer", "()Ljava/util/concurrent/atomic/AtomicLong;", "intellij.platform.lang.impl"})
    private static final class Companion {
        @NotNull
        public final AtomicLong getIndexingSessionIdSequencer() {
            return indexingSessionIdSequencer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

