/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.events.DeletedVirtualFileStub;
import com.intellij.util.indexing.events.IndexedFilesListener;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ChangedFilesCollector
extends IndexedFilesListener {
    private static final Logger LOG = Logger.getInstance(ChangedFilesCollector.class);
    public static final boolean CLEAR_NON_INDEXABLE_FILE_DATA = SystemProperties.getBooleanProperty((String)"idea.indexes.clear.non.indexable.file.data", (boolean)true);
    private final IntObjectMap<VirtualFile> myFilesToUpdate = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private final AtomicInteger myProcessedEventIndex = new AtomicInteger();
    private final Phaser myWorkersFinishedSync = new Phaser(){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            return false;
        }
    };
    private final Executor myVfsEventsExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FileBasedIndex Vfs Event Processor");
    private final AtomicInteger myScheduledVfsEventsWorkers = new AtomicInteger();
    private final FileBasedIndexImpl myManager = (FileBasedIndexImpl)FileBasedIndex.getInstance();
    private final AtomicInteger myUpdatingFiles = new AtomicInteger();

    @Override
    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(0);
        }
        IndexingFlag.cleanProcessedFlagRecursively(file2);
        if (!contentChange) {
            this.myUpdatingFiles.incrementAndGet();
        }
        super.buildIndicesForFileRecursively(file2, contentChange);
        if (!contentChange && this.myUpdatingFiles.decrementAndGet() == 0) {
            this.myManager.incrementFilesModCount();
        }
    }

    @Override
    protected void iterateIndexableFiles(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator2) {
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(1);
        }
        if (iterator2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(2);
        }
        if (this.myManager.belongsToIndexableFiles(file2)) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file11) {
                    if (file11 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!ChangedFilesCollector.this.myManager.belongsToIndexableFiles(file11)) {
                        return false;
                    }
                    iterator2.processFile(file11);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file11", "com/intellij/util/indexing/events/ChangedFilesCollector$2", "visitFile"));
                }
            });
        }
    }

    public boolean isUpdateInProgress() {
        return this.myUpdatingFiles.get() > 0;
    }

    public void scheduleForUpdate(@NotNull VirtualFile file2) {
        Set<Project> projects;
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(3);
        }
        if (VfsEventsMerger.LOG != null) {
            VfsEventsMerger.LOG.info("File " + file2 + " is scheduled for update");
        }
        int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
        if (!(file2 instanceof DeletedVirtualFileStub) && (projects = this.myManager.getContainingProjects(file2)).isEmpty()) {
            this.removeNonIndexableFileData(file2, fileId);
            return;
        }
        this.myFilesToUpdate.put(fileId, (Object)file2);
    }

    public void removeScheduledFileFromUpdate(VirtualFile file2) {
        int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
        VirtualFile alreadyScheduledFile = (VirtualFile)this.myFilesToUpdate.get(fileId);
        if (!(alreadyScheduledFile instanceof DeletedVirtualFileStub)) {
            this.myFilesToUpdate.remove(fileId);
        }
    }

    public void removeFileIdFromFilesScheduledForUpdate(int fileId) {
        this.myFilesToUpdate.remove(fileId);
    }

    public boolean containsFileId(int fileId) {
        return this.myFilesToUpdate.containsKey(fileId);
    }

    public Stream<VirtualFile> getFilesToUpdate() {
        return this.myFilesToUpdate.values().stream();
    }

    public Collection<VirtualFile> getAllFilesToUpdate() {
        this.ensureUpToDate();
        if (this.myFilesToUpdate.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
    }

    public Collection<VirtualFile> getAllPossibleFilesToUpdate() {
        ReadAction.run(() -> this.processFilesInReadAction(info2 -> {
            this.myFilesToUpdate.put(info2.getFileId(), (Object)(info2.isFileRemoved() ? new DeletedVirtualFileStub((VirtualFileWithId)info2.getFile()) : info2.getFile()));
            return true;
        }));
        return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
    }

    public void clearFilesToUpdate() {
        this.myFilesToUpdate.clear();
    }

    @Override
    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            ChangedFilesCollector.$$$reportNull$$$0(4);
        }
        final boolean shouldCleanup = ContainerUtil.exists(events, ChangedFilesCollector::memoryStorageCleaningNeeded);
        final AsyncFileListener.ChangeApplier superApplier = super.prepareChange(events);
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                if (shouldCleanup) {
                    ChangedFilesCollector.this.myManager.cleanupMemoryStorage(false);
                }
                superApplier.beforeVfsChange();
            }

            public void afterVfsChange() {
                superApplier.afterVfsChange();
                RegisteredIndexes registeredIndexes = ChangedFilesCollector.this.myManager.getRegisteredIndexes();
                if (registeredIndexes != null && registeredIndexes.isInitialized()) {
                    ChangedFilesCollector.this.ensureUpToDateAsync();
                }
            }
        };
    }

    private void removeNonIndexableFileData(@NotNull VirtualFile file2, int fileId) {
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(5);
        }
        if (CLEAR_NON_INDEXABLE_FILE_DATA) {
            List<ID<?, ?>> extensions2 = this.getIndexedContentDependentExtensions(fileId);
            if (!extensions2.isEmpty()) {
                this.myManager.removeDataFromIndicesForFile(fileId, file2);
            }
            IndexingFlag.cleanProcessingFlag(file2);
        } else if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkNotIndexedByContentBasedIndexes(file2, fileId);
        }
    }

    private static boolean memoryStorageCleaningNeeded(@NotNull VFileEvent event) {
        Object requestor;
        if (event == null) {
            ChangedFilesCollector.$$$reportNull$$$0(6);
        }
        return (requestor = event.getRequestor()) instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
    }

    public boolean isScheduledForUpdate(VirtualFile file2) {
        return this.myFilesToUpdate.containsKey(FileBasedIndex.getFileId((VirtualFile)file2));
    }

    public void ensureUpToDate() {
        if (!IndexUpToDateCheckIn.isUpToDateCheckEnabled()) {
            return;
        }
        this.myManager.waitUntilIndicesAreInitialized();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            this.processFilesToUpdateInReadAction();
        } else {
            this.processFilesInReadActionWithYieldingToWriteAction();
        }
    }

    public void ensureUpToDateAsync() {
        if (this.getEventMerger().getApproximateChangesCount() >= 20 && this.myScheduledVfsEventsWorkers.compareAndSet(0, 1)) {
            this.myVfsEventsExecutor.execute(() -> {
                try {
                    this.processFilesInReadActionWithYieldingToWriteAction();
                }
                finally {
                    this.myScheduledVfsEventsWorkers.decrementAndGet();
                }
            });
            if (Registry.is((String)"try.starting.dumb.mode.where.many.files.changed")) {
                Runnable startDumbMode = () -> {
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        FileBasedIndexProjectHandler.scheduleReindexingInDumbMode(project);
                    }
                };
                Application app = ApplicationManager.getApplication();
                if (!app.isHeadlessEnvironment() && app.isDispatchThread() && !LaterInvocator.isInModalContext()) {
                    startDumbMode.run();
                } else {
                    app.invokeLater(startDumbMode, ModalityState.NON_MODAL);
                }
            }
        }
    }

    private void processFilesToUpdateInReadAction() {
        this.processFilesInReadAction(info2 -> {
            int fileId = info2.getFileId();
            VirtualFile file2 = info2.getFile();
            if (info2.isTransientStateChanged()) {
                this.myManager.doTransientStateChangeForFile(fileId, file2);
            }
            if (info2.isBeforeContentChanged()) {
                this.myManager.doInvalidateIndicesForFile(fileId, file2, true);
            }
            if (info2.isContentChanged()) {
                this.myManager.scheduleFileForIndexing(fileId, file2, true);
            }
            if (info2.isFileRemoved()) {
                this.myManager.doInvalidateIndicesForFile(fileId, file2, false);
            }
            if (info2.isFileAdded()) {
                this.myManager.scheduleFileForIndexing(fileId, file2, false);
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilesInReadAction(@NotNull VfsEventsMerger.VfsEventProcessor processor2) {
        if (processor2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(7);
        }
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        int publishedEventIndex = this.getEventMerger().getPublishedEventIndex();
        int processedEventIndex = this.myProcessedEventIndex.get();
        if (processedEventIndex == publishedEventIndex) {
            return;
        }
        this.myWorkersFinishedSync.register();
        int phase = this.myWorkersFinishedSync.getPhase();
        try {
            this.myManager.waitUntilIndicesAreInitialized();
            this.getEventMerger().processChanges(info2 -> (Boolean)ConcurrencyUtil.withLock((Lock)this.myManager.myWriteLock, () -> {
                try {
                    ProgressManager.getInstance().executeNonCancelableSection(() -> processor2.process(info2));
                }
                finally {
                    IndexingStamp.flushCache(info2.getFileId());
                }
                return true;
            }));
        }
        finally {
            this.myWorkersFinishedSync.arriveAndDeregister();
        }
        try {
            this.myWorkersFinishedSync.awaitAdvance(phase);
        }
        catch (RejectedExecutionException e) {
            LOG.warn((Throwable)e);
            throw new ProcessCanceledException((Throwable)e);
        }
        if (this.getEventMerger().getPublishedEventIndex() == publishedEventIndex) {
            this.myProcessedEventIndex.compareAndSet(processedEventIndex, publishedEventIndex);
        }
    }

    private void processFilesInReadActionWithYieldingToWriteAction() {
        while (this.getEventMerger().hasChanges()) {
            ReadAction.nonBlocking(() -> this.processFilesToUpdateInReadAction()).executeSynchronously();
        }
    }

    private void checkNotIndexedByContentBasedIndexes(@NotNull VirtualFile file2, int fileId) {
        List<ID<?, ?>> contentDependentIndexes;
        if (file2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(8);
        }
        if (!(contentDependentIndexes = this.getIndexedContentDependentExtensions(fileId)).isEmpty()) {
            LOG.error("indexes " + contentDependentIndexes + " will not be updated for file = " + file2 + ", id = " + fileId);
        }
    }

    @NotNull
    private List<ID<?, ?>> getIndexedContentDependentExtensions(int fileId) {
        List contentDependentIndexes;
        List<ID<?, ?>> indexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        RegisteredIndexes registeredIndexes = this.myManager.getRegisteredIndexes();
        if (registeredIndexes == null) {
            Set allContentDependentIndexes = FileBasedIndexExtension.EXTENSION_POINT_NAME.extensions().filter(ex -> ex.dependsOnFileContent()).map(ex -> ex.getName()).collect(Collectors.toSet());
            contentDependentIndexes = ContainerUtil.filter(indexedStates, id2 -> !allContentDependentIndexes.contains(id2));
        } else {
            contentDependentIndexes = ContainerUtil.filter(indexedStates, id2 -> registeredIndexes.isContentDependentIndex((ID<?, ?>)id2));
        }
        List list2 = contentDependentIndexes;
        if (list2 == null) {
            ChangedFilesCollector.$$$reportNull$$$0(9);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public void waitForVfsEventsExecuted(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        void unit;
        if (timeUnit == null) {
            ChangedFilesCollector.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (System.nanoTime() < deadline) {
            try {
                ((BoundedTaskExecutor)this.myVfsEventsExecutor).waitAllTasksExecuted(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/ChangedFilesCollector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/ChangedFilesCollector";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedContentDependentExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildIndicesForFileRecursively";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleForUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeNonIndexableFileData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "memoryStorageCleaningNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInReadAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkNotIndexedByContentBasedIndexes";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitForVfsEventsExecuted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

