/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomHighlightingHelperImpl
extends DomHighlightingHelper {
    public static final DomHighlightingHelperImpl INSTANCE = new DomHighlightingHelperImpl();
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();
    private final DomApplicationComponent myDomApplicationComponent = DomApplicationComponent.getInstance();

    public void runAnnotators(DomElement element2, DomElementAnnotationHolder holder, Class<? extends DomElement> rootClass) {
        DomElementsAnnotator annotator = this.myDomApplicationComponent.getAnnotator(rootClass);
        if (annotator != null) {
            annotator.annotate(element2, holder);
        }
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkRequired(DomElement element2, DomElementAnnotationHolder holder) {
        Required required = (Required)element2.getAnnotation(Required.class);
        if (required != null) {
            XmlElement xmlElement = element2.getXmlElement();
            if (xmlElement == null) {
                if (required.value()) {
                    String xmlElementName = element2.getXmlElementName();
                    String namespace = element2.getXmlElementNamespace();
                    if (element2 instanceof GenericAttributeValue) {
                        List<DomElementProblemDescriptor> list2 = Collections.singletonList(holder.createProblem(element2, XmlDomBundle.message((String)"dom.inspections.attribute.0.should.be.defined", (Object[])new Object[]{xmlElementName}), new LocalQuickFix[]{new DefineAttributeQuickFix(xmlElementName, namespace)}));
                        if (list2 == null) {
                            DomHighlightingHelperImpl.$$$reportNull$$$0(0);
                        }
                        return list2;
                    }
                    List<DomElementProblemDescriptor> list3 = Collections.singletonList(holder.createProblem(element2, HighlightSeverity.ERROR, XmlDomBundle.message((String)"dom.inspections.child.tag.0.should.be.defined", (Object[])new Object[]{xmlElementName}), new LocalQuickFix[]{new AddRequiredSubtagFix(xmlElementName, namespace)}));
                    if (list3 == null) {
                        DomHighlightingHelperImpl.$$$reportNull$$$0(1);
                    }
                    return list3;
                }
            } else if (element2 instanceof GenericDomValue) {
                List list4 = ContainerUtil.createMaybeSingletonList((Object)DomHighlightingHelperImpl.checkRequiredGenericValue((GenericDomValue)element2, required, holder));
                if (list4 == null) {
                    DomHighlightingHelperImpl.$$$reportNull$$$0(2);
                }
                return list4;
            }
        }
        if (DomUtil.hasXml((DomElement)element2)) {
            SmartList list5 = new SmartList();
            DomGenericInfo info2 = element2.getGenericInfo();
            for (AbstractDomChildrenDescription description2 : info2.getChildrenDescriptions()) {
                if (!(description2 instanceof DomCollectionChildDescription) || !description2.getValues(element2).isEmpty()) continue;
                DomCollectionChildDescription childDescription = (DomCollectionChildDescription)description2;
                Required annotation = (Required)description2.getAnnotation(Required.class);
                if (annotation == null || !annotation.value()) continue;
                list5.add((Object)holder.createProblem(element2, childDescription, XmlDomBundle.message((String)"dom.inspections.child.tag.0.should.be.defined", (Object[])new Object[]{((DomCollectionChildDescription)description2).getXmlElementName()})));
            }
            SmartList smartList = list5;
            if (smartList == null) {
                DomHighlightingHelperImpl.$$$reportNull$$$0(3);
            }
            return smartList;
        }
        List<DomElementProblemDescriptor> list6 = Collections.emptyList();
        if (list6 == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(4);
        }
        return list6;
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkResolveProblems(GenericDomValue element2, DomElementAnnotationHolder holder) {
        Required required;
        if (StringUtil.isEmpty((String)element2.getStringValue()) && (required = (Required)element2.getAnnotation(Required.class)) != null && !required.nonEmpty()) {
            List<DomElementProblemDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                DomHighlightingHelperImpl.$$$reportNull$$$0(5);
            }
            return list2;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)element2);
        if (valueElement != null && !DomHighlightingHelperImpl.isSoftReference(element2)) {
            String errorMessage;
            SmartList list3 = new SmartList();
            Object[] psiReferences = this.myProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext());
            GenericDomValueReference domReference = (GenericDomValueReference)((Object)ContainerUtil.findInstance((Object[])psiReferences, GenericDomValueReference.class));
            Converter converter = WrappingConverter.getDeepestConverter((Converter)element2.getConverter(), (GenericDomValue)element2);
            boolean hasBadResolve = false;
            if (domReference == null || !DomHighlightingHelperImpl.isDomResolveOK(element2, domReference, converter)) {
                for (Object reference2 : psiReferences) {
                    if (reference2 == domReference || !DomHighlightingHelperImpl.hasBadResolve((PsiReference)reference2)) continue;
                    hasBadResolve = true;
                    list3.add((Object)holder.createResolveProblem(element2, (PsiReference)reference2));
                }
                boolean isResolvingConverter = converter instanceof ResolvingConverter;
                if (!hasBadResolve && (domReference != null || isResolvingConverter && DomHighlightingHelperImpl.hasBadResolve(domReference = new GenericDomValueReference(element2)))) {
                    hasBadResolve = true;
                    String errorMessage2 = converter.getErrorMessage(element2.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element2)));
                    if (errorMessage2 != null) {
                        list3.add((Object)holder.createResolveProblem(element2, domReference));
                    }
                }
            }
            if (!hasBadResolve && psiReferences.length == 0 && element2.getValue() == null && !PsiTreeUtil.hasErrorElements((PsiElement)valueElement) && (errorMessage = converter.getErrorMessage(element2.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element2)))) != null) {
                list3.add((Object)holder.createProblem((DomElement)element2, errorMessage, new LocalQuickFix[0]));
            }
            SmartList smartList = list3;
            if (smartList == null) {
                DomHighlightingHelperImpl.$$$reportNull$$$0(6);
            }
            return smartList;
        }
        List<DomElementProblemDescriptor> list4 = Collections.emptyList();
        if (list4 == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(7);
        }
        return list4;
    }

    private static boolean isDomResolveOK(GenericDomValue element2, GenericDomValueReference domReference, Converter converter) {
        return !DomHighlightingHelperImpl.hasBadResolve((PsiReference)domReference) || converter instanceof ResolvingConverter && ((ResolvingConverter)converter).getAdditionalVariants(domReference.getConvertContext()).contains(element2.getStringValue());
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkNameIdentity(DomElement element2, DomElementAnnotationHolder holder) {
        DomElement domElement;
        String elementName = ElementPresentationManager.getElementName((Object)element2);
        if (StringUtil.isNotEmpty((String)elementName) && (domElement = DomUtil.findDuplicateNamedValue((DomElement)element2, (String)elementName)) != null) {
            String typeName = ElementPresentationManager.getTypeNameForObject((Object)element2);
            GenericDomValue genericDomValue = domElement.getGenericInfo().getNameDomElement(element2);
            if (genericDomValue != null) {
                List<DomElementProblemDescriptor> list2 = Collections.singletonList(holder.createProblem((DomElement)genericDomValue, DomUtil.getFile((DomElement)domElement).equals(DomUtil.getFile((DomElement)element2)) ? XmlDomBundle.message((String)"dom.inspections.identity", (Object[])new Object[]{typeName}) : XmlDomBundle.message((String)"dom.inspections.identity.in.other.file", (Object[])new Object[]{typeName, domElement.getXmlTag().getContainingFile().getName()}), new LocalQuickFix[0]));
                if (list2 == null) {
                    DomHighlightingHelperImpl.$$$reportNull$$$0(8);
                }
                return list2;
            }
        }
        List<DomElementProblemDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(9);
        }
        return list3;
    }

    private static boolean hasBadResolve(PsiReference reference2) {
        return XmlHighlightVisitor.hasBadResolve(reference2, true);
    }

    private static boolean isSoftReference(GenericDomValue value2) {
        Resolve resolve2 = (Resolve)value2.getAnnotation(Resolve.class);
        if (resolve2 != null && resolve2.soft()) {
            return true;
        }
        Convert convert2 = (Convert)value2.getAnnotation(Convert.class);
        if (convert2 != null && convert2.soft()) {
            return true;
        }
        Referencing referencing = (Referencing)value2.getAnnotation(Referencing.class);
        return referencing != null && referencing.soft();
    }

    @Nullable
    private static DomElementProblemDescriptor checkRequiredGenericValue(GenericDomValue child2, Required required, DomElementAnnotationHolder annotator) {
        String stringValue = child2.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (required.nonEmpty() && DomHighlightingHelperImpl.isEmpty(child2, stringValue)) {
            return annotator.createProblem((DomElement)child2, XmlDomBundle.message((String)"dom.inspections.value.must.not.be.empty", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        if (required.identifier() && !DomHighlightingHelperImpl.isIdentifier(stringValue)) {
            return annotator.createProblem((DomElement)child2, XmlDomBundle.message((String)"dom.inspections.value.must.be.identifier", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        return null;
    }

    private static boolean isIdentifier(String s) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < s.length(); ++i2) {
            if (Character.isJavaIdentifierPart(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(GenericDomValue child2, String stringValue) {
        XmlAttributeValue value2;
        if (stringValue.trim().length() != 0) {
            return false;
        }
        return !(child2 instanceof GenericAttributeValue) || (value2 = ((GenericAttributeValue)child2).getXmlAttributeValue()) == null || !value2.getTextRange().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRequired";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkResolveProblems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNameIdentity";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class AddRequiredSubtagFix
    implements LocalQuickFix {
        private final String tagName;
        private final String tagNamespace;

        private AddRequiredSubtagFix(@NotNull String _tagName, @NotNull String _tagNamespace) {
            if (_tagName == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(0);
            }
            if (_tagNamespace == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(1);
            }
            this.tagName = _tagName;
            this.tagNamespace = _tagNamespace;
        }

        @NotNull
        public String getName() {
            String string = XmlDomBundle.message((String)"dom.quickfix.insert.required.tag.text", (Object[])new Object[]{this.tagName});
            if (string == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlDomBundle.message((String)"dom.quickfix.insert.required.tag.family", (Object[])new Object[0]);
            if (string == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            XmlTag tag2;
            if (project == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(5);
            }
            if ((tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), XmlTag.class, (boolean)false)) != null) {
                this.doFix(tag2);
            }
        }

        private void doFix(XmlTag parentTag) {
            parentTag.add((PsiElement)parentTag.createChildTag(this.tagName, this.tagNamespace, null, false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_tagName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_tagNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

