/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.RollbackLineStatusAction;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u001e\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/RollbackCurrentLineIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/util/Iconable;", "()V", "getFamilyName", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "getValidTrackerOrNull", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "invoke", "", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.platform.vcs.impl"})
public final class RollbackCurrentLineIntention
implements IntentionAction,
LowPriorityAction,
DumbAware,
Iconable {
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null) {
            return false;
        }
        LineStatusTracker<?> tracker2 = this.getValidTrackerOrNull(project, editor);
        if (tracker2 == null) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        Caret caret2 = caret;
        BitSet lines2 = new BitSet();
        if (caret2.hasSelection()) {
            int startLine = editor.getDocument().getLineNumber(caret2.getSelectionStart());
            int endLine = editor.getDocument().getLineNumber(caret2.getSelectionEnd());
            lines2.set(startLine, endLine);
        } else {
            int currentLine = editor.getDocument().getLineNumber(caret2.getOffset());
            lines2.set(currentLine);
        }
        List list2 = tracker2.getRangesForLines(lines2);
        if (list2 != null) {
            Collection collection = list2;
            boolean bl2 = false;
            bl = !collection.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null) {
            return;
        }
        LineStatusTracker<?> tracker2 = this.getValidTrackerOrNull(project, editor);
        if (tracker2 == null) {
            return;
        }
        RollbackLineStatusAction.rollback((LineStatusTrackerI)tracker2, editor);
    }

    private final LineStatusTracker<?> getValidTrackerOrNull(Project project, Editor editor) {
        LineStatusTracker<?> tracker2 = LineStatusTrackerManager.Companion.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (tracker2 == null || !tracker2.isValid() || !tracker2.isAvailableAt(editor)) {
            return null;
        }
        return tracker2;
    }

    @NotNull
    public String getText() {
        String string = VcsBundle.message((String)"intention.name.rollback.changes.in.current.line", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"inten\u2026changes.in.current.line\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon2 = AllIcons.Actions.Rollback;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Rollback");
        return icon2;
    }
}

