/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.changes;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DefaultSearchScopeProviders;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.vcs.changes.ChangeListsScopesProvider;
import com.intellij.vcs.changes.VcsChangesLocalSearchScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/changes/ChangeListsSearchScopeProvider;", "Lcom/intellij/psi/search/SearchScopeProvider;", "()V", "getDisplayName", "", "getSearchScopes", "", "Lcom/intellij/psi/search/SearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.vcs.impl"})
public final class ChangeListsSearchScopeProvider
implements SearchScopeProvider {
    @Override
    @Nullable
    public String getDisplayName() {
        return VcsBundle.message((String)"change.list.scope.provider.local.changes", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<SearchScope> getSearchScopes(@NotNull Project project, @NotNull DataContext dataContext) {
        PsiFile psiFile;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        List result2 = new ArrayList();
        ChangeListsScopesProvider changeListsScopesProvider = ChangeListsScopesProvider.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListsScopesProvider), (String)"ChangeListsScopesProvider.getInstance(project)");
        List list2 = changeListsScopesProvider.getFilteredScopes();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ChangeListsScopesProvide\u2026e(project).filteredScopes");
        List changeLists = list2;
        if (!changeLists.isEmpty()) {
            iterator2 = changeLists.iterator();
            while (iterator2.hasNext()) {
                NamedScope changeListScope;
                NamedScope namedScope = changeListScope = (NamedScope)iterator2.next();
                Intrinsics.checkNotNull((Object)namedScope);
                GlobalSearchScope globalSearchScope = DefaultSearchScopeProviders.wrapNamedScope(project, namedScope, false);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"DefaultSearchScopeProvid\u2026changeListScope!!, false)");
                result2.add(globalSearchScope);
            }
        }
        String string = VcsBundle.message((String)"change.list.scope.provider.only.changes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"chang\u2026e.provider.only.changes\")");
        result2.add(new VcsChangesLocalSearchScope(project, string, null, false));
        PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile2 == null) {
            Editor editor;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isDispatchThread()) {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                editor = fileEditorManager.getSelectedTextEditor();
            } else {
                editor = null;
            }
            if (editor != null) {
                iterator2 = editor;
                boolean bl = false;
                boolean bl2 = false;
                Iterator it = iterator2;
                boolean bl3 = false;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                Iterator iterator3 = it;
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"it");
                psiFile2 = psiDocumentManager.getPsiFile(iterator3.getDocument());
            } else {
                psiFile2 = psiFile = null;
            }
        }
        if (psiFile != null) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = virtualFile2 = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile");
            String string2 = virtualFile2.getPresentableUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"virtualFile.presentableUrl");
            String localUrl = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile3, (String)string2, (Project)project, (boolean)true, (boolean)false);
            String string3 = VcsBundle.message((String)"change.list.scope.provider.only.changes.in.file", (Object[])new Object[]{localUrl});
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VcsBundle.message(\"chang\u2026anges.in.file\", localUrl)");
            result2.add(new VcsChangesLocalSearchScope(project, string3, new VirtualFile[]{virtualFile2}, false));
        }
        return result2;
    }
}

