/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorFacade;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import com.intellij.vcs.commit.message.BodyLimitInspectionOptions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BodyLimitInspection
extends BaseCommitMessageInspection {
    public int RIGHT_MARGIN = 72;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = VcsBundle.message((String)"inspection.BodyLimitInspection.display.name", (Object[])new Object[0]);
        if (string == null) {
            BodyLimitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public ConfigurableUi<Project> createOptionsConfigurable() {
        return new BodyLimitInspectionOptions(this);
    }

    @Override
    protected ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager2, boolean isOnTheFly) {
        if (file2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(1);
        }
        if (document == null) {
            BodyLimitInspection.$$$reportNull$$$0(2);
        }
        if (manager2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(3);
        }
        return (ProblemDescriptor[])IntStream.range(1, document.getLineCount()).mapToObj(line -> {
            String problemText = VcsBundle.message((String)"commit.message.inspection.message.body.lines.should.not.exceed.characters", (Object[])new Object[]{this.RIGHT_MARGIN});
            return BodyLimitInspection.checkRightMargin(file2, document, manager2, isOnTheFly, line, this.RIGHT_MARGIN, problemText, new WrapLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix());
        }).filter(Objects::nonNull).toArray(ProblemDescriptor[]::new);
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            BodyLimitInspection.$$$reportNull$$$0(4);
        }
        if (document == null) {
            BodyLimitInspection.$$$reportNull$$$0(5);
        }
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            BodyLimitInspection.$$$reportNull$$$0(6);
        }
        if (document == null) {
            BodyLimitInspection.$$$reportNull$$$0(7);
        }
        new WrapLineQuickFix().doApplyFix(project, document, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/message/BodyLimitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/message/BodyLimitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canReformat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class WrapLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected WrapLineQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = VcsBundle.message((String)"commit.message.intention.family.name.wrap.line", (Object[])new Object[0]);
            if (string == null) {
                WrapLineQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor2) {
            Editor editor;
            if (project == null) {
                WrapLineQuickFix.$$$reportNull$$$0(1);
            }
            if (document == null) {
                WrapLineQuickFix.$$$reportNull$$$0(2);
            }
            if ((editor = CommitMessage.getEditor(document)) != null) {
                TextRange range2;
                TextRange textRange = range2 = descriptor2 != null && descriptor2.getLineNumber() >= 0 ? DocumentUtil.getLineTextRange(document, descriptor2.getLineNumber()) : this.getBodyRange(document);
                if (!range2.isEmpty()) {
                    this.wrapLines(project, editor, document, BodyLimitInspection.this.RIGHT_MARGIN, range2);
                }
            }
        }

        @NotNull
        private TextRange getBodyRange(@NotNull Document document) {
            if (document == null) {
                WrapLineQuickFix.$$$reportNull$$$0(3);
            }
            TextRange textRange = document.getLineCount() > 1 ? TextRange.create((int)document.getLineStartOffset(1), (int)document.getTextLength()) : TextRange.EMPTY_RANGE;
            if (textRange == null) {
                WrapLineQuickFix.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        private void wrapLines(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, int rightMargin, @NotNull TextRange range2) {
            if (project == null) {
                WrapLineQuickFix.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                WrapLineQuickFix.$$$reportNull$$$0(6);
            }
            if (document == null) {
                WrapLineQuickFix.$$$reportNull$$$0(7);
            }
            if (range2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(8);
            }
            List<TextRange> enabledRanges = Collections.singletonList(TextRange.create((int)0, (int)document.getTextLength()));
            EditorFacade.getInstance().doWrapLongLinesIfNecessary(editor, project, document, range2.getStartOffset(), range2.getEndOffset(), enabledRanges, rightMargin);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/message/BodyLimitInspection$WrapLineQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/message/BodyLimitInspection$WrapLineQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBodyRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getBodyRange";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapLines";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

