/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public RefreshLogAction() {
        super(VcsLogBundle.message((String)"action.name.refresh.log", (Object[])new Object[0]), VcsLogBundle.message((String)"action.description.refresh.log", (Object[])new Object[0]), AllIcons.Actions.Refresh);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        VisiblePackRefresher refresher;
        if (e == null) {
            RefreshLogAction.$$$reportNull$$$0(0);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogManager logManager = (VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER);
        VcsLogUi ui2 = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui2 instanceof VcsLogUiEx && !(refresher = ((VcsLogUiEx)ui2).getRefresher()).isValid()) {
            String message2 = "Trying to refresh invalid log tab '" + ui2.getId() + "'.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message2, RefreshLogAction.collectDiagnosticInformation(e.getProject(), logManager));
            } else {
                LOG.warn(message2);
            }
            refresher.setValid(true, false);
        }
        logManager.getDataManager().refresh(VcsLogUtil.getVisibleRoots(ui2));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshLogAction.$$$reportNull$$$0(1);
        }
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && e.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }

    private static Attachment @NotNull [] collectDiagnosticInformation(@Nullable Project project, @NotNull VcsLogManager logManager) {
        ToolWindow toolWindow;
        if (logManager == null) {
            RefreshLogAction.$$$reportNull$$$0(2);
        }
        ArrayList<Attachment> result2 = new ArrayList<Attachment>();
        result2.add(new Attachment("log-windows.txt", "Log Windows:\n" + logManager.getLogWindowsInformation()));
        if (project != null && (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control")) != null) {
            String contentDump = StringUtil.join((Object[])toolWindow.getContentManager().getContents(), content2 -> {
                if (content2 instanceof TabbedContent) {
                    return content2 + ", tabs=[" + StringUtil.join((Collection)((TabbedContent)content2).getTabs(), pair -> (String)pair.first, (String)", ") + "]";
                }
                return content2.toString();
            }, (String)"\n");
            result2.add(new Attachment("vcs-tool-window-content.txt", "Tool Window " + toolWindow.getTitle() + " (" + toolWindow.getType() + "):\n" + contentDump));
        }
        Attachment[] attachmentArray = result2.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            RefreshLogAction.$$$reportNull$$$0(3);
        }
        return attachmentArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/RefreshLogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/RefreshLogAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDiagnosticInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectDiagnosticInformation";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

