/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.IOUtil;
import com.intellij.vcs.log.util.PersistentUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001a\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0007R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/util/StorageId;", "", "projectName", "", "subdirName", "logId", "version", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "projectStorageDir", "Ljava/io/File;", "getProjectStorageDir", "()Ljava/io/File;", "projectStorageDir$delegate", "Lkotlin/Lazy;", "safeProjectName", "getVersion", "()I", "cleanupAllStorageFiles", "", "doGetRealStorageFile", "Ljava/nio/file/Path;", "kind", "forMapIndexStorage", "doGetStorageFile", "getStorageFile", "intellij.platform.vcs.log.impl"})
public final class StorageId {
    private final String safeProjectName;
    @NotNull
    private final Lazy projectStorageDir$delegate;
    private final String projectName;
    private final String subdirName;
    private final String logId;
    private final int version;

    @NotNull
    public final File getProjectStorageDir() {
        Lazy lazy = this.projectStorageDir$delegate;
        StorageId storageId = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Path getStorageFile(@NotNull String kind, boolean forMapIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Path storageFile = this.doGetRealStorageFile(kind, forMapIndexStorage);
        if (!Files.exists(storageFile, new LinkOption[0])) {
            int n = 0;
            int n2 = this.version;
            while (n < n2) {
                void oldVersion;
                Path oldStorageFile = new StorageId(this.projectName, this.subdirName, this.logId, (int)oldVersion).doGetRealStorageFile(kind, forMapIndexStorage);
                IOUtil.deleteAllFilesStartingWith((Path)oldStorageFile);
                ++oldVersion;
            }
        }
        return this.doGetStorageFile(kind);
    }

    public static /* synthetic */ Path getStorageFile$default(StorageId storageId, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return storageId.getStorageFile(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final Path getStorageFile(@NotNull String kind) {
        return StorageId.getStorageFile$default(this, kind, false, 2, null);
    }

    private final Path doGetRealStorageFile(String kind, boolean forMapIndexStorage) {
        Path storageFile = this.doGetStorageFile(kind);
        if (!forMapIndexStorage) {
            return storageFile;
        }
        Path path2 = MapIndexStorage.getIndexStorageFile((Path)storageFile);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"MapIndexStorage.getIndexStorageFile(storageFile)");
        return path2;
    }

    private final Path doGetStorageFile(String kind) {
        Path path2 = new File(this.getProjectStorageDir(), kind + '.' + this.version).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"File(projectStorageDir, \"$kind.$version\").toPath()");
        return path2;
    }

    public final boolean cleanupAllStorageFiles() {
        return FileUtil.deleteWithRenaming((File)this.getProjectStorageDir());
    }

    public final int getVersion() {
        return this.version;
    }

    public StorageId(@NonNls @NotNull String projectName, @NonNls @NotNull String subdirName, @NotNull String logId, int version2) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)subdirName, (String)"subdirName");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        this.projectName = projectName;
        this.subdirName = subdirName;
        this.logId = logId;
        this.version = version2;
        String string = PathUtilRt.suggestFileName((String)(StringsKt.take((String)this.projectName, (int)7) + '.' + this.logId), (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtilRt.suggestFileNa\u2026)}.$logId\", false, false)");
        this.safeProjectName = string;
        this.projectStorageDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ StorageId this$0;

            @NotNull
            public final File invoke() {
                return new File(new File(PersistentUtil.LOG_CACHE, StorageId.access$getSubdirName$p(this.this$0)), StorageId.access$getSafeProjectName$p(this.this$0));
            }
            {
                this.this$0 = storageId;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$getSubdirName$p(StorageId $this) {
        return $this.subdirName;
    }

    public static final /* synthetic */ String access$getSafeProjectName$p(StorageId $this) {
        return $this.safeProjectName;
    }
}

