/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.CatchingConsumer;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageManagementService {
    @Nullable
    public List<String> getAllRepositories() {
        return null;
    }

    public void fetchAllRepositories(@NotNull CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        if (consumer == null) {
            PackageManagementService.$$$reportNull$$$0(0);
        }
        consumer.consume(this.getAllRepositories());
    }

    public boolean canManageRepositories() {
        return this.getAllRepositories() != null;
    }

    public boolean canModifyRepository(String repositoryUrl) {
        return true;
    }

    public void addRepository(String repositoryUrl) {
    }

    public void removeRepository(String repositoryUrl) {
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PackageManagementService.$$$reportNull$$$0(1);
        }
        if (version2 == null) {
            PackageManagementService.$$$reportNull$$$0(2);
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
    }

    public abstract List<RepoPackage> getAllPackages() throws IOException;

    public abstract List<RepoPackage> reloadAllPackages() throws IOException;

    public List<RepoPackage> getAllPackagesCached() {
        return Collections.emptyList();
    }

    public boolean canInstallToUser() {
        return false;
    }

    @NlsContexts.Button
    public String getInstallToUserText() {
        return "";
    }

    public boolean isInstallToUserSelected() {
        return false;
    }

    public void installToUserChanged(boolean newValue2) {
    }

    @NotNull
    public List<? extends InstalledPackage> getInstalledPackagesList() throws ExecutionException {
        try {
            return new ArrayList<InstalledPackage>(this.getInstalledPackages());
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        throw new AbstractMethodError("The method is deprecated. Please use `getInstalledPackagesList`.");
    }

    public abstract void installPackage(RepoPackage var1, @Nullable String var2, boolean var3, @Nullable String var4, Listener var5, boolean var6);

    public abstract void uninstallPackages(List<InstalledPackage> var1, Listener var2);

    public abstract void fetchPackageVersions(String var1, CatchingConsumer<List<String>, Exception> var2);

    public abstract void fetchPackageDetails(String var1, CatchingConsumer<@Nls String, Exception> var2);

    @Nullable
    @NonNls
    public String getID() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/packaging/PackageManagementService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchAllRepositories";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareVersions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ErrorDescription {
        @NotNull
        private final @NlsContexts.DetailedDescription String myMessage;
        @Nullable
        private final String myCommand;
        @Nullable
        private final String myOutput;
        @Nullable
        private final @NlsContexts.DetailedDescription String mySolution;

        @Nullable
        public static ErrorDescription fromMessage(@Nullable @NlsContexts.DetailedDescription String message2) {
            return message2 != null ? new ErrorDescription(message2, null, null, null) : null;
        }

        public ErrorDescription(@NotNull @NlsContexts.DetailedDescription String message2, @NlsSafe @Nullable String command, @NlsSafe @Nullable String output2, @Nullable @NlsContexts.DetailedDescription String solution) {
            if (message2 == null) {
                ErrorDescription.$$$reportNull$$$0(0);
            }
            this.myMessage = message2;
            this.myCommand = command;
            this.myOutput = output2;
            this.mySolution = solution;
        }

        @NotNull
        @NlsContexts.DetailedDescription
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                ErrorDescription.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        @NlsSafe
        public String getCommand() {
            return this.myCommand;
        }

        @Nullable
        @NlsSafe
        public String getOutput() {
            return this.myOutput;
        }

        @Nullable
        @NlsContexts.DetailedDescription
        public String getSolution() {
            return this.mySolution;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/packaging/PackageManagementService$ErrorDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/packaging/PackageManagementService$ErrorDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void operationStarted(String var1);

        public void operationFinished(String var1, @Nullable ErrorDescription var2);
    }
}

