/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.Compressor;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.ExternalEntityMapping;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.AbstractRefsTable;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityId;
import com.intellij.workspaceModel.storage.impl.EntityReferenceImpl;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.workspaceModel.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.workspaceModel.storage.impl.containers.NonNegativeIntIntBiMap;
import com.intellij.workspaceModel.storage.impl.external.EmptyExternalEntityMapping;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 _2\u00020\u0001:\u0001_B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J?\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#H\u0002J&\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0,2\u0006\u0010-\u001a\u00020\u001aH\u0002J,\u0010.\u001a\u00020\u00162\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%002\f\u00101\u001a\b\u0012\u0004\u0012\u00020#002\u0006\u0010-\u001a\u00020\u001aH\u0002J \u00102\u001a\u00020\u00162\u0006\u0010/\u001a\u0002032\u0006\u0010*\u001a\u00020#2\u0006\u00104\u001a\u00020#H\u0002J%\u00105\u001a\b\u0012\u0004\u0012\u0002H706\"\b\b\u0000\u00107*\u0002082\u0006\u00109\u001a\u0002H7H\u0016\u00a2\u0006\u0002\u0010:J&\u0010;\u001a\b\u0012\u0004\u0012\u0002H70<\"\b\b\u0000\u00107*\u0002082\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H70>H\u0016J \u0010?\u001a\u00020#\"\b\b\u0000\u00107*\u0002082\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H70>H\u0016JB\u0010@\u001a(\u0012\u0004\u0012\u00020\u001d\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002080>\u0012\n\u0012\b\u0012\u0004\u0012\u0002080B0A0A2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\u001cH\u0016J\u001f\u0010C\u001a\f\u0012\u0006\b\u0001\u0012\u000208\u0018\u00010D2\u0006\u0010(\u001a\u00020%H\u0000\u00a2\u0006\u0002\bEJ\u001d\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u0002080D2\u0006\u0010(\u001a\u00020%H\u0000\u00a2\u0006\u0002\bGJ\u001c\u0010H\u001a\b\u0012\u0004\u0012\u0002HJ0I\"\u0004\b\u0000\u0010J2\u0006\u0010K\u001a\u00020\u001aH\u0016J\b\u0010L\u001a\u00020MH\u0016JW\u0010N\u001a\b\u0012\u0004\u0012\u0002HO0<\"\b\b\u0000\u00107*\u000208\"\b\b\u0001\u0010O*\u0002082\u0006\u00109\u001a\u0002H72\f\u0010=\u001a\b\u0012\u0004\u0012\u0002HO0P2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u0002HO\u0012\n\u0012\b\u0012\u0004\u0012\u0002H7060RH\u0016\u00a2\u0006\u0002\u0010SJ>\u0010N\u001a\b\u0012\u0004\u0012\u0002HO0<\"\b\b\u0000\u00107*\u00020T\"\b\b\u0001\u0010O*\u0002082\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H70U2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002HO0>H\u0016JH\u0010V\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00109\u001a\u00020W2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010X\u001a\u00020\u0001J'\u0010Y\u001a\u0004\u0018\u0001H7\"\b\b\u0000\u00107*\u00020T2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H70UH\u0016\u00a2\u0006\u0002\u0010ZJ.\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010]\u001a\u00020^2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010X\u001a\u00020\u0001H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0002`a\u00a8\u0006b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "()V", "brokenConsistency", "", "getBrokenConsistency$intellij_platform_workspaceModel_storage", "()Z", "setBrokenConsistency$intellij_platform_workspaceModel_storage", "(Z)V", "entitiesByType", "Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "getEntitiesByType$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "indexes", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "getIndexes$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "refs", "Lcom/intellij/workspaceModel/storage/impl/AbstractRefsTable;", "getRefs$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/AbstractRefsTable;", "assertConsistency", "", "assertConsistency$intellij_platform_workspaceModel_storage", "assertConsistencyInStrictMode", "message", "", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "left", "right", "assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage", "assertCorrectEntityClass", "connectionClass", "", "entityId", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "assertResolvable", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "createReference", "Lcom/intellij/workspaceModel/storage/EntityReference;", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "e", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;)Lcom/intellij/workspaceModel/storage/EntityReference;", "entities", "Lkotlin/sequences/Sequence;", "entityClass", "Ljava/lang/Class;", "entitiesAmount", "entitiesBySource", "", "", "entityDataById", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "entityDataById$intellij_platform_workspaceModel_storage", "entityDataByIdOrDie", "entityDataByIdOrDie$intellij_platform_workspaceModel_storage", "getExternalMapping", "Lcom/intellij/workspaceModel/storage/ExternalEntityMapping;", "T", "identifier", "getVirtualFileUrlIndex", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlIndex;", "referrers", "R", "Lkotlin/reflect/KClass;", "property", "Lkotlin/reflect/KProperty1;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lkotlin/reflect/KClass;Lkotlin/reflect/KProperty1;)Lkotlin/sequences/Sequence;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithPersistentId;", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "reportConsistencyIssue", "", "resulting", "resolve", "(Lcom/intellij/workspaceModel/storage/PersistentEntityId;)Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithPersistentId;", "serializeContentToFolder", "Ljava/io/File;", "contentFolder", "Ljava/nio/file/Path;", "Companion", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageImpl;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "intellij.platform.workspaceModel.storage"})
public abstract class AbstractEntityStorage
implements WorkspaceEntityStorage {
    private boolean brokenConsistency;
    @NotNull
    private static final Logger LOG;
    private static final ExecutorService consistencyChecker;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract EntitiesBarrel getEntitiesByType$intellij_platform_workspaceModel_storage();

    @NotNull
    public abstract AbstractRefsTable getRefs$intellij_platform_workspaceModel_storage();

    @NotNull
    public abstract StorageIndexes getIndexes$intellij_platform_workspaceModel_storage();

    public final boolean getBrokenConsistency$intellij_platform_workspaceModel_storage() {
        return this.brokenConsistency;
    }

    public final void setBrokenConsistency$intellij_platform_workspaceModel_storage(boolean bl) {
        this.brokenConsistency = bl;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Sequence sequence2;
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        if (!((entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, (Function1)((Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntity>(this){
            final /* synthetic */ AbstractEntityStorage this$0;

            @NotNull
            public final WorkspaceEntity invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.createEntity(this.this$0);
            }
            {
                this.this$0 = abstractEntityStorage;
                super(1);
            }
        })) : (sequence2 = null)) instanceof Sequence)) {
            sequence2 = sequence = null;
        }
        if (sequence2 == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @Override
    public <E extends WorkspaceEntity> int entitiesAmount(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        return entityFamily != null ? entityFamily.size() : 0;
    }

    @Nullable
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataById$intellij_platform_workspaceModel_storage(@NotNull EntityId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(id2.getClazz());
        return entityFamily != null ? entityFamily.get(id2.getArrayId()) : null;
    }

    @NotNull
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataByIdOrDie$intellij_platform_workspaceModel_storage(@NotNull EntityId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(id2.getClazz());
        if (entityFamily == null || (entityFamily = entityFamily.get(id2.getArrayId())) == null) {
            String string = "Cannot find an entity by id " + id2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return entityFamily;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull E e, @NotNull KClass<R> entityClass, @NotNull KProperty1<R, ? extends EntityReference<? extends E>> property2) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithPersistentId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull PersistentEntityId<? extends E> id2, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        int classId = ClassToIntConverterKt.toClassId(entityClass);
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getSoftLinks$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id2)), (Function1)((Function1)new Function1<EntityId, Boolean>(classId){
            final /* synthetic */ int $classId;

            public final boolean invoke(@NotNull EntityId it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getClazz() == this.$classId;
            }
            {
                this.$classId = n;
                super(1);
            }
        })), (Function1)new Function1<EntityId, R>(this){
            final /* synthetic */ AbstractEntityStorage this$0;

            @NotNull
            public final R invoke(@NotNull EntityId it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                WorkspaceEntity workspaceEntity = this.this$0.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(it).createEntity(this.this$0);
                if (workspaceEntity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type R");
                }
                return (R)workspaceEntity;
            }
            {
                this.this$0 = abstractEntityStorage;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithPersistentId> E resolve(@NotNull PersistentEntityId<? extends E> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        EntityId entityId = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id2);
        if (entityId == null) {
            return null;
        }
        EntityId entityIds = entityId;
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage(entityIds);
        return (E)((WorkspaceEntityWithPersistentId)(workspaceEntityData != null ? workspaceEntityData.createEntity(this) : null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Sequence $this$associateWith$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage()), (Function1)((Function1)new Function1<EntitySource, Boolean>(sourceFilter){
            final /* synthetic */ Function1 $sourceFilter;

            public final boolean invoke(@NotNull EntitySource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$sourceFilter.invoke((Object)it);
            }
            {
                this.$sourceFilter = function1;
                super(1);
            }
        }));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            WorkspaceEntity it;
            void $this$mapTo$iv$iv;
            void source;
            EntitySource entitySource = (EntitySource)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List<EntityId> list2 = this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage((EntitySource)source);
            Intrinsics.checkNotNull(list2);
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                EntityId entityId = (EntityId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                WorkspaceEntity workspaceEntity = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage((EntityId)((Object)it)).createEntity(this);
                collection.add(workspaceEntity);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                Object object;
                Class<?> key$iv$iv;
                it = (WorkspaceEntity)element$iv$iv2;
                boolean bl3 = false;
                if (it.getClass() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out com.intellij.workspaceModel.storage.WorkspaceEntity>");
                }
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            Object object = destination$iv$iv;
            map2.put(e, object);
        }
        return result$iv;
    }

    @Override
    @NotNull
    public <T> ExternalEntityMapping<T> getExternalMapping(@NotNull String identifier) {
        ExternalEntityMappingImpl<?> index2;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        ExternalEntityMappingImpl<?> externalEntityMappingImpl = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().get(identifier);
        if (!(externalEntityMappingImpl instanceof ExternalEntityMappingImpl)) {
            externalEntityMappingImpl = null;
        }
        if ((index2 = externalEntityMappingImpl) == null) {
            EmptyExternalEntityMapping emptyExternalEntityMapping = EmptyExternalEntityMapping.INSTANCE;
            if (emptyExternalEntityMapping == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.ExternalEntityMapping<T>");
            }
            return emptyExternalEntityMapping;
        }
        index2.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return index2;
    }

    @Override
    @NotNull
    public VirtualFileUrlIndex getVirtualFileUrlIndex() {
        this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage();
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> EntityReference<E> createReference(@NotNull E e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return new EntityReferenceImpl(((WorkspaceEntityBase)e).getId$intellij_platform_workspaceModel_storage());
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency$intellij_platform_workspaceModel_storage() {
        Integer n;
        Map.Entry<ConnectionId, Object> $this$map$iv332;
        Object object;
        Collection<EntityId> collection;
        Iterable $this$map$iv;
        boolean $i$f$map;
        AbstractEntityStorage abstractEntityStorage;
        ChildEntityId childId;
        ParentEntityId parentId;
        boolean bl;
        Object $this$forEach$iv;
        Object this_$iv22;
        Object map2;
        boolean $i$f$forEachKey;
        Object this_$iv332;
        boolean bl2;
        ConnectionId connectionId;
        Map.Entry<ConnectionId, Object> $dstr$connectionId$map;
        this.getEntitiesByType$intellij_platform_workspaceModel_storage().assertConsistency(this);
        Map<ConnectionId, NonNegativeIntIntBiMap> $this$forEach$iv2 = this.getRefs$intellij_platform_workspaceModel_storage().getOneToManyContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach2 = false;
        Map<ConnectionId, Object> map3 = $this$forEach$iv2;
        boolean bl3 = false;
        for (Map.Entry<ConnectionId, NonNegativeIntIntBiMap> element$iv2 : map3.entrySet()) {
            $dstr$connectionId$map = element$iv2;
            boolean bl4 = false;
            Map.Entry<ConnectionId, NonNegativeIntIntBiMap> entry2 = $dstr$connectionId$map;
            boolean bl5 = false;
            ConnectionId connectionId2 = entry2.getKey();
            entry2 = $dstr$connectionId$map;
            bl5 = false;
            NonNegativeIntIntBiMap map22 = entry2.getValue();
            boolean bl6 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
            bl5 = false;
            bl2 = false;
            if (_Assertions.ENABLED && !bl6) {
                boolean bl7 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this_$iv332 = map22;
            $i$f$forEachKey = false;
            Int2IntMaps.fastForEach((Int2IntMap)((NonNegativeIntIntBiMap)this_$iv332).getAccess$key2Value(), (Consumer)new Consumer(connectionId, this){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage this$0;
                {
                    this.$connectionId$inlined = connectionId;
                    this.this$0 = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry2.getIntKey();
                    boolean bl = false;
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getParentClass(), parentId);
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            this.checkStrongConnection(map22.getKeys(), connectionId.getChildClass(), connectionId.getParentClass());
        }
        Map<ConnectionId, Object> $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getOneToOneContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        map3 = $this$forEach$iv3;
        bl3 = false;
        for (Map.Entry<ConnectionId, Object> element$iv : map3.entrySet()) {
            $dstr$connectionId$map = element$iv;
            boolean bl8 = false;
            this_$iv332 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            connectionId = this_$iv332.getKey();
            this_$iv332 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            map2 = (IntIntUniqueBiMap)this_$iv332.getValue();
            boolean this_$iv332 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
            $i$f$forEachKey = false;
            bl2 = false;
            if (_Assertions.ENABLED && !this_$iv332) {
                boolean bl9 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this_$iv22 = map2;
            $i$f$forEachKey = false;
            Int2IntMaps.fastForEach((Int2IntMap)((IntIntUniqueBiMap)this_$iv22).getAccess$key2Value(), (Consumer)new Consumer(connectionId, this){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage this$0;
                {
                    this.$connectionId$inlined = connectionId;
                    this.this$0 = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry2.getIntKey();
                    boolean bl = false;
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getParentClass(), parentId);
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (!connectionId.isParentNullable()) {
                this.checkStrongConnection(((IntIntUniqueBiMap)map2).getKeys(), connectionId.getChildClass(), connectionId.getParentClass());
            }
            if (connectionId.isChildNullable()) continue;
            this.checkStrongConnection(((IntIntUniqueBiMap)map2).getValues(), connectionId.getParentClass(), connectionId.getChildClass());
        }
        $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        map3 = $this$forEach$iv3;
        bl3 = false;
        for (Map.Entry<ConnectionId, Object> element$iv : map3.entrySet()) {
            void $this$mapTo$iv$iv232;
            Map.Entry<ConnectionId, Object> $this$mapTo$iv$iv;
            $dstr$connectionId$map = element$iv;
            boolean bl10 = false;
            this_$iv22 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            connectionId = this_$iv22.getKey();
            this_$iv22 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            map2 = (LinkedBidirectionalMap)this_$iv22.getValue();
            boolean this_$iv22 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
            $i$f$forEachKey = false;
            boolean bl11 = false;
            if (_Assertions.ENABLED && !this_$iv22) {
                boolean bl12 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach3 = false;
            Map object2 = $this$forEach$iv;
            boolean bl13 = false;
            Iterator iterator2 = object2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2;
                Map.Entry $dstr$childId$parentId = entry2 = iterator2.next();
                boolean bl14 = false;
                Map.Entry entry3 = $dstr$childId$parentId;
                bl = false;
                ChildEntityId childEntityId = (ChildEntityId)entry3.getKey();
                entry3 = $dstr$childId$parentId;
                bl = false;
                parentId = (ParentEntityId)entry3.getValue();
                this.assertResolvable(parentId.getId().getClazz(), parentId.getId().getArrayId());
                this.assertResolvable(childId.getId().getClazz(), childId.getId().getArrayId());
                this.assertCorrectEntityClass(connectionId.getParentClass(), parentId.getId());
                this.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = ((LinkedBidirectionalMap)map2).keySet();
            abstractEntityStorage = this;
            $i$f$map = false;
            object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object item$iv$iv = iterator3.next();
                ChildEntityId bl14 = (ChildEntityId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl15 = false;
                object = it.getId();
                collection.add((EntityId)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = ((LinkedBidirectionalMap)map2).keySet();
            collection = CollectionsKt.toMutableSet((Iterable)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv332;
            Collection destination$iv$iv2232 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv332, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv232) {
                ChildEntityId it = (ChildEntityId)item$iv$iv;
                object = destination$iv$iv2232;
                boolean bl16 = false;
                n = it.getId().getClazz();
                object.add(n);
            }
            object = (List)destination$iv$iv2232;
            abstractEntityStorage.checkStrongAbstractConnection((Set<EntityId>)collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
        }
        $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getAbstractOneToOneContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        map3 = $this$forEach$iv3;
        bl3 = false;
        for (Map.Entry<ConnectionId, Object> element$iv : map3.entrySet()) {
            void destination$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$mapTo$iv;
            $dstr$connectionId$map = element$iv;
            boolean bl17 = false;
            $this$map$iv332 = $dstr$connectionId$map;
            $i$f$map = false;
            connectionId = $this$map$iv332.getKey();
            $this$map$iv332 = $dstr$connectionId$map;
            $i$f$map = false;
            map2 = (BiMap)$this$map$iv332.getValue();
            boolean $this$map$iv332 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv232 = false;
            if (_Assertions.ENABLED && !$this$map$iv332) {
                boolean destination$iv$iv2232 = false;
                String destination$iv$iv2232 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)destination$iv$iv2232));
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach32 = false;
            Map $this$mapTo$iv$iv232 = $this$forEach$iv;
            boolean destination$iv$iv2232 = false;
            Iterator $i$f$mapTo = $this$mapTo$iv$iv232.entrySet().iterator();
            while ($i$f$mapTo.hasNext()) {
                Map.Entry entry4;
                Map.Entry $dstr$childId$parentId = entry4 = $i$f$mapTo.next();
                boolean bl18 = false;
                Map.Entry bl16 = $dstr$childId$parentId;
                bl = false;
                childId = (ChildEntityId)bl16.getKey();
                bl16 = $dstr$childId$parentId;
                bl = false;
                parentId = (ParentEntityId)bl16.getValue();
                this.assertResolvable(parentId.getId().getClazz(), parentId.getId().getArrayId());
                this.assertResolvable(childId.getId().getClazz(), childId.getId().getArrayId());
                this.assertCorrectEntityClass(connectionId.getParentClass(), parentId.getId());
                this.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (!connectionId.isParentNullable()) {
                void destination$iv2;
                $this$forEach$iv = map2.keySet();
                Collection $i$f$forEach32 = new HashSet();
                abstractEntityStorage = this;
                boolean $i$f$mapTo232 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    ChildEntityId childEntityId = (ChildEntityId)item$iv;
                    collection = destination$iv2;
                    boolean bl19 = false;
                    object = childEntityId.getId();
                    collection.add((EntityId)object);
                }
                collection = destination$iv2;
                $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
                collection = (Set)collection;
                boolean $i$f$map2 = false;
                Iterable $i$f$mapTo232 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    ChildEntityId bl18 = (ChildEntityId)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl20 = false;
                    n = it2.getId().getClazz();
                    object.add(n);
                }
                object = (List)destination$iv$iv;
                abstractEntityStorage.checkStrongAbstractConnection((Set<EntityId>)collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
            }
            if (connectionId.isChildNullable()) continue;
            Set set2 = (Set)map2.values();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"map.values");
            $this$map$iv = set2;
            Collection $i$f$map2 = new HashSet();
            abstractEntityStorage = this;
            boolean $i$f$mapTo22 = false;
            for (Object item$iv : $this$mapTo$iv) {
                ParentEntityId parentEntityId = (ParentEntityId)item$iv;
                collection = destination$iv;
                boolean bl21 = false;
                object = parentEntityId.getId();
                collection.add((EntityId)object);
            }
            collection = destination$iv;
            Set set3 = (Set)collection;
            Set set4 = (Set)map2.values();
            Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"map.values");
            $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)set4);
            collection = set3;
            $i$f$map = false;
            Iterable $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ParentEntityId it2 = (ParentEntityId)item$iv$iv;
                object = destination$iv$iv;
                boolean bl22 = false;
                n = it.getId().getClazz();
                object.add(n);
            }
            object = (List)destination$iv$iv;
            abstractEntityStorage.checkStrongAbstractConnection((Set<EntityId>)collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
        }
        this.getIndexes$intellij_platform_workspaceModel_storage().assertConsistency(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkStrongConnection(IntSet connectionKeys, int entityFamilyClass, int connectionTo) {
        if (connectionKeys.isEmpty()) {
            return;
        }
        int counter = 0;
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            String string = "Entity family " + ClassToIntConverterKt.findWorkspaceEntity(entityFamilyClass) + " doesn't exist";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (entity == null) continue;
            int n2 = connectionKeys.contains(i2);
            boolean bl3 = false;
            if (_Assertions.ENABLED && n2 == 0) {
                boolean bl4 = false;
                String string = "Entity " + entity + " doesn't have a correct connection to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n2 = counter;
            counter = n2 + 1;
        }
        boolean bl = counter == connectionKeys.size();
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Store is inconsistent";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final void checkStrongAbstractConnection(Set<EntityId> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set keys2 = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl = false;
            this.checkAllStrongConnections(entityFamilyClass, keys2, debugInfo);
        }
        boolean bl = keys2.isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Store is inconsistent. " + debugInfo;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final void checkAllStrongConnections(int entityFamilyClass, Set<EntityId> keys2, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            String string = "Entity family doesn't exist. " + debugInfo;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEach$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntityData entity = (WorkspaceEntityData)element$iv;
            boolean bl = false;
            if (entity == null) continue;
            boolean removed = keys2.remove(entity.createEntityId$intellij_platform_workspaceModel_storage());
            boolean bl2 = false;
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl3 = false;
            String string = "Entity " + entity + " doesn't have a correct connection. " + debugInfo;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public final void assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage(@NotNull String message2, @Nullable Function1<? super EntitySource, Boolean> sourceFilter, @Nullable WorkspaceEntityStorage left, @Nullable WorkspaceEntityStorage right) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED) {
            try {
                this.assertConsistency$intellij_platform_workspaceModel_storage();
            }
            catch (Throwable e) {
                AbstractEntityStorage abstractEntityStorage;
                this.brokenConsistency = true;
                if (this instanceof WorkspaceEntityStorageBuilder) {
                    WorkspaceEntityStorage workspaceEntityStorage = ((WorkspaceEntityStorageBuilder)((Object)this)).toStorage();
                    if (workspaceEntityStorage == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.AbstractEntityStorage");
                    }
                    abstractEntityStorage = (AbstractEntityStorage)workspaceEntityStorage;
                } else {
                    abstractEntityStorage = this;
                }
                AbstractEntityStorage storage2 = abstractEntityStorage;
                Function0 report2 = (Function0)new Function0<Unit>(this, message2, e, sourceFilter, left, right, storage2){
                    final /* synthetic */ AbstractEntityStorage this$0;
                    final /* synthetic */ String $message;
                    final /* synthetic */ Throwable $e;
                    final /* synthetic */ Function1 $sourceFilter;
                    final /* synthetic */ WorkspaceEntityStorage $left;
                    final /* synthetic */ WorkspaceEntityStorage $right;
                    final /* synthetic */ AbstractEntityStorage $storage;

                    public final void invoke() {
                        this.this$0.reportConsistencyIssue(this.$message, this.$e, (Function1<? super EntitySource, Boolean>)this.$sourceFilter, this.$left, this.$right, this.$storage);
                    }
                    {
                        this.this$0 = abstractEntityStorage;
                        this.$message = string;
                        this.$e = throwable;
                        this.$sourceFilter = function1;
                        this.$left = workspaceEntityStorage;
                        this.$right = workspaceEntityStorage2;
                        this.$storage = abstractEntityStorage2;
                        super(0);
                    }
                };
                if (ConsistencyCheckingMode.Companion.getCurrent() == ConsistencyCheckingMode.ASYNCHRONOUS) {
                    Function0 function0 = report2;
                    consistencyChecker.execute(new Runnable(function0){
                        private final /* synthetic */ Function0 function;
                        {
                            this.function = function0;
                        }

                        public final /* synthetic */ void run() {
                            Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                        }
                    });
                }
                report2.invoke();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reportConsistencyIssue(@NotNull String message2, @NotNull Throwable e, @Nullable Function1<? super EntitySource, Boolean> sourceFilter, @Nullable WorkspaceEntityStorage left, @Nullable WorkspaceEntityStorage right, @NotNull WorkspaceEntityStorage resulting) {
        File zipFile;
        File file2;
        String string;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)resulting, (String)"resulting");
        if (sourceFilter != null) {
            void $this$fold$iv;
            Object object;
            WorkspaceEntityStorage workspaceEntityStorage;
            HashSet allEntitySources;
            HashSet hashSet;
            WorkspaceEntityStorage workspaceEntityStorage2 = left;
            if (!(workspaceEntityStorage2 instanceof AbstractEntityStorage)) {
                workspaceEntityStorage2 = null;
            }
            if ((hashSet = (AbstractEntityStorage)workspaceEntityStorage2) == null || (hashSet = ((AbstractEntityStorage)((Object)hashSet)).getIndexes$intellij_platform_workspaceModel_storage()) == null || (hashSet = ((StorageIndexes)((Object)hashSet)).getEntitySourceIndex$intellij_platform_workspaceModel_storage()) == null || (hashSet = ((EntityStorageInternalIndex)((Object)hashSet)).entries$intellij_platform_workspaceModel_storage()) == null || (hashSet = CollectionsKt.toHashSet((Iterable)hashSet)) == null) {
                boolean bl = false;
                hashSet = allEntitySources = new HashSet();
            }
            if (!((workspaceEntityStorage = right) instanceof AbstractEntityStorage)) {
                workspaceEntityStorage = null;
            }
            if ((object = (AbstractEntityStorage)workspaceEntityStorage) == null || (object = ((AbstractEntityStorage)object).getIndexes$intellij_platform_workspaceModel_storage()) == null || (object = ((StorageIndexes)object).getEntitySourceIndex$intellij_platform_workspaceModel_storage()) == null || (object = ((EntityStorageInternalIndex)object).entries$intellij_platform_workspaceModel_storage()) == null) {
                object = SetsKt.emptySet();
            }
            allEntitySources.addAll(object);
            Iterable $this$sortedBy$iv = allEntitySources;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    EntitySource it = (EntitySource)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.toString());
                    it = (EntitySource)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.toString();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            String initial$iv = "";
            boolean $i$f$fold = false;
            String accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void source;
                EntitySource entitySource = (EntitySource)element$iv;
                String acc = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = acc + ((Boolean)sourceFilter.invoke((Object)source) != false ? "1" : "0");
            }
            string = accumulator$iv;
        } else {
            string = null;
        }
        String entitySourceFilter2 = string;
        String _message = message2 + "\n\nEntity source filter: " + entitySourceFilter2;
        _message = _message + "\n\nVersion: v22";
        if (ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED) {
            Path dumpDirectory = ErrorReportingKt.getStoreDumpDirectory();
            _message = _message + "\nSaving store content at: " + dumpDirectory;
            file2 = this.serializeContentToFolder(dumpDirectory, left, right, resulting);
        } else {
            file2 = zipFile = null;
        }
        if (zipFile != null) {
            Attachment attachment = new Attachment("workspaceModelDump.zip", FilesKt.readBytes(zipFile), "Zip of workspace model store");
            attachment.setIncluded(true);
            LOG.error(_message, e, new Attachment[]{attachment});
        } else {
            LOG.error(_message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File serializeContentToFolder(Path contentFolder, WorkspaceEntityStorage left, WorkspaceEntityStorage right, WorkspaceEntityStorage resulting) {
        File file2;
        WorkspaceEntityStorage it;
        boolean bl;
        boolean bl2;
        WorkspaceEntityStorage workspaceEntityStorage;
        WorkspaceEntityStorage workspaceEntityStorage2 = left;
        if (workspaceEntityStorage2 != null) {
            workspaceEntityStorage = workspaceEntityStorage2;
            bl2 = false;
            bl = false;
            it = workspaceEntityStorage;
            boolean bl3 = false;
            Path path2 = contentFolder.resolve("Left_Store");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"contentFolder.resolve(\"Left_Store\")");
            ErrorReportingKt.serializeEntityStorage(path2, it);
        }
        WorkspaceEntityStorage workspaceEntityStorage3 = right;
        if (workspaceEntityStorage3 != null) {
            workspaceEntityStorage = workspaceEntityStorage3;
            bl2 = false;
            bl = false;
            it = workspaceEntityStorage;
            boolean bl4 = false;
            Path path3 = contentFolder.resolve("Right_Store");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"contentFolder.resolve(\"Right_Store\")");
            ErrorReportingKt.serializeEntityStorage(path3, it);
        }
        Path path4 = contentFolder.resolve("Res_Store");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"contentFolder.resolve(\"Res_Store\")");
        ErrorReportingKt.serializeEntityStorage(path4, resulting);
        Path path5 = contentFolder.resolve("ClassToIntConverter");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"contentFolder.resolve(\"ClassToIntConverter\")");
        ErrorReportingKt.serializeContent(path5, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)serializeContentToFolder.3.INSTANCE));
        if (right instanceof WorkspaceEntityStorageBuilder) {
            Path path6 = contentFolder.resolve("Right_Diff_Log");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"contentFolder.resolve(\"Right_Diff_Log\")");
            ErrorReportingKt.serializeContent(path6, (Function2<? super EntityStorageSerializerImpl, ? super OutputStream, Unit>)((Function2)new Function2<EntityStorageSerializerImpl, OutputStream, Unit>(right){
                final /* synthetic */ WorkspaceEntityStorage $right;

                public final void invoke(@NotNull EntityStorageSerializerImpl serializer2, @NotNull OutputStream stream) {
                    Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    WorkspaceEntityStorage workspaceEntityStorage = this.$right;
                    if (workspaceEntityStorage == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl");
                    }
                    WorkspaceEntityStorageBuilderImpl cfr_ignored_0 = (WorkspaceEntityStorageBuilderImpl)workspaceEntityStorage;
                    serializer2.serializeDiffLog$intellij_platform_workspaceModel_storage(stream, ((WorkspaceEntityStorageBuilderImpl)this.$right).getChangeLog$intellij_platform_workspaceModel_storage());
                }
                {
                    this.$right = workspaceEntityStorage;
                    super(2);
                }
            }));
        }
        if (!ErrorReportingKt.executingOnTC()) {
            File zipFile = contentFolder.getParent().resolve(PathsKt.getName((Path)contentFolder) + ".zip").toFile();
            Closeable closeable = (Closeable)new Compressor.Zip(zipFile);
            bl = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                Compressor.Zip it2 = (Compressor.Zip)closeable;
                boolean bl6 = false;
                it2.addDirectory(contentFolder.toFile());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            FileUtil.delete((Path)contentFolder);
            file2 = zipFile;
        } else {
            file2 = null;
        }
        return file2;
    }

    private final void assertResolvable(int clazz, int id2) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(clazz);
        boolean bl = (entityFamily != null ? entityFamily.get(id2) : null) != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv = clazz;
            boolean $i$f$findEntityClass = false;
            Class<?> clazz2 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
            if (clazz2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string = "Reference to " + clazz2 + "-:-" + id2 + " cannot be resolved";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final void assertCorrectEntityClass(int connectionClass, EntityId entityId) {
        int $this$findEntityClass$iv = connectionClass;
        boolean $i$f$findEntityClass = false;
        Class<?> clazz = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        $this$findEntityClass$iv = entityId.getClazz();
        $i$f$findEntityClass = false;
        Class<?> clazz2 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
        if (clazz2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        boolean bl = clazz.isAssignableFrom(clazz2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv2 = connectionClass;
            boolean $i$f$findEntityClass2 = false;
            Class<?> clazz3 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv2);
            if (clazz3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string = "Entity storage with connection class " + clazz3 + " contains entity data of wrong type " + entityId;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private AbstractEntityStorage() {
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractEntityStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Check workspace model consistency", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026ce model consistency\", 1)");
        consistencyChecker = executorService;
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage $this, int clazz, int id2) {
        $this.assertResolvable(clazz, id2);
    }

    public /* synthetic */ AbstractEntityStorage(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "consistencyChecker", "Ljava/util/concurrent/ExecutorService;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

