/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.DefaultXmlNamespaceHelper;
import com.intellij.xml.psi.XmlPsiBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlNamespaceHelper {
    private static final ExtensionPointName<XmlNamespaceHelper> EP_NAME = new ExtensionPointName("com.intellij.xml.namespaceHelper");
    public static final XmlNamespaceHelper DEFAULT_EXTENSION = new DefaultXmlNamespaceHelper();

    public static XmlNamespaceHelper getHelper(PsiFile file2) {
        for (XmlNamespaceHelper extension2 : EP_NAME.getExtensionList()) {
            if (!extension2.isAvailable(file2)) continue;
            return extension2;
        }
        return DEFAULT_EXTENSION;
    }

    protected abstract boolean isAvailable(PsiFile var1);

    @Nullable
    public String getNamespacePrefix(PsiElement element2) {
        PsiElement tag2;
        XmlAttribute attribute;
        String prefix2;
        if (element2 instanceof XmlAttribute && !StringUtil.isEmpty((String)(prefix2 = (attribute = (XmlAttribute)element2).getNamespacePrefix()))) {
            return prefix2;
        }
        PsiElement psiElement = tag2 = element2 instanceof XmlTag ? element2 : element2.getParent();
        if (tag2 instanceof XmlTag) {
            return ((XmlTag)tag2).getNamespacePrefix();
        }
        return null;
    }

    public abstract void insertNamespaceDeclaration(@NotNull XmlFile var1, @Nullable Editor var2, @NonNls @NotNull Set<String> var3, @NonNls @Nullable String var4, @Nullable Runner<String, IncorrectOperationException> var5) throws IncorrectOperationException;

    public boolean qualifyWithPrefix(String namespacePrefix, PsiElement element2, Document document) throws IncorrectOperationException {
        PsiElement tag2;
        PsiElement psiElement = tag2 = element2 instanceof XmlTag ? element2 : element2.getParent();
        if (tag2 instanceof XmlTag) {
            String prefix2 = ((XmlTag)tag2).getNamespacePrefix();
            if (!prefix2.equals(namespacePrefix)) {
                String name = namespacePrefix + ":" + ((XmlTag)tag2).getLocalName();
                ((XmlTag)tag2).setName(name);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public abstract Set<String> guessUnboundNamespaces(@NotNull PsiElement var1, XmlFile var2);

    @NotNull
    public abstract Set<String> getNamespacesByTagName(@NotNull String var1, @NotNull XmlFile var2);

    public String getNamespaceAlias(@NotNull XmlFile file2) {
        if (file2 == null) {
            XmlNamespaceHelper.$$$reportNull$$$0(0);
        }
        return XmlPsiBundle.message((String)"xml.terms.namespace.alias", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/XmlNamespaceHelper", "getNamespaceAlias"));
    }

    public static interface Runner<P, T extends Throwable> {
        public void run(P var1) throws T;
    }
}

