/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dom.DomAttributeXmlDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildrenDescriptor
implements XmlElementDescriptor {
    protected final DomManager myManager;

    protected AbstractDomChildrenDescriptor(DomManager manager2) {
        this.myManager = manager2;
    }

    public XmlElementDescriptor[] getElementsDescriptors(final XmlTag context2) {
        final DomElement domElement = this.myManager.getDomElement(context2);
        if (domElement == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> xmlElementDescriptors = new ArrayList<Object>();
        for (DomCollectionChildDescription childrenDescription : domElement.getGenericInfo().getCollectionChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor((DomChildrenDescription)childrenDescription, this.myManager));
        }
        for (DomCollectionChildDescription childrenDescription : domElement.getGenericInfo().getFixedChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor((DomChildrenDescription)childrenDescription, this.myManager));
        }
        List customs = domElement.getGenericInfo().getCustomNameChildrenDescription();
        for (CustomDomChildrenDescription custom : customs) {
            final CustomDomChildrenDescription.TagNameDescriptor tagNameDescriptor = custom.getTagNameDescriptor();
            if (tagNameDescriptor == null) continue;
            final XmlTag xmlTag = domElement.getXmlTag();
            for (final EvaluatedXmlName name : tagNameDescriptor.getCompletionVariants(domElement)) {
                AbstractDomChildrenDescriptor descriptor2 = new AbstractDomChildrenDescriptor(this.myManager){

                    public String getDefaultName() {
                        String prefix2;
                        String ns;
                        String string = ns = xmlTag != null ? name.getNamespace((XmlElement)xmlTag, (XmlFile)xmlTag.getContainingFile()) : null;
                        if (ns != null && (prefix2 = xmlTag.getPrefixByNamespace(ns)) != null) {
                            return prefix2 + ":" + name.getXmlName().getLocalName();
                        }
                        return name.getXmlName().getLocalName();
                    }

                    @Nullable
                    public PsiElement getDeclaration() {
                        PomTarget target2 = tagNameDescriptor.findDeclaration(domElement, name);
                        return target2 == null ? null : PomService.convertToPsi((Project)context2.getProject(), (PomTarget)target2);
                    }
                };
                xmlElementDescriptors.add(descriptor2);
            }
            xmlElementDescriptors.add(new AnyXmlElementDescriptor(this, this.getNSDescriptor()));
        }
        return xmlElementDescriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(final @NotNull XmlTag childTag, @Nullable XmlTag contextTag) {
        DomElement domElement;
        if (childTag == null) {
            AbstractDomChildrenDescriptor.$$$reportNull$$$0(0);
        }
        if ((domElement = this.myManager.getDomElement(childTag)) == null) {
            AbstractDomChildrenDescription description2;
            domElement = this.myManager.getDomElement(contextTag);
            if (domElement != null && (description2 = this.myManager.findChildrenDescription(childTag, domElement)) instanceof DomChildrenDescription) {
                return new DomElementXmlDescriptor((DomChildrenDescription)description2, this.myManager);
            }
            return null;
        }
        DomElement parent = domElement.getParent();
        if (parent == null) {
            return new DomElementXmlDescriptor(domElement);
        }
        final AbstractDomChildrenDescription description3 = domElement.getChildDescription();
        if (description3 instanceof CustomDomChildrenDescription) {
            final DomElement finalDomElement = domElement;
            return new AbstractDomChildrenDescriptor(this.myManager){

                public String getDefaultName() {
                    return finalDomElement.getXmlElementName();
                }

                @Nullable
                public PsiElement getDeclaration() {
                    PomTarget target2 = ((CustomDomChildrenDescription)description3).getTagNameDescriptor().findDeclaration(finalDomElement);
                    if (target2 == description3) {
                        return childTag;
                    }
                    return target2 == null ? null : PomService.convertToPsi((Project)childTag.getProject(), (PomTarget)target2);
                }
            };
        }
        if (!(description3 instanceof DomChildrenDescription)) {
            return null;
        }
        return new DomElementXmlDescriptor((DomChildrenDescription)description3, this.myManager);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context2) {
        if (context2 == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        DomElement domElement = this.myManager.getDomElement(context2);
        if (domElement == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        List descriptions = domElement.getGenericInfo().getAttributeChildrenDescriptions();
        ArrayList<DomAttributeXmlDescriptor> descriptors2 = new ArrayList<DomAttributeXmlDescriptor>();
        for (DomAttributeChildDescription description2 : descriptions) {
            descriptors2.add(new DomAttributeXmlDescriptor(description2, this.myManager.getProject()));
        }
        List customs = domElement.getGenericInfo().getCustomNameChildrenDescription();
        for (CustomDomChildrenDescription custom : customs) {
            CustomDomChildrenDescription.AttributeDescriptor descriptor2 = custom.getCustomAttributeDescriptor();
            if (descriptor2 == null) continue;
            for (EvaluatedXmlName variant : descriptor2.getCompletionVariants(domElement)) {
                AttributeChildDescriptionImpl childDescription = new AttributeChildDescriptionImpl(variant.getXmlName(), (Type)((Object)String.class));
                descriptors2.add(new DomAttributeXmlDescriptor(childDescription, this.myManager.getProject()));
            }
        }
        return descriptors2.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context2) {
        DomElement domElement = this.myManager.getDomElement(context2);
        if (domElement == null) {
            return null;
        }
        for (DomAttributeChildDescription description2 : domElement.getGenericInfo().getAttributeChildrenDescriptions()) {
            if (!attributeName.equals(DomAttributeXmlDescriptor.getQualifiedAttributeName((PsiElement)context2, description2.getXmlName()))) continue;
            return new DomAttributeXmlDescriptor(description2, this.myManager.getProject());
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return new XmlNSDescriptor(){

            @Nullable
            public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag2) {
                if (tag2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Method getElementDescriptor not implemented in " + this.getClass());
            }

            public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument document) {
                throw new UnsupportedOperationException("Method getRootElementsDescriptors not implemented in " + this.getClass());
            }

            @Nullable
            public XmlFile getDescriptorFile() {
                return null;
            }

            @Nullable
            public PsiElement getDeclaration() {
                throw new UnsupportedOperationException("Method getDeclaration not implemented in " + this.getClass());
            }

            @NonNls
            public String getName(PsiElement context2) {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            @NonNls
            public String getName() {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            public void init(PsiElement element2) {
                throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
            }

            public Object @NotNull [] getDependencies() {
                throw new UnsupportedOperationException("Method getDependencies not implemented in " + this.getClass());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/impl/dom/AbstractDomChildrenDescriptor$3", "getElementDescriptor"));
            }
        };
    }

    public int getContentType() {
        return -1;
    }

    public String getDefaultValue() {
        return null;
    }

    public void init(PsiElement element2) {
        throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
    }

    public Object @NotNull [] getDependencies() {
        throw new UnsupportedOperationException("Method getDependencies not implemented in " + this.getClass());
    }

    @NonNls
    public String getName() {
        return this.getDefaultName();
    }

    public String getQualifiedName() {
        return this.getDefaultName();
    }

    public String getName(PsiElement context2) {
        return this.getDefaultName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTag", "com/intellij/xml/impl/dom/AbstractDomChildrenDescriptor", "getElementDescriptor"));
    }
}

