/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.ResourceRelevance;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    private static final String LOCAL_SCHEMA_ID = "$LOCAL_SCHEMA$";
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create((String)"XmlNamespaces");
    private static final String NULL_STRING = "\"\"";

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(0);
        }
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(1);
        }
        if (DumbService.isDumb((Project)project) || XmlUtil.isStubBuilding()) {
            return XmlNamespaceIndex.computeNamespace(file2);
        }
        XsdNamespaceBuilder item = XmlNamespaceIndex.getFileNamespace(file2, project);
        if (item == null) {
            return null;
        }
        String namespace = item.getNamespace();
        return namespace != null ? namespace : file2.getUrl();
    }

    @Nullable
    public static String computeNamespace(@NotNull VirtualFile file2) {
        String string;
        block9: {
            if (file2 == null) {
                XmlNamespaceIndex.$$$reportNull$$$0(2);
            }
            InputStream stream = file2.getInputStream();
            try {
                string = XsdNamespaceBuilder.computeNamespace(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    @NotNull
    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(@NotNull String namespace, @NotNull Project project, @Nullable Module module) {
        if (namespace == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(3);
        }
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(4);
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module, project, null);
        resources.addAll(XmlNamespaceIndex.getDtdResources(namespace, module, project));
        ContainerUtil.addIfNotNull(resources, XmlNamespaceIndex.getResourceByLocalFile(namespace, project, module));
        Collections.sort(resources);
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list2 = resources;
        if (list2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    private static IndexedRelevantResource<String, XsdNamespaceBuilder> getResourceByLocalFile(@NotNull String namespace, @NotNull Project project, @Nullable Module module) {
        XsdNamespaceBuilder xsdNamespaceBuilder;
        VirtualFile file2;
        if (namespace == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(6);
        }
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(7);
        }
        String protocol = VirtualFileManager.extractProtocol((String)namespace);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (virtualFileManager.getFileSystem(protocol) instanceof LocalFileSystem && (file2 = virtualFileManager.findFileByUrl(namespace)) != null && (xsdNamespaceBuilder = XmlNamespaceIndex.getFileNamespace(file2, project)) != null) {
            ResourceRelevance relevance = ResourceRelevance.getRelevance(file2, module, ProjectFileIndex.getInstance((Project)project), null);
            return new IndexedRelevantResource<String, XsdNamespaceBuilder>(file2, file2.getUrl(), xsdNamespaceBuilder, relevance);
        }
        return null;
    }

    @Nullable
    private static XsdNamespaceBuilder getFileNamespace(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(8);
        }
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(9);
        }
        if (FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)DTDFileType.INSTANCE)) {
            return new XsdNamespaceBuilder(file2.getName(), "", Collections.emptyList(), Collections.emptyList());
        }
        Map data2 = FileBasedIndex.getInstance().getFileData(NAME, file2, project);
        return (XsdNamespaceBuilder)ContainerUtil.getFirstItem(data2.values());
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(10);
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> xmlResources = IndexedRelevantResource.getAllResources(NAME, module, project, null);
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> dtdResources = XmlNamespaceIndex.getDtdResources(null, module, project);
        return ContainerUtil.concat(xmlResources, dtdResources);
    }

    @NotNull
    private static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getDtdResources(@Nullable String namespace, @Nullable Module module, @NotNull Project project) {
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(11);
        }
        AdditionalIndexedRootsScope scope2 = new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project));
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Function resourceFunction = f -> {
            ResourceRelevance relevance = ResourceRelevance.getRelevance(f, module, index2, scope2);
            return new IndexedRelevantResource<String, XsdNamespaceBuilder>((VirtualFile)f, f.getName(), XmlNamespaceIndex.getFileNamespace(f, project), relevance);
        };
        Collection dtdFiles = namespace == null ? FileTypeIndex.getFiles((FileType)DTDFileType.INSTANCE, (GlobalSearchScope)scope2) : ContainerUtil.filter((Collection)FilenameIndex.getVirtualFilesByName((String)namespace, (GlobalSearchScope)scope2), f -> FileTypeRegistry.getInstance().isFileOfType(f, (FileType)DTDFileType.INSTANCE));
        List list2 = ContainerUtil.map((Collection)dtdFiles, (Function)resourceFunction);
        if (list2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        ID<String, XsdNamespaceBuilder> iD = NAME;
        if (iD == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(13);
        }
        return iD;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "xsd".equals(file2.getExtension());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex$1", "acceptInput"));
            }
        };
    }

    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        return new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                XsdNamespaceBuilder builder2 = XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                String namespace = builder2.getNamespace();
                Map<String, XsdNamespaceBuilder> map2 = Collections.singletonMap((String)ObjectUtils.notNull((Object)namespace, (Object)XmlNamespaceIndex.LOCAL_SCHEMA_ID), builder2);
                if (map2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xml/index/XmlNamespaceIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xml/index/XmlNamespaceIndex$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        return new DataExternalizer<XsdNamespaceBuilder>(){

            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value2) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                IOUtil.writeUTF((DataOutput)out, (String)(value2.getNamespace() != null ? value2.getNamespace() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeUTF((DataOutput)out, (String)(value2.getVersion() != null ? value2.getVersion() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeStringList((DataOutput)out, value2.getTags());
                IOUtil.writeStringList((DataOutput)out, value2.getRootTags());
            }

            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                String version2;
                String namespace;
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(namespace = IOUtil.readUTF((DataInput)in))) {
                    namespace = null;
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(version2 = IOUtil.readUTF((DataInput)in))) {
                    version2 = null;
                }
                return new XsdNamespaceBuilder(namespace, version2, IOUtil.readStringList((DataInput)in), IOUtil.readStringList((DataInput)in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/index/XmlNamespaceIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public int getVersion() {
        return 8;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, @Nullable String tagName, @Nullable String version2, @Nullable String schemaLocation, @Nullable Module module, @NotNull Project project) {
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources;
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(14);
        }
        if ((resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module)).isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        String fileName = schemaLocation == null ? null : new File(schemaLocation).getName();
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = Collections.max(resources, (o1, o2) -> {
            int i2;
            if (fileName != null && (i2 = Comparing.compare((boolean)fileName.equals(o1.getFile().getName()), (boolean)fileName.equals(o2.getFile().getName()))) != 0) {
                return i2;
            }
            if (tagName != null && (i2 = Comparing.compare((boolean)((XsdNamespaceBuilder)o1.getValue()).hasTag(tagName), (boolean)((XsdNamespaceBuilder)o2.getValue()).hasTag(tagName))) != 0) {
                return i2;
            }
            i2 = o1.compareTo(o2);
            if (i2 != 0) {
                return i2;
            }
            return ((XsdNamespaceBuilder)o1.getValue()).getRating(tagName, version2) - ((XsdNamespaceBuilder)o2.getValue()).getRating(tagName, version2);
        });
        if (tagName != null && !resource.getValue().hasTag(tagName)) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName, @Nullable String version2, @Nullable String schemaLocation, @NotNull PsiFile file2) {
        if (file2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(15);
        }
        if (DumbService.isDumb((Project)file2.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName, version2, schemaLocation, ModuleUtilCore.findModuleForPsiElement((PsiElement)file2), file2.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file2);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (baseFile == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(16);
        }
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb((Project)baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list2 = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)baseFile));
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            final String[] split2 = dtdUri.split("/");
            resource = Collections.max(list2, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file2 = o1.getFile();
                    for (int i2 = split2.length - 1; i2 >= 0 && file2 != null; file2 = file2.getParent(), --i2) {
                        String s = split2[i2];
                        if (s.equals(file2.getName())) continue;
                        return split2.length - i2;
                    }
                    return 0;
                }
            });
        } else {
            resource = list2.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/index/XmlNamespaceIndex";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/index/XmlNamespaceIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesByNamespace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDtdResources";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeNamespace";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesByNamespace";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResourceByLocalFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileNamespace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllResources";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDtdResources";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "guessSchema";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "guessDtd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

