/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.HtmlUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorReferenceImpl
implements AnchorReference,
PsiReference,
EmptyResolveMessageProvider {
    private final String myAnchor;
    private final FileReference myFileReference;
    private final PsiElement myElement;
    private final int myOffset;
    private final boolean mySoft;
    @NonNls
    private static final String ANCHOR_ELEMENT_NAME = "a";
    @NonNls
    private static final String MAP_ELEMENT_NAME = "map";
    private static final Key<CachedValue<Map<String, XmlTag>>> ourCachedIdsKey = Key.create((String)"cached.ids");

    AnchorReferenceImpl(String anchor2, @Nullable FileReference psiReference, @NotNull PsiElement element2, int offset, boolean soft) {
        if (element2 == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myAnchor = anchor2;
        this.myFileReference = psiReference;
        this.myElement = element2;
        this.myOffset = offset;
        this.mySoft = soft;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.myAnchor.length());
    }

    public PsiElement resolve() {
        XmlTag tag2;
        if (this.myAnchor.isEmpty()) {
            return this.myElement;
        }
        Map<String, XmlTag> map2 = this.getIdMap();
        XmlTag xmlTag = tag2 = map2 != null ? map2.get(this.myAnchor) : null;
        if (tag2 != null) {
            XmlAttribute attribute = tag2.getAttribute("id");
            if (attribute == null) {
                attribute = tag2.getAttribute("name");
            }
            if (attribute == null && MAP_ELEMENT_NAME.equalsIgnoreCase(tag2.getName())) {
                attribute = tag2.getAttribute("usemap");
            }
            assert (attribute != null) : tag2.getText();
            return attribute.getValueElement();
        }
        return null;
    }

    private static boolean processXmlElements(XmlTag element2, PsiElementProcessor<? super XmlTag> processor2) {
        if (!AnchorReferenceImpl._processXmlElements(element2, processor2)) {
            return false;
        }
        for (PsiElement next = element2.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (!(next instanceof XmlTag) || AnchorReferenceImpl._processXmlElements((XmlTag)next, processor2)) continue;
            return false;
        }
        return true;
    }

    static boolean _processXmlElements(XmlTag element2, PsiElementProcessor<? super XmlTag> processor2) {
        XmlTag[] subTags;
        if (!processor2.execute((PsiElement)element2)) {
            return false;
        }
        for (XmlTag subTag : subTags = element2.getSubTags()) {
            if (AnchorReferenceImpl._processXmlElements(subTag, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Map<String, XmlTag> getIdMap() {
        XmlFile file2 = this.getFile();
        if (file2 != null) {
            CachedValue value2 = (CachedValue)file2.getUserData(ourCachedIdsKey);
            if (value2 == null) {
                value2 = CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue((CachedValueProvider)new MapCachedValueProvider(file2), false);
                file2.putUserData(ourCachedIdsKey, (Object)value2);
            }
            return (Map)value2.getValue();
        }
        return null;
    }

    @Nullable
    private static String getAnchorValue(XmlTag xmlTag) {
        String map_anchor;
        String attributeValue2;
        String attributeValue = xmlTag.getAttributeValue("id");
        if (attributeValue != null) {
            return attributeValue;
        }
        if (ANCHOR_ELEMENT_NAME.equalsIgnoreCase(xmlTag.getName()) && (attributeValue2 = xmlTag.getAttributeValue("name")) != null) {
            return attributeValue2;
        }
        if (MAP_ELEMENT_NAME.equalsIgnoreCase(xmlTag.getName()) && (map_anchor = xmlTag.getAttributeValue("name")) != null) {
            return map_anchor;
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myAnchor;
        if (string == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(3);
        }
        return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(5);
        }
        return element2 instanceof XmlAttributeValue && this.myElement.getManager().areElementsEquivalent(element2, this.resolve());
    }

    public Object @NotNull [] getVariants() {
        Map<String, XmlTag> idMap = this.getIdMap();
        if (idMap == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                AnchorReferenceImpl.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        String[] variants = ArrayUtilRt.toStringArray(idMap.keySet());
        Object[] elements = new LookupElement[variants.length];
        int variantsLength = variants.length;
        for (int i2 = 0; i2 < variantsLength; ++i2) {
            elements[i2] = LookupElementBuilder.create((String)variants[i2]).withCaseSensitivity(true);
        }
        if (elements == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(7);
        }
        return elements;
    }

    @Nullable
    private XmlFile getFile() {
        if (this.myFileReference != null) {
            PsiFileSystemItem psiElement = this.myFileReference.resolve();
            return psiElement instanceof XmlFile ? (XmlFile)psiElement : null;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (containingFile instanceof XmlFile) {
            return (XmlFile)containingFile;
        }
        XmlExtension extension2 = XmlExtension.getExtensionByElement(this.myElement);
        return extension2 == null ? null : extension2.getContainingFile(this.myElement);
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        XmlFile xmlFile = this.getFile();
        String string = xmlFile == null ? XmlBundle.message((String)"xml.inspections.cannot.resolve.anchor", (Object[])new Object[]{this.myAnchor}) : XmlBundle.message((String)"xml.inspections.cannot.resolve.anchor.in.file", (Object[])new Object[]{this.myAnchor, xmlFile.getName()});
        if (string == null) {
            AnchorReferenceImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/AnchorReferenceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/AnchorReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MapCachedValueProvider
    implements CachedValueProvider<Map<String, XmlTag>> {
        private final XmlFile myFile;

        MapCachedValueProvider(XmlFile file2) {
            this.myFile = file2;
        }

        public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
            XmlTag rootTag;
            final HashMap resultMap = new HashMap();
            XmlDocument document = HtmlUtil.getRealXmlDocument(this.myFile.getDocument());
            XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
            if (rootTag != null) {
                AnchorReferenceImpl.processXmlElements(rootTag, (PsiElementProcessor<? super XmlTag>)new PsiElementProcessor<XmlTag>(){

                    public boolean execute(@NotNull XmlTag element2) {
                        String anchorValue;
                        if (element2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((anchorValue = AnchorReferenceImpl.getAnchorValue(element2)) != null) {
                            resultMap.put(anchorValue, element2);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/AnchorReferenceImpl$MapCachedValueProvider$1", "execute"));
                    }
                });
            }
            return new CachedValueProvider.Result(resultMap, new Object[]{this.myFile});
        }
    }
}

