/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.documentation.CompositeAttributeTagDescriptor;
import com.intellij.xml.util.documentation.HtmlAttributeDescriptor;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import com.intellij.xml.util.documentation.HtmlTagDescriptor;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlDocumentationProvider
implements DocumentationProvider {
    public static final ExtensionPointName<DocumentationProvider> SCRIPT_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.html.scriptDocumentationProvider");
    private final boolean myUseStyleProvider;
    @NonNls
    public static final String ELEMENT_ELEMENT_NAME = "element";
    @NonNls
    public static final String NBSP = ":&nbsp;";
    @NonNls
    public static final String BR = "<br>";

    public HtmlDocumentationProvider() {
        this(true);
    }

    public HtmlDocumentationProvider(boolean useStyleProvider) {
        this.myUseStyleProvider = useStyleProvider;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof SchemaPrefix) {
            return ((SchemaPrefix)element2).getQuickNavigateInfo();
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element2, PsiElement originalElement) {
        String result2 = this.getUrlForHtml(element2, originalElement);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            return styleProvider.getUrlFor(element2, originalElement);
        }
        return result2 != null ? Collections.singletonList(result2) : null;
    }

    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        String result2 = this.generateDocForHtml(element2, originalElement);
        if (result2 != null) {
            return result2;
        }
        return this.generateDocFromStyleOrScript(element2, originalElement);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        DocumentationProvider scriptProvider;
        MdnSymbolDocumentation documentation;
        if (object instanceof PsiElement && (documentation = this.getDocumentation((PsiElement)object, element2)) != null) {
            return (PsiElement)object;
        }
        PsiElement result2 = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findDescriptor(psiManager, object.toString(), element2), PsiMetaData::getDeclaration);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.getDocumentationElementForLookupItem(psiManager, object, element2);
        }
        if (result2 == null && (scriptProvider = HtmlDocumentationProvider.getScriptDocumentationProvider()) != null) {
            result2 = scriptProvider.getDocumentationElementForLookupItem(psiManager, object, element2);
        }
        if (result2 == null && object instanceof String && element2 != null) {
            result2 = XmlDocumentationProvider.findDeclWithName((String)object, element2);
        }
        return result2;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement contextElement, int targetOffset) {
        DocumentationProvider scriptProvider;
        if (editor == null) {
            HtmlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            HtmlDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (contextElement instanceof XmlElement) {
            return null;
        }
        DocumentationProvider styleProvider = this.getStyleProvider();
        PsiElement result2 = null;
        if (styleProvider != null) {
            result2 = styleProvider.getCustomDocumentationElement(editor, file2, contextElement, targetOffset);
        }
        if (result2 == null && (scriptProvider = HtmlDocumentationProvider.getScriptDocumentationProvider()) != null) {
            result2 = scriptProvider.getCustomDocumentationElement(editor, file2, contextElement, targetOffset);
        }
        return result2;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link2, PsiElement context2) {
        PsiElement result2 = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findDescriptor(psiManager, link2, context2), PsiMetaData::getDeclaration);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.getDocumentationElementForLink(psiManager, link2, context2);
        }
        DocumentationProvider provider2 = HtmlDocumentationProvider.getScriptDocumentationProvider();
        if (result2 == null && provider2 != null && !DumbService.isDumb((Project)psiManager.getProject())) {
            result2 = provider2.getDocumentationElementForLink(psiManager, link2, context2);
        }
        return result2;
    }

    private String generateDocFromStyleOrScript(PsiElement element2, PsiElement originalElement) {
        String result2;
        String result3;
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (styleProvider != null && (result3 = styleProvider.generateDoc(element2, originalElement)) != null) {
            return result3;
        }
        DocumentationProvider scriptProvider = HtmlDocumentationProvider.getScriptDocumentationProvider();
        if (scriptProvider != null && (result2 = scriptProvider.generateDoc(element2, originalElement)) != null) {
            return result2;
        }
        return null;
    }

    private String getUrlForHtml(PsiElement element2, PsiElement originalElement) {
        return (String)ObjectUtils.doIfNotNull((Object)this.getDocumentation(element2, originalElement), MdnSymbolDocumentation::getUrl);
    }

    private MdnSymbolDocumentation getDocumentation(PsiElement element2, PsiElement originalElement) {
        PsiElement declaration;
        XmlTag tagContext = this.findTagContext(originalElement);
        MdnSymbolDocumentation result2 = MdnDocumentationKt.getHtmlMdnDocumentation(element2, tagContext);
        if (result2 == null && tagContext == null && (declaration = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findDescriptor(element2.getManager(), element2.getText(), originalElement), PsiMetaData::getDeclaration)) != null) {
            result2 = MdnDocumentationKt.getHtmlMdnDocumentation(declaration, null);
        }
        return result2;
    }

    private static HtmlAttributeDescriptor getDescriptor(String name, XmlTag context2) {
        HtmlAttributeDescriptor attributeDescriptor = HtmlDescriptorsTable.getAttributeDescriptor(name);
        if (attributeDescriptor instanceof CompositeAttributeTagDescriptor) {
            return ((CompositeAttributeTagDescriptor)attributeDescriptor).findHtmlAttributeInContext(context2);
        }
        return attributeDescriptor;
    }

    private String generateDocForHtml(PsiElement element2, PsiElement originalElement) {
        MdnSymbolDocumentation documentation = this.getDocumentation(element2, originalElement);
        if (documentation != null) {
            return documentation.getDocumentation(true, null);
        }
        if (element2 instanceof XmlEntityDecl) {
            XmlEntityDecl entityDecl = (XmlEntityDecl)element2;
            return new XmlDocumentationProvider().findDocRightAfterElement(element2, entityDecl.getName());
        }
        return null;
    }

    private PsiMetaData findDescriptor(PsiManager psiManager, String text2, PsiElement context2) {
        String key = StringUtil.toLowerCase((String)text2);
        HtmlTagDescriptor descriptor2 = HtmlDescriptorsTable.getTagDescriptor(key);
        if (descriptor2 != null && !this.isAttributeContext(context2)) {
            try {
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)psiManager.getProject()).createTagFromText((CharSequence)("<" + key + " xmlns=\"http://www.w3.org/1999/xhtml\"/>"));
                return tagFromText.getDescriptor();
            }
            catch (IncorrectOperationException tagFromText) {}
        } else {
            XmlTag tagContext = this.findTagContext(context2);
            HtmlAttributeDescriptor myAttributeDescriptor = HtmlDocumentationProvider.getDescriptor(key, tagContext);
            if (myAttributeDescriptor != null && tagContext != null) {
                XmlElementDescriptor tagDescriptor = tagContext.getDescriptor();
                return tagDescriptor != null ? tagDescriptor.getAttributeDescriptor(text2, tagContext) : null;
            }
        }
        return null;
    }

    protected boolean isAttributeContext(PsiElement context2) {
        PsiElement prevSibling;
        if (context2 instanceof XmlAttribute || context2 instanceof XmlToken && ((XmlToken)context2).getTokenType() == XmlTokenType.XML_TAG_END) {
            return true;
        }
        return context2 instanceof PsiWhiteSpace && (prevSibling = context2.getPrevSibling()) instanceof XmlAttribute;
    }

    protected XmlTag findTagContext(PsiElement context2) {
        PsiElement prevSibling;
        if (context2 instanceof PsiWhiteSpace && (prevSibling = context2.getPrevSibling()) instanceof XmlTag) {
            return (XmlTag)prevSibling;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class, (boolean)false);
    }

    @Nullable
    private static DocumentationProvider getScriptDocumentationProvider() {
        return (DocumentationProvider)ContainerUtil.getFirstItem((List)SCRIPT_PROVIDER_EP_NAME.getExtensionList());
    }

    @Nullable
    private DocumentationProvider getStyleProvider() {
        if (!this.myUseStyleProvider) {
            return null;
        }
        Language cssLanguage = Language.findLanguageByID((String)"CSS");
        if (cssLanguage != null) {
            return LanguageDocumentation.INSTANCE.forLanguage(cssLanguage);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/util/documentation/HtmlDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

