/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;

public final class MimeTypeDictionary {
    public static final String[] HTML_CONTENT_TYPES = ArrayUtilRt.toStringArray(MimeTypeDictionary.loadContentTypes());

    private static Set<String> loadContentTypes() {
        TreeSet<String> result2 = new TreeSet<String>();
        result2.add("*/*");
        MimeTypeDictionary.readMediaTypes(result2, "application");
        MimeTypeDictionary.readMediaTypes(result2, "audio");
        MimeTypeDictionary.readMediaTypes(result2, "image");
        MimeTypeDictionary.readMediaTypes(result2, "message");
        MimeTypeDictionary.readMediaTypes(result2, "model");
        MimeTypeDictionary.readMediaTypes(result2, "multipart");
        MimeTypeDictionary.readMediaTypes(result2, "text");
        MimeTypeDictionary.readMediaTypes(result2, "video");
        return result2;
    }

    private static void readMediaTypes(TreeSet<? super String> result2, String category) {
        String[] lines2;
        InputStream stream = MimeTypeDictionary.class.getResourceAsStream("mimeTypes/" + category + ".csv");
        String csv = "";
        try {
            csv = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : "";
        }
        catch (IOException e) {
            Logger.getInstance(MimeTypeDictionary.class).error((Throwable)e);
        }
        for (String line : lines2 = StringUtil.splitByLines((String)csv)) {
            String[] split2;
            if (line == lines2[0] || (split2 = line.split(",")).length <= 1) continue;
            result2.add(!split2[1].isEmpty() ? split2[1] : MimeTypeDictionary.withCategory(category, split2[0]));
        }
    }

    private static String withCategory(String category, String name) {
        int whitespacePosition = name.indexOf(32);
        return category + "/" + (whitespacePosition > 0 ? name.substring(0, whitespacePosition) : name);
    }
}

