/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;

public class StringValidation
implements JsonSchemaValidation {
    public static final StringValidation INSTANCE = new StringValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        StringValidation.checkString(propValue.getDelegate(), schema2, consumer);
    }

    private static void checkString(PsiElement propValue, JsonSchemaObject schema2, JsonValidationHost consumer) {
        String v = JsonSchemaAnnotatorChecker.getValue(propValue, schema2);
        if (v == null) {
            return;
        }
        String value2 = StringUtil.unquoteString((String)v);
        if (schema2.getMinLength() != null && value2.length() < schema2.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.string.shorter.than", schema2.getMinLength()), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema2.getMaxLength() != null && value2.length() > schema2.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.string.longer.than", schema2.getMaxLength()), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema2.getPattern() != null) {
            if (schema2.getPatternError() != null) {
                consumer.error(JsonBundle.message("schema.validation.invalid.string.pattern", StringUtil.convertLineSeparators((String)schema2.getPatternError())), propValue, JsonErrorPriority.LOW_PRIORITY);
            }
            if (!schema2.checkByPattern(value2)) {
                consumer.error(JsonBundle.message("schema.validation.string.violates.pattern", StringUtil.convertLineSeparators((String)schema2.getPattern())), propValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }
}

