/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryNonCapturingGroupInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnnecessaryNonCapturingGroupInspection.$$$reportNull$$$0(0);
        }
        return new UnnecessaryNonCapturingGroupVisitor(holder);
    }

    private static boolean hasOneBranch(RegExpPattern pattern) {
        return pattern != null && pattern.getBranches().length == 1;
    }

    private static RegExpAtom getSingleAtom(RegExpPattern pattern) {
        if (pattern == null) {
            return null;
        }
        RegExpBranch[] branches = pattern.getBranches();
        if (branches.length != 1) {
            return null;
        }
        RegExpAtom[] atoms = branches[0].getAtoms();
        return atoms.length != 1 ? null : atoms[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/UnnecessaryNonCapturingGroupInspection", "buildVisitor"));
    }

    private static class UnnecessaryNonCapturingGroupFix
    implements LocalQuickFix {
        private UnnecessaryNonCapturingGroupFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.unnecessary.non.capturing.group", new Object[0]);
            if (string == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                UnnecessaryNonCapturingGroupFix.$$$reportNull$$$0(2);
            }
            if (!((element2 = descriptor2.getPsiElement().getParent()) instanceof RegExpGroup)) {
                return;
            }
            RegExpGroup group2 = (RegExpGroup)element2;
            RegExpReplacementUtil.replaceInContext(group2, group2.getPattern().getUnescapedText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/UnnecessaryNonCapturingGroupInspection$UnnecessaryNonCapturingGroupFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/UnnecessaryNonCapturingGroupInspection$UnnecessaryNonCapturingGroupFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnnecessaryNonCapturingGroupVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        private UnnecessaryNonCapturingGroupVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpGroup(RegExpGroup group2) {
            super.visitRegExpGroup(group2);
            if (group2.getType() != RegExpGroup.Type.NON_CAPTURING) {
                return;
            }
            PsiElement parent = group2.getParent();
            RegExpAtom atom = UnnecessaryNonCapturingGroupInspection.getSingleAtom(group2.getPattern());
            if (atom != null) {
                if (!(parent instanceof RegExpClosure) || !(atom instanceof RegExpClosure)) {
                    this.registerProblem(group2);
                }
            } else if (parent instanceof RegExpBranch) {
                if (UnnecessaryNonCapturingGroupInspection.hasOneBranch(group2.getPattern())) {
                    this.registerProblem(group2);
                } else {
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof RegExpPattern && UnnecessaryNonCapturingGroupInspection.getSingleAtom((RegExpPattern)grandParent) != null) {
                        this.registerProblem(group2);
                    }
                }
            }
        }

        void registerProblem(RegExpGroup group2) {
            this.myHolder.registerProblem(group2.getFirstChild(), RegExpBundle.message("inspection.warning.unnecessary.non.capturing.group", group2.getText()), new LocalQuickFix[]{new UnnecessaryNonCapturingGroupFix()});
        }
    }
}

