/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.Nullable;

public class RegExpQuantifierImpl
extends RegExpElementImpl
implements RegExpQuantifier {
    private static final TokenSet TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpElementTypes.NUMBER, RegExpTT.COMMA});

    public RegExpQuantifierImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpQuantifier(this);
    }

    @Override
    public boolean isCounted() {
        return this.getNode().getFirstChildNode().getElementType() == RegExpTT.LBRACE;
    }

    @Override
    @Nullable
    public ASTNode getToken() {
        ASTNode node2 = this.getNode().getFirstChildNode();
        IElementType type = node2.getElementType();
        if (type == RegExpTT.LBRACE) {
            return null;
        }
        return node2;
    }

    @Override
    @Nullable
    public RegExpNumber getMin() {
        ASTNode[] nodes = this.getNode().getChildren(TOKENS);
        if (nodes.length == 0 || nodes[0].getElementType() != RegExpElementTypes.NUMBER) {
            return null;
        }
        return (RegExpNumber)nodes[0].getPsi();
    }

    @Override
    @Nullable
    public RegExpNumber getMax() {
        ASTNode[] nodes = this.getNode().getChildren(TOKENS);
        if (nodes.length == 0) {
            return null;
        }
        ASTNode node2 = nodes[nodes.length - 1];
        if (node2.getElementType() != RegExpElementTypes.NUMBER) {
            return null;
        }
        return (RegExpNumber)node2.getPsi();
    }

    @Override
    @Nullable
    public ASTNode getModifier() {
        ASTNode node2;
        IElementType type;
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        if (nodes.length > 1 && ((type = (node2 = nodes[1]).getElementType()) == RegExpTT.QUEST || type == RegExpTT.PLUS)) {
            return node2;
        }
        return null;
    }

    @Override
    public boolean isReluctant() {
        ASTNode modifier = this.getModifier();
        return modifier != null && modifier.getElementType() == RegExpTT.QUEST;
    }

    @Override
    public boolean isPossessive() {
        ASTNode modifier = this.getModifier();
        return modifier != null && modifier.getElementType() == RegExpTT.PLUS;
    }
}

