/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncAnnotation;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncFoldingBuilder
implements FoldingBuilder {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node2, @NotNull Document document) {
        if (node2 == null) {
            RncFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            RncFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList regions = new ArrayList();
        RncFoldingBuilder.process(node2, document, regions);
        FoldingDescriptor[] foldingDescriptorArray = regions.size() > 0 ? regions.toArray(FoldingDescriptor.EMPTY) : FoldingDescriptor.EMPTY;
        if (foldingDescriptorArray == null) {
            RncFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    public String getPlaceholderText(@NotNull ASTNode node2) {
        IElementType type;
        if (node2 == null) {
            RncFoldingBuilder.$$$reportNull$$$0(3);
        }
        if ((type = node2.getElementType()) == RncTokenTypes.LBRACE) {
            return "{ ... }";
        }
        if (RncFoldingBuilder.isCommentLike(type)) {
            return "# ...";
        }
        if (RncFoldingBuilder.isAnnotation(type)) {
            RncName element2 = ((RncAnnotation)node2.getPsi()).getNameElement();
            if (element2 != null) {
                ASTNode n = element2.getNode();
                assert (n != null);
                return EscapeUtil.unescapeText(n) + " [ ... ]";
            }
            return "[ ... ]";
        }
        return "...";
    }

    private static boolean isAnnotation(IElementType type) {
        return RncElementTypes.ANNOTATION == type || RncElementTypes.ANNOTATION_ELEMENT == type || RncElementTypes.FORWARD_ANNOTATION == type;
    }

    private static boolean isCommentLike(IElementType type) {
        return RncTokenTypes.COMMENTS.contains(type) || RncTokenTypes.DOC_TOKENS.contains(type);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node2) {
        if (node2 == null) {
            RncFoldingBuilder.$$$reportNull$$$0(4);
        }
        return RncFoldingBuilder.isCommentLike(node2.getElementType()) && CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
    }

    private static void process(@Nullable ASTNode node2, Document document, ArrayList<? super FoldingDescriptor> regions) {
        if (node2 == null) {
            return;
        }
        ASTNode[] braces = node2.getChildren(RncTokenTypes.BRACES);
        if (braces.length == 2) {
            ASTNode lbrace = braces[0];
            ASTNode rbrace = braces[1];
            if (RncFoldingBuilder.shouldFold(lbrace, rbrace, document)) {
                TextRange range2 = new TextRange(lbrace.getStartOffset(), rbrace.getTextRange().getEndOffset());
                regions.add((FoldingDescriptor)new FoldingDescriptor(lbrace, range2));
            }
        } else if (RncFoldingBuilder.isAnnotation(node2.getElementType()) && RncFoldingBuilder.isOnDifferentLine(node2.getFirstChildNode(), node2.getLastChildNode(), document)) {
            regions.add((FoldingDescriptor)new FoldingDescriptor(node2, node2.getTextRange()));
        }
        node2 = node2.getFirstChildNode();
        while (node2 != null) {
            node2 = RncFoldingBuilder.checkNodeAndSiblings(node2, RncTokenTypes.DOC_TOKENS, regions, document);
            node2 = RncFoldingBuilder.checkNodeAndSiblings(node2, RncTokenTypes.COMMENTS, regions, document);
            RncFoldingBuilder.process(node2, document, regions);
            if (node2 == null) continue;
            node2 = node2.getTreeNext();
        }
    }

    @Nullable
    private static ASTNode checkNodeAndSiblings(@Nullable ASTNode node2, TokenSet tokens, ArrayList<? super FoldingDescriptor> regions, Document document) {
        if (node2 != null && tokens.contains(node2.getElementType())) {
            ASTNode start2;
            ASTNode end = start2 = node2;
            if ((node2 = node2.getTreeNext()) != null) {
                do {
                    end = node2;
                } while ((node2 = node2.getTreeNext()) != null && tokens.contains(node2.getElementType()));
            }
            if (end != start2) {
                while (end.getPsi() instanceof PsiWhiteSpace) {
                    end = end.getTreePrev();
                }
                if (RncFoldingBuilder.isOnDifferentLine(start2, end, document)) {
                    regions.add((FoldingDescriptor)new FoldingDescriptor(start2, new TextRange(start2.getStartOffset(), end.getTextRange().getEndOffset())));
                }
            }
        }
        return node2;
    }

    private static boolean shouldFold(ASTNode first, ASTNode second, Document document) {
        if (first.getElementType() != RncTokenTypes.LBRACE) {
            return false;
        }
        if (second.getElementType() != RncTokenTypes.RBRACE) {
            return false;
        }
        return RncFoldingBuilder.isOnDifferentLine(first, second, document);
    }

    private static boolean isOnDifferentLine(ASTNode first, ASTNode second, Document document) {
        return document.getLineNumber(first.getStartOffset()) != document.getLineNumber(second.getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

