/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.ext.Locator2Impl;

class Psi2SaxAdapter
extends XmlElementVisitor
implements PsiElementProcessor<PsiElement> {
    private final ContentHandler myHandler;

    Psi2SaxAdapter(ContentHandler handler2) {
        this.myHandler = handler2;
    }

    public void visitXmlElement(XmlElement element2) {
        if (element2 instanceof XmlEntityRef) {
            XmlUtil.processXmlElements(element2, this, false, true);
        }
        super.visitXmlElement(element2);
    }

    public void visitXmlToken(XmlToken token2) {
        if (token2.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
            this.handleText((XmlElement)token2, token2.getText());
        }
    }

    private void handleText(XmlElement element2, String text2) {
        try {
            this.setLocation((PsiElement)element2);
            this.myHandler.characters(text2.toCharArray(), 0, text2.length());
        }
        catch (SAXException e) {
            throw new ParseError(e);
        }
    }

    public boolean execute(@NotNull PsiElement element2) {
        if (element2 == null) {
            Psi2SaxAdapter.$$$reportNull$$$0(0);
        }
        element2.accept((PsiElementVisitor)this);
        return true;
    }

    public void visitXmlDocument(XmlDocument document) {
        try {
            this.myHandler.startDocument();
            XmlTag rootTag = document.getRootTag();
            if (rootTag != null) {
                rootTag.accept((PsiElementVisitor)this);
            }
            this.myHandler.endDocument();
        }
        catch (SAXException e) {
            throw new ParseError(e);
        }
    }

    public void visitXmlTag(XmlTag tag2) {
        try {
            XmlAttribute[] xmlAttributes;
            String[] prefixes;
            this.setLocation((PsiElement)tag2);
            Map map2 = tag2.getLocalNamespaceDeclarations();
            for (String prefix2 : prefixes = ArrayUtilRt.toStringArray(map2.keySet())) {
                this.myHandler.startPrefixMapping(prefix2, (String)map2.get(prefix2));
            }
            Attributes2Impl atts = new Attributes2Impl();
            for (XmlAttribute attribute : xmlAttributes = tag2.getAttributes()) {
                String s = attribute.getName();
                if ("xmlns".equals(s) || s.startsWith("xmlns:")) continue;
                String uri = attribute.getNamespace();
                atts.addAttribute(s.contains(":") ? uri : "", attribute.getLocalName(), s, "PCDATA", attribute.getValue());
            }
            String namespace = tag2.getNamespace();
            String localName = tag2.getLocalName();
            String name = tag2.getName();
            this.myHandler.startElement(namespace, localName, name, atts);
            for (PsiElement child2 = tag2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                child2.accept((PsiElementVisitor)this);
            }
            this.myHandler.endElement(namespace, localName, name);
            for (int i2 = prefixes.length - 1; i2 >= 0; --i2) {
                String prefix3 = prefixes[i2];
                this.myHandler.endPrefixMapping(prefix3);
            }
        }
        catch (SAXException e) {
            throw new ParseError(e);
        }
    }

    public void visitXmlText(XmlText text2) {
        this.handleText((XmlElement)text2, text2.getValue());
    }

    private void setLocation(PsiElement text2) {
        PsiFile psiFile = text2.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)text2.getProject()).getDocument(psiFile);
        if (document == null) {
            return;
        }
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        Locator2Impl locator = new Locator2Impl();
        locator.setSystemId(VfsUtilCore.fixIDEAUrl((String)virtualFile2.getUrl()));
        int offset = text2.getTextRange().getEndOffset();
        int lineNumber = document.getLineNumber(offset);
        locator.setLineNumber(lineNumber + 1);
        locator.setColumnNumber(1 + offset - document.getLineStartOffset(lineNumber));
        this.myHandler.setDocumentLocator(locator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/validation/Psi2SaxAdapter", "execute"));
    }

    public static class ParseError
    extends RuntimeException {
        public ParseError(SAXException e) {
            super(e);
        }
    }
}

