/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\fH&J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "getBrowserFamily", "()Lcom/intellij/ide/browsers/BrowserFamily;", "requiresExtension", "", "getRequiresExtension", "()Z", "createDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "initialUrl", "Lcom/intellij/util/Url;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "usePreliminaryPage", "isBrowserSupported", "prepareDebugger", "Lorg/jetbrains/concurrency/Promise;", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.javascript.debugger"})
public abstract class JavaScriptDebugEngine {
    private final boolean requiresExtension;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract JavaScriptDebugProcess<VmConnection<?>> createDebugProcess(@NotNull XDebugSession var1, @NotNull WebBrowser var2, @NotNull DebuggableFileFinder var3, @Nullable Url var4, @Nullable ExecutionResult var5, boolean var6);

    @NotNull
    public final Promise<Unit> prepareDebugger(@NotNull Project project, @NotNull WebBrowser browser) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        if (this.getRequiresExtension()) {
            Promise promise3 = BrowserConnectionManager.getInstance().ensureExtensionInstalled(browser, project).then(new Function(browser, project){
                final /* synthetic */ WebBrowser $browser;
                final /* synthetic */ Project $project;

                public final void fun(Object it) {
                    BrowserConnectionManager.getInstance().launchBrowser(this.$browser, this.$project);
                }
                {
                    this.$browser = webBrowser;
                    this.$project = project;
                }
            });
            promise2 = promise3;
            Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"BrowserConnectionManager\u2026owser(browser, project) }");
        } else {
            promise2 = Promises.resolvedPromise();
        }
        return promise2;
    }

    @Nullable
    public WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().getFirstBrowserOrNull(this.getBrowserFamily());
    }

    @NotNull
    public abstract BrowserFamily getBrowserFamily();

    public boolean isBrowserSupported(@NotNull WebBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        return browser.getFamily() == this.getBrowserFamily();
    }

    public boolean getRequiresExtension() {
        return this.requiresExtension;
    }

    public JavaScriptDebugEngine() {
        this.requiresExtension = true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugEngine$Companion;", "", "()V", "findByBrowser", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "useExtension", "", "findByBrowserIdOrName", "Lcom/intellij/openapi/util/Pair;", "browserIdOrName", "", "intellij.javascript.debugger"})
    public static final class Companion {
        @JvmOverloads
        @Nullable
        public final Pair<JavaScriptDebugEngine, WebBrowser> findByBrowserIdOrName(@NotNull String browserIdOrName, boolean useExtension) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)browserIdOrName, (String)"browserIdOrName");
            WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(browserIdOrName);
            if (browser == null) {
                pair = (Pair)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)JavaScriptDebugEngineKt.getEngines()), (Function1)((Function1)new Function1<JavaScriptDebugEngine, Boolean>(useExtension, browserIdOrName){
                    final /* synthetic */ boolean $useExtension;
                    final /* synthetic */ String $browserIdOrName;

                    public final boolean invoke(@NotNull JavaScriptDebugEngine it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return JavaScriptDebugEngineKt.access$checkByBrowserIdOrName(it, this.$browserIdOrName) && it.getRequiresExtension() == this.$useExtension;
                    }
                    {
                        this.$useExtension = bl;
                        this.$browserIdOrName = string;
                        super(1);
                    }
                })), (Function1)findByBrowserIdOrName.2.INSTANCE));
            } else {
                JavaScriptDebugEngine javaScriptDebugEngine = this.findByBrowser(browser, useExtension);
                if (javaScriptDebugEngine != null) {
                    JavaScriptDebugEngine javaScriptDebugEngine2 = javaScriptDebugEngine;
                    boolean bl = false;
                    boolean bl2 = false;
                    JavaScriptDebugEngine it = javaScriptDebugEngine2;
                    boolean bl3 = false;
                    pair = Pair.pair((Object)it, (Object)browser);
                } else {
                    pair = null;
                }
            }
            return pair;
        }

        public static /* synthetic */ Pair findByBrowserIdOrName$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.findByBrowserIdOrName(string, bl);
        }

        @JvmOverloads
        @Nullable
        public final Pair<JavaScriptDebugEngine, WebBrowser> findByBrowserIdOrName(@NotNull String browserIdOrName) {
            return com.intellij.javascript.debugger.JavaScriptDebugEngine$Companion.findByBrowserIdOrName$default(this, browserIdOrName, false, 2, null);
        }

        @JvmOverloads
        @Nullable
        public final JavaScriptDebugEngine findByBrowser(@NotNull WebBrowser browser, boolean useExtension) {
            JavaScriptDebugEngine javaScriptDebugEngine;
            Object v0;
            JavaScriptDebugEngine it;
            boolean bl;
            Iterable iterable;
            boolean bl2;
            Iterable iterable2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                iterable2 = JavaScriptDebugEngineKt.getEngines();
                bl2 = false;
                iterable = iterable2;
                bl = false;
                for (Object t : iterable) {
                    it = (JavaScriptDebugEngine)t;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getBrowser(), (Object)browser) && it.getRequiresExtension() == useExtension)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((javaScriptDebugEngine = (JavaScriptDebugEngine)v0) == null) {
                Object v2;
                block4: {
                    iterable2 = JavaScriptDebugEngineKt.getEngines();
                    bl2 = false;
                    iterable = iterable2;
                    bl = false;
                    for (Object t : iterable) {
                        it = (JavaScriptDebugEngine)t;
                        boolean bl4 = false;
                        if (!(it.isBrowserSupported(browser) && it.getRequiresExtension() == useExtension)) continue;
                        v2 = t;
                        break block4;
                    }
                    v2 = null;
                }
                javaScriptDebugEngine = v2;
            }
            return javaScriptDebugEngine;
        }

        public static /* synthetic */ JavaScriptDebugEngine findByBrowser$default(Companion companion, WebBrowser webBrowser, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.findByBrowser(webBrowser, bl);
        }

        @JvmOverloads
        @Nullable
        public final JavaScriptDebugEngine findByBrowser(@NotNull WebBrowser browser) {
            return com.intellij.javascript.debugger.JavaScriptDebugEngine$Companion.findByBrowser$default(this, browser, false, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

