/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport$computeReceiverVariableUsingEvaluate$;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.MemberFilterVisitor;
import com.intellij.javascript.debugger.NavigatableVariable;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggerSupportUtils;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J>\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0)H\u0014J$\u0010*\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020-H\u0016J&\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020-H\u0002J2\u0010/\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002070\n2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0011J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010!2\u0006\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J,\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010!2\u0006\u00108\u001a\u0002092\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J\u001c\u0010<\u001a\u0004\u0018\u00010=2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u00104\u001a\u00020,H\u0016J\u001a\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020=2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010H\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010I\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010J\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010K\u001a\u0004\u0018\u00010!H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006L"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "scopeToMemberFilter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/debugger/Scope;", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "canNavigateToSource", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "name", "", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "computeObjectSpecificPresentation", "objectValue", "propertiesToShow", "", "computeReceiverVariable", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeReceiverVariableUsingEvaluate", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "createFrameEvaluator", "Lcom/intellij/javascript/debugger/ChromeEvaluator;", "frame", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getFileByUrlOrVmSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "tryToResolveByUrl", "getMemberFilter", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "functionName", "scriptUrl", "line", "", "column", "getVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "variableSourceName", "isInLibraryContent", "sourceInfo", "isMemberVisible", "rawNameToSource", "transformErrorOnGetUsedReferenceValue", "error", "intellij.javascript.debugger"})
public class JavaScriptDebuggerViewSupport
extends BasicDebuggerViewSupport {
    private final ConcurrentHashMap<Scope, Promise<MemberFilter>> scopeToMemberFilter;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public Vm getVm() {
        return this.debugProcess.getMainVm();
    }

    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkNotNullParameter((Object)sourceInfo, (String)"sourceInfo");
        return this.debugProcess.isLibraryFile(script, sourceInfo);
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (scope == null || scope.getType() != ScopeType.LOCAL || !(context.getParent() instanceof CallFrameView)) {
            return this.getDefaultMemberFilterPromise();
        }
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        CallFrameView callFrameView = (CallFrameView)variableContext;
        SourceInfo sourceInfo = callFrameView.getSourcePosition();
        if (sourceInfo == null) {
            return this.getDefaultMemberFilterPromise();
        }
        SourceInfo position = sourceInfo;
        Promise<MemberFilter> result2 = this.scopeToMemberFilter.get(scope);
        if (result2 != null) {
            return result2;
        }
        result2 = new MemberFilterVisitor(this, callFrameView).compute((XSourcePosition)position, (Promise<MemberFilter>)this.getDefaultMemberFilterPromise());
        Promise<MemberFilter> promise2 = this.scopeToMemberFilter.putIfAbsent(scope, result2);
        if (promise2 == null) {
            promise2 = result2;
        }
        return promise2;
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback2) {
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Value value = variable.getValue();
        if (value == null) {
            return ThreeState.NO;
        }
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"variable.value ?: return ThreeState.NO");
        Value value2 = value;
        ValueType valueType = value2.getType();
        if (value2 instanceof ObjectValue) {
            charSequence = ((ObjectValue)value2).getClassName();
            bl2 = false;
            bl = false;
            if (charSequence == null || charSequence.length() == 0) {
                charSequence = value2.getValueString();
                bl2 = false;
                bl = false;
                if ((charSequence == null || charSequence.length() == 0) && JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow().isEmpty()) {
                    return ThreeState.NO;
                }
            }
        }
        if (!(variable instanceof NavigatableVariable)) {
            if (valueType == ValueType.FUNCTION) {
                return ThreeState.NO;
            }
            JSVariable jSVariable = this.getVariable(name, context);
            if (jSVariable != null) {
                PsiElement navigationElement;
                charSequence = jSVariable;
                bl2 = false;
                bl = false;
                CharSequence it = charSequence;
                boolean bl3 = false;
                PsiElement psiElement = navigationElement = it.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"navigationElement");
                PsiFile psiFile = psiElement.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"navigationElement.containingFile");
                VirtualFile file2 = psiFile.getVirtualFile();
                VirtualFile virtualFile = file2;
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    VirtualFile it2 = virtualFile2;
                    boolean bl6 = false;
                    virtualFile = FileDocumentManager.getInstance().getDocument(it2);
                    if (virtualFile != null) {
                        virtualFile2 = virtualFile;
                        bl4 = false;
                        bl5 = false;
                        it2 = virtualFile2;
                        boolean bl7 = false;
                        callback2.computed(XDebuggerUtil.getInstance().createPositionByOffset(file2, navigationElement.getTextOffset()));
                        return ThreeState.YES;
                    }
                }
            }
            return ThreeState.NO;
        }
        NavigatableVariableBackedPsiElement navigatableVariable = (NavigatableVariableBackedPsiElement)variable;
        for (SmartPsiElementPointer<PsiElement> ref : navigatableVariable.getInlineReferences()) {
            Segment psiRange = ref.getPsiRange();
            if (psiRange == null) continue;
            callback2.computed(XDebuggerUtil.getInstance().createPositionByOffset(ref.getVirtualFile(), psiRange.getStartOffset()));
        }
        return ThreeState.YES;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Script script2 = script;
        if (script2 != null) {
            Script script3 = script2;
            boolean bl = false;
            boolean bl2 = false;
            Script it = script3;
            boolean bl3 = false;
            sourceInfo = this.getSourceInfo(frame.getFunctionName(), it, frame.getLine(), frame.getColumn());
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        Vm vm = this.getVm();
        if (vm != null && (vm = vm.getScriptManager()) != null && (vm = vm.findScriptByUrl(scriptUrl)) != null) {
            Vm vm2 = vm;
            boolean bl = false;
            boolean bl2 = false;
            Vm it = vm2;
            boolean bl3 = false;
            sourceInfo = this.getSourceInfo(functionName, (Script)it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.debugProcess.getSourceInfo(functionName, script, line, column);
    }

    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable);
    }

    /*
     * WARNING - void declaration
     */
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        void $this$onSuccess$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (value instanceof PresentationProvider && ((PresentationProvider)value).computePresentation(node, icon)) {
            return;
        }
        if (value.getType() == ValueType.NODE) {
            String string = value.getValueString();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            node.setPresentation(icon, new XValuePresentation(string2){
                final /* synthetic */ String $string;

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                    int index = StringsKt.indexOf$default((CharSequence)this.$string, (char)'#', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        String string = this.$string;
                        int n = 0;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        renderer.renderComment(string3);
                        string = this.$string;
                        n = 0;
                        String string4 = string;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(index);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                        renderer.renderValue(string5, CssHighlighter.CSS_IDENT);
                    } else {
                        renderer.renderComment(this.$string);
                    }
                }
                {
                    this.$string = $captured_local_variable$0;
                }
            }, true);
            return;
        }
        if (Intrinsics.areEqual((Object)value.getClassName(), (Object)value.getValueString()) ^ true) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        List propertiesToShow = JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow();
        if (this.computeObjectSpecificPresentation(value, variable, context, node, icon, propertiesToShow)) {
            return;
        }
        if (propertiesToShow.isEmpty() || value.hasProperties() == ThreeState.NO) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        Promise promise2 = value.getProperties(propertiesToShow, context.getEvaluateContext(), (Obsolescent)node);
        boolean $i$f$onSuccess = false;
        Promise promise3 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<List<? extends Variable>>((Obsolescent)node, (Obsolescent)node, node, value, icon){
            final /* synthetic */ Obsolescent $node;
            final /* synthetic */ XValueNode $node$inlined;
            final /* synthetic */ ObjectValue $value$inlined;
            final /* synthetic */ Icon $icon$inlined;
            {
                this.$node = $captured_local_variable$1;
                this.$node$inlined = xValueNode;
                this.$value$inlined = objectValue;
                this.$icon$inlined = icon;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void accept(Object param) {
                List it = (List)param;
                boolean bl = false;
                JavaScriptDebuggerViewSupportKt.doSetObjectPresentation(this.$node$inlined, it, this.$value$inlined, this.$icon$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onSuccess(object : Obsol\u2026m: T) = handler(param)\n})");
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
        promise3.onError((Consumer)new RejectErrorReporter(xDebugSession, null, 2, null));
    }

    protected boolean computeObjectSpecificPresentation(@NotNull ObjectValue objectValue, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon, @NotNull List<String> propertiesToShow) {
        Intrinsics.checkNotNullParameter((Object)objectValue, (String)"objectValue");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(propertiesToShow, (String)"propertiesToShow");
        return false;
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @NotNull
    public ChromeEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return new ChromeEvaluator((VariableContext)frame);
    }

    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value instanceof ObjectValue && (Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"TypeError") || Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"ReferenceError")) ? (Value)PrimitiveValue.UNDEFINED : super.transformErrorOnGetUsedReferenceValue(value, error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (variable instanceof NavigatableVariable) {
            return ((NavigatableVariable)variable).hasSourcePosition();
        }
        Scope scope = context.getScope();
        if (scope == null) return false;
        if (scope.getType() != ScopeType.LOCAL && scope.getType() != ScopeType.CLOSURE) {
            if (scope.getType() != ScopeType.CATCH) return false;
        }
        if (!(context.getParent() instanceof CallFrameView)) return false;
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        if (((CallFrameView)variableContext).getSourcePosition() == null) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
            if (variable instanceof NavigatableVariable) {
                navigatable.setSourcePosition(((NavigatableVariable)variable).getSourcePosition());
                return;
            }
            JSVariable jSVariable = this.getVariable(name, context);
            if (jSVariable == null) break block1;
            JSVariable jSVariable2 = jSVariable;
            boolean bl = false;
            boolean bl2 = false;
            JSVariable it = jSVariable2;
            boolean bl3 = false;
            navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)it)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSVariable getVariable(String variableSourceName, VariableContext context) {
        void result2;
        CallFrameView callFrameView;
        VariableContext variableContext = context.getParent();
        if (!(variableContext instanceof CallFrameView)) {
            variableContext = null;
        }
        if ((callFrameView = (CallFrameView)variableContext) == null || (callFrameView = callFrameView.getSourcePosition()) == null) {
            return null;
        }
        CallFrameView sourcePosition2 = callFrameView;
        VirtualFile virtualFile = sourcePosition2.getFile();
        int n = sourcePosition2.getOffset();
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.session.project");
        PsiElement psiElement = JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, n, project);
        if (psiElement == null) {
            return null;
        }
        PsiElement contextElement = psiElement;
        JSFunction jSFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
        PsiElement psiElement2 = jSFunction != null ? (PsiElement)jSFunction : (PsiElement)contextElement.getContainingFile();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement host = psiElement2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ((NavigatablePsiElement)host).accept((PsiElementVisitor)new JSElementVisitor((Ref.ObjectRef)result2, variableSourceName){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ String $variableSourceName;

            public void visitElement(@NotNull PsiElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if ((JSVariable)this.$result.element == null) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSParameter(@NotNull JSParameter node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = (JSVariable)node;
                } else {
                    super.visitJSParameter(node);
                }
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = node;
                } else {
                    super.visitJSVariable(node);
                }
            }
            {
                this.$result = $captured_local_variable$0;
                this.$variableSourceName = $captured_local_variable$1;
            }
        });
        return (JSVariable)result2.element;
    }

    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name");
        return this.debugProcess.normalizeMemberName(string);
    }

    @NotNull
    public final Promise<VirtualFile> getFileByUrlOrVmSource(@NotNull Script script, boolean tryToResolveByUrl) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Promise<VirtualFile> promise2 = (Promise<VirtualFile>)script.getUserData(VmScriptFileSystemKt.getVM_SCRIPT_FILE_KEY());
        if (promise2 != null && (promise2 = promise2.ensureDownloaded()) != null) {
            Promise<VirtualFile> promise3 = promise2;
            boolean bl = false;
            boolean bl2 = false;
            Promise<VirtualFile> it = promise3;
            boolean bl3 = false;
            return it;
        }
        Url url = script.getUrl();
        if (tryToResolveByUrl) {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            if (!StringsKt.endsWith$default((String)string, (String)"!transpiled", (boolean)false, (int)2, null)) {
                VirtualFile virtualFile = this.debugProcess;
                boolean bl = false;
                boolean bl4 = false;
                VirtualFile $this$run = virtualFile;
                boolean bl5 = false;
                VirtualFile virtualFile2 = $this$run.findFile(script);
                if (virtualFile2 != null) {
                    virtualFile = virtualFile2;
                    bl = false;
                    bl4 = false;
                    VirtualFile it = virtualFile;
                    boolean bl6 = false;
                    return Promises.resolvedPromise((Object)it);
                }
            }
        }
        Promise promise4 = VmScriptFileSystemKt.getVmFile(script).ensureDownloaded().onSuccess(new Consumer(this, url){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ Url $url;

            public final void accept(VirtualFile it) {
                JavaScriptDebugProcess<?> javaScriptDebugProcess = this.this$0.getDebugProcess();
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                javaScriptDebugProcess.saveResolvedFile(this.$url, virtualFile);
            }
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$url = url;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"getVmFile(script).ensure\u2026veResolvedFile(url, it) }");
        return promise4;
    }

    @NotNull
    public Promise<?> computeReceiverVariable(@NotNull VariableContext context, @NotNull CallFrame callFrame, @NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!Registry.is((String)"js.debugger.use.vm.receiver", (boolean)false)) {
            Promise<?> promise2 = this.computeReceiverVariableUsingEvaluate(callFrame, context, node);
            if (promise2 != null) {
                Promise<?> promise3 = promise2;
                boolean bl = false;
                boolean bl2 = false;
                Promise<?> it = promise3;
                boolean bl3 = false;
                return it;
            }
        }
        return super.computeReceiverVariable(context, callFrame, node);
    }

    private final Promise<?> computeReceiverVariableUsingEvaluate(CallFrame callFrame, VariableContext context, XCompositeNode node) {
        CallFrameView callFrameView;
        VariableContext parent;
        for (parent = context; parent != null && !(parent instanceof CallFrameView); parent = parent.getParent()) {
        }
        VariableContext variableContext = parent;
        if (!(variableContext instanceof CallFrameView)) {
            variableContext = null;
        }
        if ((callFrameView = (CallFrameView)variableContext) == null || (callFrameView = callFrameView.getSourcePosition()) == null || (callFrameView = callFrameView.getFile()) == null) {
            return null;
        }
        CallFrameView file2 = callFrameView;
        boolean $i$f$runReadAction = false;
        return (Promise)ApplicationManager.getApplication().runReadAction(new Computable(this, (VirtualFile)file2, callFrame, node, context){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ VirtualFile $file$inlined;
            final /* synthetic */ CallFrame $callFrame$inlined;
            final /* synthetic */ XCompositeNode $node$inlined;
            final /* synthetic */ VariableContext $context$inlined;
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$file$inlined = virtualFile;
                this.$callFrame$inlined = callFrame;
                this.$node$inlined = xCompositeNode;
                this.$context$inlined = variableContext;
            }

            /*
             * WARNING - void declaration
             */
            public final T compute() {
                Promise promise2;
                block5: {
                    boolean bl = false;
                    XDebugSession xDebugSession = this.this$0.getDebugProcess().getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    Project project = xDebugSession.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.session.project");
                    Project project2 = project;
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(this.$file$inlined);
                    if (psiFile == null) {
                        promise2 = null;
                    } else {
                        block6: {
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026return@runReadAction null");
                            PsiFile psiFile2 = psiFile;
                            try {
                                void $this$onError$iv;
                                Promise $this$onSuccess$iv;
                                Document document;
                                Document document2 = document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
                                Intrinsics.checkNotNull((Object)document2);
                                int offset = document2.getLineStartOffset(this.$callFrame$inlined.getLine()) + this.$callFrame$inlined.getColumn();
                                PsiElement psiElement = psiFile2.findElementAt(offset);
                                if (psiElement == null) {
                                    promise2 = null;
                                    break block5;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psiFile.findElementAt(of\u2026return@runReadAction null");
                                PsiElement elementAtOffset = psiElement;
                                PsiElement executionScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)elementAtOffset);
                                if (!(executionScope instanceof JSFunctionExpression) || !((JSFunctionExpression)executionScope).isArrowFunction()) break block6;
                                Promise promise3 = EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)this.$callFrame$inlined.getEvaluateContext(), (String)"this", null, (boolean)false, null, (int)14, null);
                                Obsolescent node$iv = (Obsolescent)this.$node$inlined;
                                boolean $i$f$onSuccess = false;
                                Promise promise4 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, node$iv, this){
                                    final /* synthetic */ Obsolescent $node;
                                    final /* synthetic */ computeReceiverVariableUsingEvaluate$$inlined$runReadAction$1 this$0;
                                    {
                                        this.$node = $captured_local_variable$1;
                                        this.this$0 = var3_3;
                                        super($super_call_param$2);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public void accept(Object param) {
                                        EvaluateResult it = (EvaluateResult)param;
                                        boolean bl = false;
                                        this.this$0.$node$inlined.addChildren(XValueChildrenList.singleton((XNamedValue)((XNamedValue)VariableViewKt.VariableView((Variable)((Variable)new VariableImpl("this", it.getValue())), (VariableContext)this.this$0.$context$inlined))), true);
                                    }
                                });
                                Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"onSuccess(object : Obsol\u2026m: T) = handler(param)\n})");
                                $this$onSuccess$iv = promise4;
                                node$iv = (Obsolescent)this.$node$inlined;
                                boolean $i$f$onError = false;
                                Promise promise5 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, node$iv, this){
                                    final /* synthetic */ Obsolescent $node;
                                    final /* synthetic */ computeReceiverVariableUsingEvaluate$$inlined$runReadAction$1 this$0;
                                    {
                                        this.$node = $captured_local_variable$1;
                                        this.this$0 = var3_3;
                                        super($super_call_param$2);
                                    }

                                    public void accept(@NotNull Throwable param) {
                                        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                                        Throwable it = param;
                                        boolean bl = false;
                                        this.this$0.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                                    }
                                });
                                promise2 = promise5;
                                Intrinsics.checkNotNullExpressionValue((Object)promise5, (String)"onError(object : Obsoles\u2026able) = handler(param)\n})");
                                break block5;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        promise2 = null;
                    }
                }
                return (T)promise2;
            }
        });
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public JavaScriptDebuggerViewSupport(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.scopeToMemberFilter = new ConcurrentHashMap();
        this.debugProcess.getConnection().addDebugListener(new DebugEventListener(){

            public void resumed(@NotNull Vm vm) {
                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                this.clear();
            }

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                this.clear();
            }

            private final void clear() {
                scopeToMemberFilter.clear();
            }
        });
    }
}

