/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.MemberFilterVisitorKt;
import com.intellij.javascript.debugger.MyMemberFilter;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.VariablesAndExpressionsCollector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Function;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bJ\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/MemberFilterVisitor;", "Lorg/jetbrains/debugger/PsiVisitors$Visitor;", "Lorg/jetbrains/debugger/MemberFilter;", "viewSupport", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "callFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "(Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;Lorg/jetbrains/debugger/frame/CallFrameView;)V", "transpiledFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "compute", "Lorg/jetbrains/concurrency/Promise;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "defaultMemberFilterPromise", "doCompute", "kotlin.jvm.PlatformType", "visit", "element", "Lcom/intellij/psi/PsiElement;", "positionOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.javascript.debugger"})
public final class MemberFilterVisitor
implements PsiVisitors.Visitor<MemberFilter> {
    private VirtualFile transpiledFile;
    private final JavaScriptDebuggerViewSupport viewSupport;
    private final CallFrameView callFrameView;

    @NotNull
    public final Promise<MemberFilter> compute(@NotNull XSourcePosition position, @NotNull Promise<MemberFilter> defaultMemberFilterPromise) {
        Promise promise2;
        SourceMap sourceMap;
        Script script;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(defaultMemberFilterPromise, (String)"defaultMemberFilterPromise");
        Script script2 = script = this.callFrameView.getScript();
        Object object = sourceMap = script2 != null ? script2.getSourceMap() : null;
        if (sourceMap != null && (sourceMap.getHasNameMappings() || Registry.is((String)"js.debugger.map.this.by.source.code", (boolean)false) || Registry.is((String)"js.debugger.name.mappings.by.source.code"))) {
            Promise promise3 = MemberFilterVisitorKt.findTranspiledFile(script).then(new Function(this, position){
                final /* synthetic */ MemberFilterVisitor this$0;
                final /* synthetic */ XSourcePosition $position;

                public final MemberFilter fun(VirtualFile it) {
                    MemberFilterVisitor.access$setTranspiledFile$p(this.this$0, it);
                    return MemberFilterVisitor.access$doCompute(this.this$0, this.$position);
                }
                {
                    this.this$0 = memberFilterVisitor;
                    this.$position = xSourcePosition;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"findTranspiledFile(scrip\u2026mpute(position)\n        }");
            return promise3;
        }
        MemberFilter result2 = this.doCompute(position);
        if (result2 == this.viewSupport) {
            promise2 = defaultMemberFilterPromise;
        } else {
            MemberFilter memberFilter = result2;
            Intrinsics.checkNotNullExpressionValue((Object)memberFilter, (String)"result");
            promise2 = Promises.resolvedPromise((Object)memberFilter);
        }
        return promise2;
    }

    private final MemberFilter doCompute(XSourcePosition position) {
        XDebugSession xDebugSession = this.viewSupport.getDebugProcess().getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"viewSupport.debugProcess.session");
        return (MemberFilter)PsiVisitors.visit((XSourcePosition)position, (Project)xDebugSession.getProject(), (PsiVisitors.Visitor)this, (Object)((Object)this.viewSupport));
    }

    @NotNull
    public MemberFilter visit(@NotNull XSourcePosition position, @NotNull PsiElement element, int positionOffset, @NotNull Document document) {
        PsiElement host;
        JSFunction jsFun;
        boolean bl;
        boolean bl2;
        SourceMap sourceMap;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        NameMapper nameMapper = null;
        Script script = this.callFrameView.getScript();
        Object object = sourceMap = script != null ? script.getSourceMap() : null;
        if (sourceMap != null && this.transpiledFile != null) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            VirtualFile virtualFile = this.transpiledFile;
            Intrinsics.checkNotNull((Object)virtualFile);
            Document transpiledDocument = fileDocumentManager.getDocument(virtualFile);
            if (transpiledDocument != null && transpiledDocument.getTextLength() > 0) {
                CallFrame callFrame = this.callFrameView.getCallFrame();
                MappingEntry mappingEntry = sourceMap.getGeneratedMappings().get(callFrame.getLine(), callFrame.getColumn());
                if (mappingEntry != null) {
                    MappingEntry mappingEntry2 = mappingEntry;
                    int n = 0;
                    bl2 = false;
                    MappingEntry it = mappingEntry2;
                    bl = false;
                    nameMapper = new JavaScriptNameMapper(document, transpiledDocument, sourceMap.findSourceMappings(it.getSource()), sourceMap, this.transpiledFile);
                }
            }
        }
        for (JavaScriptDebugAware debugAware : (MappingEntry)JavaScriptDebugAware.Companion.getEP_NAME().getExtensions()) {
            MemberFilter memberFilter = debugAware.createMemberFilter(nameMapper, element, positionOffset);
            if (memberFilter == null) continue;
            MemberFilter memberFilter2 = memberFilter;
            boolean bl3 = false;
            bl = false;
            MemberFilter it = memberFilter2;
            boolean bl4 = false;
            return it;
        }
        JSFunction jSFunction = jsFun = MemberFilterVisitorKt.access$getParentFunction(element);
        PsiElement psiElement = jSFunction != null ? (PsiElement)jSFunction : (PsiElement)element.getContainingFile();
        if (psiElement == null) {
            return (MemberFilter)this.viewSupport;
        }
        PsiElement psiElement2 = host = psiElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"host");
        VariablesAndExpressionsCollector visitor = new VariablesAndExpressionsCollector(positionOffset, psiElement2, nameMapper, element);
        if (jsFun == null) {
            ((NavigatablePsiElement)host).accept((PsiElementVisitor)visitor);
        } else {
            NameMapper nameMapper2 = nameMapper;
            if (nameMapper2 != null) {
                NameMapper nameMapper3 = nameMapper2;
                bl2 = false;
                boolean bl5 = false;
                NameMapper nameMapper4 = nameMapper3;
                boolean bl6 = false;
                JSParameter[] jSParameterArray = jsFun.getParameterVariables();
                Intrinsics.checkNotNullExpressionValue((Object)jSParameterArray, (String)"jsFun.parameterVariables");
                JSParameter[] $this$forEach$iv = jSParameterArray;
                boolean $i$f$forEach = false;
                JSParameter[] jSParameterArray2 = $this$forEach$iv;
                int n = jSParameterArray2.length;
                for (int i = 0; i < n; ++i) {
                    JSParameter element$iv;
                    JSParameter it = element$iv = jSParameterArray2[i];
                    boolean bl7 = false;
                    JSParameter jSParameter = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jSParameter, (String)"it");
                    NameMapper.map$default((NameMapper)nameMapper4, (PsiElement)((PsiElement)jSParameter), (boolean)false, (int)2, null);
                }
            }
            JSBlockStatement jSBlockStatement = jsFun.getBlock();
            if (jSBlockStatement != null) {
                jSBlockStatement.accept((PsiElementVisitor)visitor);
            }
        }
        Set<String> set2 = visitor.getVariableDeclaredAfter();
        Collection<NavigatableVariableBackedPsiElement> collection = visitor.getExpressions().values();
        Object object2 = nameMapper;
        if (object2 == null || (object2 = object2.getRawNameToSource()) == null) {
            object2 = MapsKt.emptyMap();
        }
        return (MemberFilter)new MyMemberFilter(set2, collection, (Map<String, String>)object2, this.viewSupport.getDebugProcess());
    }

    public MemberFilterVisitor(@NotNull JavaScriptDebuggerViewSupport viewSupport, @NotNull CallFrameView callFrameView) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewSupport), (String)"viewSupport");
        Intrinsics.checkNotNullParameter((Object)callFrameView, (String)"callFrameView");
        this.viewSupport = viewSupport;
        this.callFrameView = callFrameView;
    }

    public static final /* synthetic */ VirtualFile access$getTranspiledFile$p(MemberFilterVisitor $this) {
        return $this.transpiledFile;
    }

    public static final /* synthetic */ void access$setTranspiledFile$p(MemberFilterVisitor $this, VirtualFile virtualFile) {
        $this.transpiledFile = virtualFile;
    }

    public static final /* synthetic */ MemberFilter access$doCompute(MemberFilterVisitor $this, XSourcePosition position) {
        return $this.doCompute(position);
    }
}

